%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x0202020202020202", "0x0303030303030303", "0x0202020202020202", "0x0303030303030303"],
    "XMM1": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM2": ["0xFEFEFEFEFEFEFEFE", "0xFDFDFDFDFDFDFDFD", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x0202020202020202", "0x0303030303030303", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0xFEFEFEFE00000000", "0x03030303FD000300", "0x0000000000000000", "0x0000000000000000"],
    "XMM5": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM6": ["0xFEFEFEFEFEFEFEFE", "0xFDFDFDFDFDFDFDFD", "0xFEFEFEFEFEFEFEFE", "0xFDFDFDFDFDFDFDFD"],
    "XMM7": ["0x0202020202020202", "0x0303030303030303", "0x0202020202020202", "0x0303030303030303"],
    "XMM8": ["0xFEFEFEFE00000000", "0x03030303FD000300", "0xFEFEFEFE00000000", "0x03030303FD000300"]
  }
}
%endif

lea rdx, [rel .data]

vmovaps ymm0, [rdx + 32 * 4]

; Test with full zero
vpsignb xmm1, xmm0, [rdx + 32 * 0]
vpsignb ymm5, ymm0, [rdx + 32 * 0]

; Test with full negative
vpsignb xmm2, xmm0, [rdx + 32 * 1]
vpsignb ymm6, ymm0, [rdx + 32 * 1]

; Test with full positive
vpsignb xmm3, xmm0, [rdx + 32 * 2]
vpsignb ymm7, ymm0, [rdx + 32 * 2]

; Test a mix
vpsignb xmm4, xmm0, [rdx + 32 * 3]
vpsignb ymm8, ymm0, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000

dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF
dq 0xFFFFFFFFFFFFFFFF

dq 0x0101010101010101
dq 0x0101010101010101
dq 0x0101010101010101
dq 0x0101010101010101

dq 0xFFFFFFFF00000000
dq 0x01010101FF000100
dq 0xFFFFFFFF00000000
dq 0x01010101FF000100

dq 0x0202020202020202
dq 0x0303030303030303
dq 0x0202020202020202
dq 0x0303030303030303
