﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/bedrock-agent/model/AgentVersionSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgent {
namespace Model {
class ListAgentVersionsResult {
 public:
  AWS_BEDROCKAGENT_API ListAgentVersionsResult() = default;
  AWS_BEDROCKAGENT_API ListAgentVersionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BEDROCKAGENT_API ListAgentVersionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of objects, each of which contains information about a version of the
   * agent.</p>
   */
  inline const Aws::Vector<AgentVersionSummary>& GetAgentVersionSummaries() const { return m_agentVersionSummaries; }
  template <typename AgentVersionSummariesT = Aws::Vector<AgentVersionSummary>>
  void SetAgentVersionSummaries(AgentVersionSummariesT&& value) {
    m_agentVersionSummariesHasBeenSet = true;
    m_agentVersionSummaries = std::forward<AgentVersionSummariesT>(value);
  }
  template <typename AgentVersionSummariesT = Aws::Vector<AgentVersionSummary>>
  ListAgentVersionsResult& WithAgentVersionSummaries(AgentVersionSummariesT&& value) {
    SetAgentVersionSummaries(std::forward<AgentVersionSummariesT>(value));
    return *this;
  }
  template <typename AgentVersionSummariesT = AgentVersionSummary>
  ListAgentVersionsResult& AddAgentVersionSummaries(AgentVersionSummariesT&& value) {
    m_agentVersionSummariesHasBeenSet = true;
    m_agentVersionSummaries.emplace_back(std::forward<AgentVersionSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the total number of results is greater than the <code>maxResults</code>
   * value provided in the request, use this token when making another request in the
   * <code>nextToken</code> field to return the next batch of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAgentVersionsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAgentVersionsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AgentVersionSummary> m_agentVersionSummaries;
  bool m_agentVersionSummariesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgent
}  // namespace Aws
