/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.olsr.v1.info.proxy.Config;
import org.olsr.v1.info.proxy.OlsrdInfoReader;
import org.olsr.v1.info.proxy.api.InfoResult;
import org.olsr.v1.info.proxy.api.OlsrdInfoProxy;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;

@Component
@Designate(ocd=Config.class)
public class OlsrdInfoProxyImpl
implements OlsrdInfoProxy {
    private final Object configLock = new Object();
    private Config config = null;
    InetSocketAddress addressTxtInfo = new InetSocketAddress("127.0.0.1", 2006);
    InetSocketAddress addressJsonInfo = new InetSocketAddress("127.0.0.1", 2007);
    CopyOnWriteArrayList<Integer> usedPorts = new CopyOnWriteArrayList();
    private final Random random = new Random();

    private Config setupConfig(Config config) {
        Config preConfig = this.config;
        this.config = config;
        InetSocketAddress sa = new InetSocketAddress(this.config.address(), 0);
        if (!sa.isUnresolved()) {
            this.addressTxtInfo = new InetSocketAddress(this.config.address(), this.config.portTxtInfo());
            this.addressJsonInfo = new InetSocketAddress(this.config.address(), this.config.portJsonInfo());
        }
        return preConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    void activate(Config config) {
        Object object = this.configLock;
        synchronized (object) {
            this.setupConfig(config);
            this.usedPorts.clear();
            this.usedPorts.add(this.config.localPort());
        }
    }

    @Deactivate
    void deactivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    void modified(Config config) {
        Integer localPort;
        Integer preLocalPort;
        Object object = this.configLock;
        synchronized (object) {
            preLocalPort = this.config.localPort();
            this.setupConfig(config);
            localPort = this.config.localPort();
        }
        if (!localPort.equals(preLocalPort)) {
            this.usedPorts.remove(preLocalPort);
            this.usedPorts.add(0, localPort);
        }
    }

    Socket getSocket(int socketTimeout) {
        Socket socket = null;
        for (Integer port : this.usedPorts) {
            InetSocketAddress bindpoint = new InetSocketAddress(port);
            socket = new Socket();
            try {
                socket.setSoTimeout(socketTimeout);
                socket.setReuseAddress(true);
                socket.bind(bindpoint);
            }
            catch (IOException e) {
                socket = null;
            }
        }
        if (socket == null) {
            socket = new Socket();
            try {
                socket.setSoTimeout(socketTimeout);
                socket.setReuseAddress(true);
                socket.bind(null);
                Integer localPort = socket.getLocalPort();
                this.usedPorts.addIfAbsent(localPort);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        assert (socket != null);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendInternal(String command, List<String> txtInfo, StringBuilder jsonInfo) throws IOException {
        int retries;
        int randomSleep;
        InetSocketAddress address;
        int connectionTimeout;
        int socketTimeout;
        assert (txtInfo != null || jsonInfo != null);
        assert (txtInfo == null || jsonInfo == null);
        if (command == null || command.isEmpty()) {
            throw new IOException("No command specified");
        }
        Object object = this.configLock;
        synchronized (object) {
            socketTimeout = this.config.socketTimeout();
            connectionTimeout = this.config.connectionTimeout();
            address = txtInfo != null ? this.addressTxtInfo : this.addressJsonInfo;
            randomSleep = this.config.randomSleep();
            retries = this.config.connectionRetries();
        }
        for (int retry = 0; retry <= retries; ++retry) {
            try (Socket socket = this.getSocket(socketTimeout);){
                int r = OlsrdInfoReader.send(socket, command, connectionTimeout, socketTimeout, address, txtInfo, jsonInfo);
                if (r != 503) {
                    int n = r;
                    return n;
                }
            }
            try {
                Thread.sleep(Math.max(100, this.random.nextInt(randomSleep)));
                continue;
            }
            catch (InterruptedException e) {
                retry = retries;
            }
        }
        return 503;
    }

    public InfoResult getTxtInfo(String command) throws IOException {
        InfoResult result = new InfoResult();
        result.status = this.sendInternal(command, result.output, null);
        return result;
    }

    public InfoResult getJsonInfo(String command) throws IOException {
        InfoResult result = new InfoResult();
        StringBuilder sb = new StringBuilder();
        result.status = this.sendInternal(command, null, sb);
        result.output.add(sb.toString());
        return result;
    }
}

