// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include "spyview_ui.h"
#include "spypal_interface.H"
#include <FL/Fl_File_Chooser.H>

Fl_Double_Window *control=(Fl_Double_Window *)0;

Fl_Choice *filech=(Fl_Choice *)0;

Fl_Light_Button *plothistb=(Fl_Light_Button *)0;

static void cb_plothistb(Fl_Light_Button*, void*) {
  iw->plot_hist = plothistb->value();
iw->plotHist();
}

Fl_Light_Button *plotcmapb=(Fl_Light_Button *)0;

static void cb_plotcmapb(Fl_Light_Button*, void*) {
  iw->plot_cmap = plotcmapb->value();
iw->plotCmap();
}

Fl_Value_Input *centerv=(Fl_Value_Input *)0;

static void cb_centerv(Fl_Value_Input*, void*) {
  int newmin, newmax;
int width = iw->hmax - iw->hmin;
newmin = (int)centerv->value() - width/2;
newmax = (int)centerv->value() + width/2;
if (newmin < 0) 
{ newmin = 0; newmax = width; }
if (newmax > 65535)
{ newmin = 65535 - width; newmax = 65535;}
iw->hmin = newmin;
iw->hmax = newmax;
update_widgets();
}

Fl_Slider *centerslider=(Fl_Slider *)0;

static void cb_centerslider(Fl_Slider*, void*) {
  centerv->value(centerslider->value());
centerv->do_callback();
}

Fl_Roller *centerroller=(Fl_Roller *)0;

static void cb_centerroller(Fl_Roller*, void*) {
  centerv->value(centerroller->value());
centerv->do_callback();
}

Fl_Value_Input *centerv_units=(Fl_Value_Input *)0;

static void cb_centerv_units(Fl_Value_Input*, void*) {
  int val = iw->id.raw_to_quant(centerv_units->value());
centerv->value(val);
centerv->do_callback();
}

Fl_Value_Input *widthv=(Fl_Value_Input *)0;

static void cb_widthv(Fl_Value_Input*, void*) {
  int newmin, newmax;
int width = (int)widthv->value();
if (width < 0) width = 0;
if (width > 65535) width = 65535;
int center = (iw->hmax + iw->hmin)/2;
newmin = center - width/2;
newmax = center + width/2;
if (newmin < 0) newmin = 0;
if (newmax > 65535) newmax = 65535;
iw->hmax = newmax;
iw->hmin = newmin;
update_widgets();
}

Fl_Slider *widthslider=(Fl_Slider *)0;

static void cb_widthslider(Fl_Slider*, void*) {
  widthv->value(widthslider->value());
widthv->do_callback();
}

Fl_Roller *widthroller=(Fl_Roller *)0;

static void cb_widthroller(Fl_Roller*, void*) {
  widthv->value(widthroller->value());
widthv->do_callback();
}

Fl_Value_Input *widthv_units=(Fl_Value_Input *)0;

static void cb_widthv_units(Fl_Value_Input*, void*) {
  int val = iw->id.raw_to_quant(widthv_units->value())-iw->id.raw_to_quant(0);;
widthv->value(val);
widthv->do_callback();
}

Fl_Value_Input *minv=(Fl_Value_Input *)0;

static void cb_minv(Fl_Value_Input*, void*) {
  iw->setMin(minv->value());
update_widgets();
}

Fl_Slider *minslider=(Fl_Slider *)0;

static void cb_minslider(Fl_Slider*, void*) {
  minv->value(minslider->value());
minv->do_callback();
}

Fl_Roller *minroller=(Fl_Roller *)0;

static void cb_minroller(Fl_Roller*, void*) {
  iw->setMin(minroller->value());
update_widgets();
}

Fl_Value_Input *minv_units=(Fl_Value_Input *)0;

static void cb_minv_units(Fl_Value_Input*, void*) {
  minv->value(iw->id.raw_to_quant(minv_units->value()));
minv->do_callback();
}

Fl_Value_Input *maxv=(Fl_Value_Input *)0;

static void cb_maxv(Fl_Value_Input*, void*) {
  iw->setMax(maxv->value());
update_widgets();
}

Fl_Slider *maxslider=(Fl_Slider *)0;

static void cb_maxslider(Fl_Slider*, void*) {
  maxv->value(maxslider->value());
maxv->do_callback();
}

Fl_Roller *maxroller=(Fl_Roller *)0;

static void cb_maxroller(Fl_Roller*, void*) {
  iw->setMax(maxroller->value());
update_widgets();
}

Fl_Value_Input *maxv_units=(Fl_Value_Input *)0;

static void cb_maxv_units(Fl_Value_Input*, void*) {
  maxv->value(iw->id.raw_to_quant(maxv_units->value()));
maxv->do_callback();
}

Fl_Value_Input *gammav=(Fl_Value_Input *)0;

static void cb_gammav(Fl_Value_Input*, void*) {
  iw->setGamma(gammav->value(), gcenterv->value());
plotcmapb->do_callback();
gammaroller->value(log(gammav->value()));
gammaslider->value(log(gammav->value()));
}

Fl_Slider *gammaslider=(Fl_Slider *)0;

static void cb_gammaslider(Fl_Slider*, void*) {
  double val = round(exp(gammaslider->value())*1000)/1000;
gammav->value(val);
gammaroller->value(gammaslider->value());
gammav->do_callback();
}

Fl_Roller *gammaroller=(Fl_Roller *)0;

static void cb_gammaroller(Fl_Roller*, void*) {
  double val = round(exp(gammaroller->value())*1000)/1000;
gammav->value(val);
gammaslider->value(gammaroller->value());
gammav->do_callback();
}

Fl_Light_Button *squareb=(Fl_Light_Button *)0;

static void cb_squareb(Fl_Light_Button*, void*) {
  iw->square = squareb->value();
reload_data();
}

static void cb_Image(Fl_Button*, void*) {
  if (procwin->shown())
 procwin->hide();
else
 procwin->show();
}

static void cb_Axis(Fl_Button*, void*) {
  if (unitswin->shown())
 unitswin->hide();
else
 unitswin->show();
}

Fl_Choice *cmapch=(Fl_Choice *)0;

Fl_Light_Button *invertb=(Fl_Light_Button *)0;

static void cb_invertb(Fl_Light_Button*, void*) {
  iw->invert = !iw->invert;
cmapch->do_callback();
}

Fl_Light_Button *negateb=(Fl_Light_Button *)0;

static void cb_negateb(Fl_Light_Button*, void*) {
  iw->negate = negateb->value();
cmapch->do_callback();
}

Fl_Button *normb=(Fl_Button *)0;

static void cb_normb(Fl_Button*, void*) {
  iw->normalize();
update_widgets();
}

static void cb_Load(Fl_Button*, void*) {
  if (normwin->shown())
  normwin->hide();
else 
  normwin->show();
}

Fl_Value_Input *bpbox=(Fl_Value_Input *)0;

static void cb_bpbox(Fl_Value_Input*, void*) {
  iw->bpercent=bpbox->value();
normb->do_callback();
}

Fl_Value_Input *wpbox=(Fl_Value_Input *)0;

static void cb_wpbox(Fl_Value_Input*, void*) {
  iw->wpercent=wpbox->value();
normb->do_callback();
}

Fl_Input *savebox=(Fl_Input *)0;

static void cb_savebox(Fl_Input*, void*) {
  strncpy(iw->output_basename,savebox->value(),256);
}

Fl_Button *saveb=(Fl_Button *)0;

Fl_Button *dismissb=(Fl_Button *)0;

static void cb_dismissb(Fl_Button*, void*) {
  control->hide();
}

Fl_Button *exitb=(Fl_Button *)0;

static void cb_exitb(Fl_Button*, void*) {
  spyview_exit();
}

static void cb_reset(Fl_Button*, void*) {
  gammav->value(1);
gammav->do_callback();
}

Fl_Button *xsecb=(Fl_Button *)0;

static void cb_xsecb(Fl_Button*, void*) {
  Fl_Window *w = xsecwin;
if (w->shown())
 w->hide();
else
 w->show();
}

static void cb_Save(Fl_Button*, void*) {
  //iw->exportGnuplot();
iw->exportMTX(true);
}

Fl_Button *location_bar=(Fl_Button *)0;

static void cb_location_bar(Fl_Button*, void*) {
  if (location_window->shown())
   location_window->hide();
else
   location_window->show();
}

Fl_Output *help_bar=(Fl_Output *)0;

Fl_Box *colormap_placeholder=(Fl_Box *)0;

Fl_Button *exportb=(Fl_Button *)0;

static void cb_exportb(Fl_Button*, void*) {
  switch (export_type->value())
{
case 0:
	iw->exportMTX();
	break;
case 1:
	iw->exportPGM();
	break;
case 2:
	iw->exportGnuplot();
	break;
case 3:
	iw->exportMAT();
	break;
case 4:
	iw->exportLinecut();
	break;
case 5:
	iw->exportMatlab();
	break;
};
}

Fl_Value_Input *xzoom_value=(Fl_Value_Input *)0;

static void cb_xzoom_value(Fl_Value_Input*, void*) {
  iw->setXZoom(xzoom_value->value());
}

Fl_Value_Input *yzoom_value=(Fl_Value_Input *)0;

static void cb_yzoom_value(Fl_Value_Input*, void*) {
  iw->setYZoom(yzoom_value->value());
}

Fl_Slider *cmap_min=(Fl_Slider *)0;

static void cb_cmap_min(Fl_Slider*, void*) {
  if (cmap_min->value() > cmap_max->value())
	cmap_min->value(cmap_max->value());
iw->cmap_min = cmap_min->value();
cmapch->do_callback();
}

Fl_Slider *cmap_max=(Fl_Slider *)0;

static void cb_cmap_max(Fl_Slider*, void*) {
  if (cmap_max->value() < cmap_min->value())
	cmap_max->value(cmap_min->value());
iw->cmap_max = cmap_max->value();
cmapch->do_callback();
}

static void cb_Load1(Fl_Button*, void*) {
  Fl_Window *w = reload_window;
if (w->shown())
 w->hide();
else
 w->show();
}

static void cb_Postscript(Fl_Button*, void*) {
  iw->setupPS();
}

static void cb_Save1(Fl_Button*, void*) {
  if (Fl::event_state() & FL_SHIFT)
{
	Fl_File_Chooser chooser(".", 
			"(*.svs)\t",
			Fl_File_Chooser::CREATE,
			"Select files");
	chooser.preview(0);
	chooser.show();
	while (chooser.shown()) Fl::wait();
	if (chooser.value() == NULL) return;
	savesettings(chooser.value(1));
}
else
{
	char *fname = fl_file_chooser("Save Settings","Settings (*.svs)",spyviewSettingsDir);
	if(fname != NULL)
	  savesettings(fname);
};
}

static void cb_Load2(Fl_Button*, void*) {
  if (Fl::event_state() & FL_SHIFT)
{
	Fl_File_Chooser chooser(".", 
			"(*.svs)\t",
			Fl_File_Chooser::CREATE,
			"Select files");
	chooser.preview(0);
	chooser.show();
	while (chooser.shown()) Fl::wait();
	if (chooser.value() == NULL) return;
	loadsettings(chooser.value(1));
}
else
{
	char *fname = fl_file_chooser("Load Spyview Settings","Settings (*.svs)",spyviewSettingsDir);
	if(fname != NULL)
  		loadsettings(fname);
};
}

Fl_Value_Output *xsize=(Fl_Value_Output *)0;

Fl_Value_Output *ysize=(Fl_Value_Output *)0;

Fl_Value_Input *gcenterv=(Fl_Value_Input *)0;

static void cb_gcenterv(Fl_Value_Input*, void*) {
  iw->setGamma(gammav->value(), gcenterv->value());
plotcmapb->do_callback();
gcenterroller->value(gcenterv->value());
gcenterslider->value(gcenterv->value());
}

Fl_Slider *gcenterslider=(Fl_Slider *)0;

static void cb_gcenterslider(Fl_Slider*, void*) {
  gcenterv->value(gcenterslider->value());
gcenterv->do_callback();
}

Fl_Roller *gcenterroller=(Fl_Roller *)0;

static void cb_gcenterroller(Fl_Roller*, void*) {
  gcenterv->value(gcenterroller->value());
gcenterv->do_callback();
}

static void cb_reset1(Fl_Button*, void*) {
  gcenterv->value(0);
gcenterv->do_callback();
}

Fl_Choice *export_type=(Fl_Choice *)0;

Fl_Menu_Item menu_export_type[] = {
 {".mtx", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {".pgm", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {".gp/.gnu (gnuplot)", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {".dat (ascii matrix)", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"linecut .dat", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {".m (matlab script)", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

static void cb_Edit(Fl_Button*, void*) {
  if (cmapedwin->shown())
  cmapedwin->hide();
else 
  cmapedwin->show();
}

static void cb_Fixed(Fl_Button*, void*) {
  norm_on_load->value(0);
man_quant->value(1);
a_quant->value(0);
iw->id.auto_quant = false;
iw->id.qmin = qmin->value();
iw->id.qmax = qmax->value();
info("Set qmin/qmax to %f %f\n", qmin->value(), qmax->value());
}

static void cb_Auto(Fl_Button*, void*) {
  norm_on_load->value(1);
man_quant->value(0);
a_quant->value(1);
a_quant->do_callback();
}

static void cb_Reload(Fl_Button*, void*) {
  filech->do_callback();
}

static void cb_Plane(Fl_Button*, void*) {
  if (plane_win->shown())
	plane_win->hide();
else 
	plane_win->show();
}

static void cb_Load3(Fl_Button*, void*) {
  loadColors(NULL);
}

static void cb_Save2(Fl_Button*, void*) {
  saveColors(NULL);
}

static void cb_Load4(Fl_Button*, void*) {
  Fl_File_Chooser chooser(".", 
			"(*.colors)\t",
			Fl_File_Chooser::SINGLE,
			"Select files");
chooser.preview(0);
chooser.show();
while (chooser.shown()) Fl::wait();
if (chooser.value() == NULL) return;
loadColors((char*)chooser.value(1));
}

static void cb_Save3(Fl_Button*, void*) {
  Fl_File_Chooser chooser(".", 
			"(*.colors)\t",
			Fl_File_Chooser::CREATE,
			"Select files");
chooser.preview(0);
chooser.show();
while (chooser.shown()) Fl::wait();
if (chooser.value() == NULL) return;
saveColors((char *)chooser.value(1));
}

#include <FL/Fl_Image.H>
static unsigned char idata_edit[] =
{255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,115,149,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,
115,149,255,255,115,149,255,255,115,149,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
255,255,0,255,255,115,149,255,255,115,149,255,255,115,149,255,255,115,149,255,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,255,255,0,255,255,255,0,255,255,255,0,255,255,115,149,255,255,
115,149,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,255,255,255,0,255,255,255,0,255,255,255,
0,255,255,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,8,255,255,0,230,255,255,0,255,255,255,
0,255,255,255,0,255,255,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,
255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,255,255,0,255,255,255,0,255,255,255,0,255,255,255,0,255,255,255,
0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,209,255,147,255,209,255,147,255,255,255,0,255,255,255,
0,255,255,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,209,255,147,255,209,255,147,255,
209,255,147,255,255,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,209,
255,147,255,209,255,147,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255};
static Fl_RGB_Image image_edit(idata_edit, 18, 13, 4, 0);

ImageWindow *iw=(ImageWindow *)0;

Fl_Double_Window *procwin=(Fl_Double_Window *)0;

Fl_Output *proc_description=(Fl_Output *)0;

static void cb_input(Fl_Input*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_input1(Fl_Input*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_input2(Fl_Input*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_input3(Fl_Input*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_input4(Fl_Input*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_button(Fl_Check_Button*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_button1(Fl_Check_Button*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_button2(Fl_Check_Button*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_button3(Fl_Check_Button*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_button4(Fl_Check_Button*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

Fl_Check_Button *enable_filter=(Fl_Check_Button *)0;

static void cb_enable_filter(Fl_Check_Button*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

Fl_Browser *options=(Fl_Browser *)0;

static void cb_options(Fl_Browser* o, void*) {
  Image_Operation *op = (Image_Operation *)o->data(o->value());
if(op != NULL)
  Set_ProcWindow_Settings(op);
last_proc_side = o;
pqueue->deselect();
}

Fl_Browser *pqueue=(Fl_Browser *)0;

static void cb_pqueue(Fl_Browser* o, void*) {
  Image_Operation *op = (Image_Operation *)o->data(o->value());
last_proc_side = o;
if(op != NULL)
  Set_ProcWindow_Settings(op);
options->deselect();
}

static void cb_add(Fl_Button*, void*) {
  int n = options->value();
Image_Operation *op = (Image_Operation *)options->data(n);
if(op != NULL)
{
  Add_Image_Operation(op);
  reload_data();
  pqueue->select(pqueue->size());
  pqueue->do_callback();
}
else
{
  if (n != 0)
    pqueue->add(options->text(n));
  reload_data();
  pqueue->select(pqueue->size());
  pqueue->do_callback();  
};
}

static void cb_remove(Fl_Button*, void*) {
  int n = pqueue->value();
if (n != 0)
{
  Image_Operation *op = (Image_Operation *)pqueue->data(n);
  delete op; // This is safe ; delete does nothing if op is null.
  pqueue->remove(n);
  reload_data();
};
}

static void cb_clear(Fl_Button*, void*) {
  for(int i = 1; i < pqueue->size(); i++)
{
  Image_Operation *op = (Image_Operation *)pqueue->data(i);
  delete op;
}
pqueue->clear();
reload_data();
}

static void cb_up(Fl_Button*, void*) {
  int n = pqueue->value();
if (n > 1)
{
 pqueue->move(n,n-1);
 reload_data();
 };
}

static void cb_down(Fl_Button*, void*) {
  int n = pqueue->value();
if ((n > 0) && (n < pqueue->size()))
{
 pqueue->move(n,n+1);
 reload_data();
};
}

static void cb_dismiss(Fl_Button*, void*) {
  procwin->hide();
}

static void cb_def(Fl_Button*, void*) {
  loadImageProcessing(NULL);
}

static void cb_def1(Fl_Button*, void*) {
  saveImageProcessing(NULL);
}

static void cb_Load5(Fl_Button*, void*) {
  Fl_File_Chooser chooser(".", 
			"(*.img_proc)\t",
			Fl_File_Chooser::SINGLE,
			"Select files");
chooser.preview(0);
chooser.show();
while (chooser.shown()) Fl::wait();
if (chooser.value() == NULL) return;
loadImageProcessing((char*)chooser.value(1));
}

static void cb_Save4(Fl_Button*, void*) {
  Fl_File_Chooser chooser(".", 
			"(*.img_proc)\t",
			Fl_File_Chooser::CREATE,
			"Select files");
chooser.preview(0);
chooser.show();
while (chooser.shown()) Fl::wait();
if (chooser.value() == NULL) return;
saveImageProcessing((char*)chooser.value(1));
}

static void cb_choice(Fl_Choice*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_choice1(Fl_Choice*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_choice2(Fl_Choice*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_choice3(Fl_Choice*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

static void cb_choice4(Fl_Choice*, void*) {
  Image_Operation *op = (Image_Operation *)last_proc_side->data(last_proc_side->value());
if(op != NULL)
  Fetch_ProcWindow_Settings(op);
if(last_proc_side == pqueue)
  reload_data();
}

Fl_Double_Window *normwin=(Fl_Double_Window *)0;

static void cb_Dismiss(Fl_Button*, void*) {
  normwin->hide();
}

Fl_Round_Button *keep_zoom=(Fl_Round_Button *)0;

static void cb_keep_zoom(Fl_Round_Button*, void*) {
  iw->window_size_action = KEEPZOOM;
}

Fl_Round_Button *keep_size=(Fl_Round_Button *)0;

static void cb_keep_size(Fl_Round_Button*, void*) {
  iw->window_size_action = KEEPSIZE;
}

Fl_Round_Button *reset_zoom=(Fl_Round_Button *)0;

static void cb_reset_zoom(Fl_Round_Button*, void*) {
  iw->window_size_action = RESETZOOM;
}

Fl_Check_Button *norm_on_load=(Fl_Check_Button *)0;

static void cb_(Fl_Group*, void*) {
  iw->id.auto_quant = true;
}

Fl_Round_Button *a_quant=(Fl_Round_Button *)0;

static void cb_a_quant(Fl_Round_Button*, void*) {
  iw->id.auto_quant = true;
}

Fl_Round_Button *man_quant=(Fl_Round_Button *)0;

static void cb_man_quant(Fl_Round_Button*, void*) {
  iw->id.auto_quant = false;
}

Fl_Value_Input *a_quant_percent=(Fl_Value_Input *)0;

static void cb_a_quant_percent(Fl_Value_Input*, void*) {
  iw->id.auto_quant_percent = a_quant_percent->value();
requantize->do_callback();
}

Fl_Group *manual_quant=(Fl_Group *)0;

Fl_Value_Input *qmin=(Fl_Value_Input *)0;

static void cb_qmin(Fl_Value_Input*, void*) {
  iw->id.qmin = qmin->value();
}

Fl_Value_Input *qmax=(Fl_Value_Input *)0;

static void cb_qmax(Fl_Value_Input*, void*) {
  iw->id.qmax = qmax->value();
}

static void cb_Use(Fl_Button*, void*) {
  double d1 = minv_units->value();
double d2 = maxv_units->value();
qmin->value(-0.5*d2+1.5*d1);
qmin->do_callback();
}

static void cb_Use1(Fl_Button*, void*) {
  double d1 = minv_units->value();
double d2 = maxv_units->value();
qmax->value(1.5*d2+0.5*d1);
qmax->do_callback();
}

Fl_Round_Button *dat_type_mat=(Fl_Round_Button *)0;

static void cb_dat_type_mat(Fl_Round_Button*, void*) {
  iw->id.datfile_type = MATRIX;
}

Fl_Round_Button *dat_type_gp=(Fl_Round_Button *)0;

static void cb_dat_type_gp(Fl_Round_Button*, void*) {
  iw->id.datfile_type = GNUPLOT;
}

Fl_Round_Button *gp_type_col=(Fl_Round_Button *)0;

static void cb_gp_type_col(Fl_Round_Button*, void*) {
  iw->id.gpload_type = COLUMNS;
}

Fl_Round_Button *gp_type_index=(Fl_Round_Button *)0;

static void cb_gp_type_index(Fl_Round_Button*, void*) {
  //info("type is: %d\n", iw->id.gpload_type);
iw->id.gpload_type = INDEX;
//info("type is: %d\n", iw->id.gpload_type);
}

Fl_Round_Button *dat_type_delft=(Fl_Round_Button *)0;

static void cb_dat_type_delft(Fl_Round_Button*, void*) {
  iw->id.datfile_type = DELFT_LEGACY;
}

Fl_Check_Button *gp_parse_txt=(Fl_Check_Button *)0;

static void cb_gp_parse_txt(Fl_Check_Button*, void*) {
  iw->id.mtx.parse_txt = gp_parse_txt->value();
}

Fl_Check_Button *gp_delft_raw=(Fl_Check_Button *)0;

static void cb_gp_delft_raw(Fl_Check_Button*, void*) {
  iw->id.mtx.delft_raw_units = gp_delft_raw->value();
}

Fl_Round_Button *dat_type_meta=(Fl_Round_Button *)0;

static void cb_dat_type_meta(Fl_Round_Button*, void*) {
  iw->id.datfile_type = DAT_META;
}

Fl_Check_Button *gp_delft_set=(Fl_Check_Button *)0;

static void cb_gp_delft_set(Fl_Check_Button*, void*) {
  iw->id.mtx.delft_settings = gp_delft_set->value();
}

Fl_Button *requantize=(Fl_Button *)0;

static void cb_requantize(Fl_Button*, void*) {
  double imgmin = minv_units->value();
double imgmax = maxv_units->value();

iw->id.qmin = qmin->value();
iw->id.qmax = qmax->value();

iw->id.quantize();
iw->setMin(iw->id.raw_to_quant(imgmin));
iw->setMax(iw->id.raw_to_quant(imgmax));
update_widgets();
}

static void cb_Reload1(Fl_Button*, void*) {
  filech->do_callback();
}

Fl_Value_Input *gp_col=(Fl_Value_Input *)0;

static void cb_gp_col(Fl_Value_Input*, void*) {
  iw->id.gp_column = gp_col->value()-1;
}

Fl_Double_Window *unitswin=(Fl_Double_Window *)0;

Fl_Value_Input *xmin=(Fl_Value_Input *)0;

static void cb_xmin(Fl_Value_Input*, void*) {
  set_units();
}

Fl_Value_Input *xmax=(Fl_Value_Input *)0;

static void cb_xmax(Fl_Value_Input*, void*) {
  set_units();
}

Fl_Input *xunitname=(Fl_Input *)0;

static void cb_xunitname(Fl_Input*, void*) {
  set_units();
}

Fl_Value_Input *ymin=(Fl_Value_Input *)0;

static void cb_ymin(Fl_Value_Input*, void*) {
  set_units();
}

Fl_Value_Input *ymax=(Fl_Value_Input *)0;

static void cb_ymax(Fl_Value_Input*, void*) {
  set_units();
}

Fl_Input *yunitname=(Fl_Input *)0;

static void cb_yunitname(Fl_Input*, void*) {
  set_units();
}

Fl_Value_Input *zmin=(Fl_Value_Input *)0;

Fl_Value_Input *zmax=(Fl_Value_Input *)0;

Fl_Input *zunitname=(Fl_Input *)0;

static void cb_zunitname(Fl_Input*, void*) {
  set_units();
}

Fl_Input *gpusing=(Fl_Input *)0;

static void cb_gpusing(Fl_Input*, void*) {
  snprintf(iw->gp_using_string, 256, "%s", gpusing->value());
iw->plotLineCut();
}

Fl_Input *gpwith=(Fl_Input *)0;

static void cb_gpwith(Fl_Input*, void*) {
  iw->gp_with_string = gpwith->value();
iw->plotLineCut();
}

static void cb_Send(Fl_Input* o, void*) {
  if(iw->gplinecut.isopen())
  iw->gplinecut.cmd("%s\nreplot\n",o->value());
o->position(0,o->size());
}

static void cb_Dismiss1(Fl_Button*, void*) {
  unitswin->hide();
}

Fl_Choice *axis_type=(Fl_Choice *)0;

static void cb_axis_type(Fl_Choice*, void*) {
  if (axis_type->value() == 0)
  iw->lc_axis = XAXIS;
else if (axis_type->value() == 1)
  iw->lc_axis = YAXIS;
else
  iw->lc_axis = DISTANCE;

iw->plotLineCut();
}

Fl_Menu_Item menu_axis_type[] = {
 {"X axis", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Y axis", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Distance", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Light_Button *xrange=(Fl_Light_Button *)0;

static void cb_xrange(Fl_Light_Button*, void*) {
  iw->line_cut_xauto = xrange->value();
}

Fl_Double_Window *xsecwin=(Fl_Double_Window *)0;

Fl_Group *units3d=(Fl_Group *)0;

Fl_Input *mtx_xname=(Fl_Input *)0;

static void cb_mtx_xname(Fl_Input*, void*) {
  set_3d_units();
}

Fl_Input *mtx_yname=(Fl_Input *)0;

static void cb_mtx_yname(Fl_Input*, void*) {
  set_3d_units();
}

Fl_Input *mtx_zname=(Fl_Input *)0;

static void cb_mtx_zname(Fl_Input*, void*) {
  set_3d_units();
}

Fl_Value_Input *mtx_xmin=(Fl_Value_Input *)0;

static void cb_mtx_xmin(Fl_Value_Input*, void*) {
  set_3d_units();
}

Fl_Value_Input *mtx_ymin=(Fl_Value_Input *)0;

static void cb_mtx_ymin(Fl_Value_Input*, void*) {
  set_3d_units();
}

Fl_Value_Input *mtx_zmin=(Fl_Value_Input *)0;

static void cb_mtx_zmin(Fl_Value_Input*, void*) {
  set_3d_units();
}

Fl_Value_Input *mtx_xmax=(Fl_Value_Input *)0;

static void cb_mtx_xmax(Fl_Value_Input*, void*) {
  set_3d_units();
}

Fl_Value_Input *mtx_ymax=(Fl_Value_Input *)0;

static void cb_mtx_ymax(Fl_Value_Input*, void*) {
  set_3d_units();
}

Fl_Value_Input *mtx_zmax=(Fl_Value_Input *)0;

static void cb_mtx_zmax(Fl_Value_Input*, void*) {
  set_3d_units();
}

Fl_Value_Output *mtx_x=(Fl_Value_Output *)0;

Fl_Value_Output *mtx_y=(Fl_Value_Output *)0;

Fl_Value_Output *mtx_z=(Fl_Value_Output *)0;

Fl_Group *controls3d=(Fl_Group *)0;

Fl_Value_Input *indexbox=(Fl_Value_Input *)0;

static void cb_indexbox(Fl_Value_Input*, void*) {
  double val=indexbox->value();
indexslider->value(val);
indexroller->value(val);
indexbox->value(val);
// iw->load_mtx_cut( indexbox->value(), (mtxcut_t)(int)dim->mvalue()->user_data());

//#this will make the pointer lose precision, will it still work?
// int t = *( (int*) (&( ) );
iw->load_mtx_cut( indexbox->value(), (mtxcut_t)(long)dim->mvalue()->user_data());

if (norm_on_load->value())
    iw->normalize();
update_title();
}

Fl_Slider *indexslider=(Fl_Slider *)0;

static void cb_indexslider(Fl_Slider*, void*) {
  indexbox->value(indexslider->value());
indexbox->do_callback();
}

Fl_Roller *indexroller=(Fl_Roller *)0;

static void cb_indexroller(Fl_Roller*, void*) {
  indexbox->value(indexroller->value());
indexbox->do_callback();
}

Fl_Value_Output *index_value=(Fl_Value_Output *)0;

Fl_Choice *dim=(Fl_Choice *)0;

static void cb_dim(Fl_Choice*, void*) {
  //info("dim has value %d\n", dim->value());
//   int t = *(int*)(&dim->mvalue()->user_data());

iw->load_mtx_cut(indexbox->value(), (mtxcut_t)(long)dim->mvalue()->user_data());
if (norm_on_load->value())
    iw->normalize();
}

Fl_Menu_Item menu_dim[] = {
 {"YZ", 0,  0, (void*)(YZ), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"ZX", 0,  0, (void*)(XZ), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"XY", 0,  0, (void*)(XY), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

static void cb_dismiss1(Fl_Button*, void*) {
  xsecwin->hide();
}

Fl_Light_Button *mtx_label=(Fl_Light_Button *)0;

static void cb_mtx_label(Fl_Light_Button*, void*) {
  iw->id.do_mtx_cut_title = mtx_label->value();
indexbox->do_callback();
}

Fl_Double_Window *reload_window=(Fl_Double_Window *)0;

Fl_Input *reload_text=(Fl_Input *)0;

static void cb_Dismiss2(Fl_Button*, void*) {
  reload_window->hide();
}

static void cb_Browse(Fl_Button*, void*) {
  Fl_File_Chooser chooser(".", 
			"Spyview Files (*.{mtx,pgm,dat,Stm})\t"
			"MTX (*.mtx)\t"
			"PGM (*.pgm)\t"
			"dat (*.dat)\t"
			"Stm (*.Stm)\t",
			Fl_File_Chooser::MULTI,
			"Select files");
chooser.preview(0);
chooser.show();
while (chooser.shown()) Fl::wait();
if (chooser.value() == NULL) return;

if (replaceb->value()) clear_files();

for ( int i=1; i<=chooser.count(); i++ ) 
{
	info("adding %s\n", chooser.value(i));
	add_file(chooser.value(i));
}

if (check_loaded() == 0)
{
      warn("No files found!! Reverting to the list\nof files given on command line.");
      load_orig_files();
}

filech->value(0);
filech->do_callback();
}

Fl_Round_Button *replaceb=(Fl_Round_Button *)0;

Fl_Double_Window *cmapedwin=(Fl_Double_Window *)0;

Fl_Value_Slider *cmrot=(Fl_Value_Slider *)0;

static void cb_cmrot(Fl_Value_Slider*, void*) {
  double val = cmrot->value();
if (val < -360.1)
  val = val - 360.0*floor(val/360.0);
if (val > 360.1 || val < -360.1)
  val = val - 360.0*ceil(val/360.0);
iw->colormap_rotation_angle=val;
cmrot_roller->value(val);
cmrot->value(val);
cmapch->do_callback();
}

static void cb_zero(Fl_Button*, void*) {
  cmrot->value(0.0);
cmrot->do_callback();
}

Fl_Button *m60=(Fl_Button *)0;

static void cb_m60(Fl_Button*, void*) {
  cmrot->value(cmrot->value()-60);
cmrot->do_callback();
}

Fl_Roller *cmrot_roller=(Fl_Roller *)0;

static void cb_cmrot_roller(Fl_Roller*, void*) {
  cmrot->value(cmrot_roller->value());
cmrot->do_callback();
}

Fl_Button *p60=(Fl_Button *)0;

static void cb_p60(Fl_Button*, void*) {
  cmrot->value(cmrot->value()+60);
cmrot->do_callback();
}

static void cb_Dismiss3(Fl_Button*, void*) {
  cmapedwin->hide();
}

Fl_Double_Window *location_window=(Fl_Double_Window *)0;

Fl_Output *location_x=(Fl_Output *)0;

Fl_Output *location_y=(Fl_Output *)0;

Fl_Output *location_data=(Fl_Output *)0;

Fl_Input *location_fmt=(Fl_Input *)0;

static void cb_dismiss2(Fl_Button*, void*) {
  location_window->hide();
}

Fl_Group *zoom_group=(Fl_Group *)0;

Fl_Output *zx1v=(Fl_Output *)0;

Fl_Output *zx2v=(Fl_Output *)0;

Fl_Output *zy2v=(Fl_Output *)0;

Fl_Output *zy1v=(Fl_Output *)0;

Fl_Value_Output *zx1=(Fl_Value_Output *)0;

Fl_Value_Output *zx2=(Fl_Value_Output *)0;

Fl_Value_Output *zy2=(Fl_Value_Output *)0;

Fl_Value_Output *zy1=(Fl_Value_Output *)0;

Fl_Value_Output *x_col=(Fl_Value_Output *)0;

Fl_Value_Output *y_row=(Fl_Value_Output *)0;

Fl_Output *data_name=(Fl_Output *)0;

Fl_Double_Window *helpwin=(Fl_Double_Window *)0;

Fl_Text_Display *help_text=(Fl_Text_Display *)0;

static void cb_Dismiss4(Fl_Button*, void*) {
  helpwin->hide();
}

Fl_Double_Window *plane_win=(Fl_Double_Window *)0;

Fl_Light_Button *planeb=(Fl_Light_Button *)0;

static void cb_planeb(Fl_Light_Button*, void*) {
  iw->plane = planeb->value();
iw->redraw();
iw->plotLineCut();
}

Fl_Button *fitplane=(Fl_Button *)0;

static void cb_fitplane(Fl_Button*, void*) {
  iw->fit_plane();
update_widgets();
iw->normalize();
iw->redraw();
iw->plotLineCut();
}

Fl_Button *zeroplane=(Fl_Button *)0;

static void cb_zeroplane(Fl_Button*, void*) {
  plane_a->value(0.0);
plane_a->do_callback();
plane_b->value(0.0);
plane_b->do_callback();
}

Fl_Value_Input *plane_a=(Fl_Value_Input *)0;

static void cb_plane_a(Fl_Value_Input*, void*) {
  iw->plane_a = (65535.0/(double)iw->h)*plane_a->value();
info("plane_a %.3f iw->plane_a %.3f\n", plane_a->value(), iw->plane_a);
plane_aroller->value(plane_a->value());
plane_aslider->value(plane_a->value());
iw->redraw();
iw->calculateHistogram();
iw->plotLineCut();
update_widgets();
info("plane_a %.3f iw->plane_a %.3f\n\n", plane_a->value(), iw->plane_a);
}

Fl_Slider *plane_aslider=(Fl_Slider *)0;

static void cb_plane_aslider(Fl_Slider* o, void*) {
  plane_a->value(((Fl_Valuator *) o)->value() );
plane_a->do_callback();
}

Fl_Roller *plane_aroller=(Fl_Roller *)0;

static void cb_plane_aroller(Fl_Roller* o, void*) {
  plane_a->value(((Fl_Valuator *) o)->value() );
plane_a->do_callback();
}

Fl_Value_Input *plane_b=(Fl_Value_Input *)0;

static void cb_plane_b(Fl_Value_Input*, void*) {
  iw->plane_b = (65535.0/(double)iw->w)*plane_b->value();
plane_broller->value(plane_b->value());
plane_bslider->value(plane_b->value());
iw->redraw();
iw->calculateHistogram();
iw->plotLineCut();
update_widgets();
}

Fl_Slider *plane_bslider=(Fl_Slider *)0;

static void cb_plane_bslider(Fl_Slider* o, void*) {
  plane_b->value(((Fl_Valuator *) o)->value() );
plane_b->do_callback();
}

Fl_Roller *plane_broller=(Fl_Roller *)0;

static void cb_plane_broller(Fl_Roller* o, void*) {
  plane_b->value(((Fl_Valuator *) o)->value() );
plane_b->do_callback();
}

static void cb_dismiss3(Fl_Button*, void*) {
  plane_win->hide();
}

void make_window() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = control = new Fl_Double_Window(570, 425, "Controls");
    w = o;
    { Fl_Choice* o = filech = new Fl_Choice(50, 5, 190, 25, "file:");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)filech_cb);
      o->when(FL_WHEN_RELEASE_ALWAYS);
    }
    { Fl_Light_Button* o = plothistb = new Fl_Light_Button(75, 35, 75, 25, "Plot Hist.");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_plothistb);
    }
    { Fl_Light_Button* o = plotcmapb = new Fl_Light_Button(155, 35, 85, 25, "Plot Colmap");
      o->labelsize(11);
      o->callback((Fl_Callback*)cb_plotcmapb);
    }
    { Fl_Value_Input* o = centerv = new Fl_Value_Input(55, 65, 50, 20, "center");
      o->maximum(65535);
      o->step(1);
      o->textsize(9);
      o->callback((Fl_Callback*)cb_centerv);
    }
    { Fl_Slider* o = centerslider = new Fl_Slider(105, 65, 135, 20);
      o->type(3);
      o->maximum(65535);
      o->callback((Fl_Callback*)cb_centerslider);
    }
    { Fl_Roller* o = centerroller = new Fl_Roller(105, 85, 135, 20);
      o->type(1);
      o->maximum(65535);
      o->step(10);
      o->callback((Fl_Callback*)cb_centerroller);
    }
    { Fl_Value_Input* o = centerv_units = new Fl_Value_Input(35, 85, 70, 20);
      o->color((Fl_Color)53);
      o->textsize(9);
      o->callback((Fl_Callback*)cb_centerv_units);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Value_Input* o = widthv = new Fl_Value_Input(55, 110, 50, 20, "width");
      o->maximum(65535);
      o->step(1);
      o->value(1);
      o->textsize(9);
      o->callback((Fl_Callback*)cb_widthv);
    }
    { Fl_Slider* o = widthslider = new Fl_Slider(105, 110, 135, 20);
      o->type(3);
      o->maximum(65535);
      o->callback((Fl_Callback*)cb_widthslider);
    }
    { Fl_Roller* o = widthroller = new Fl_Roller(105, 130, 135, 20);
      o->type(1);
      o->maximum(65535);
      o->step(10);
      o->callback((Fl_Callback*)cb_widthroller);
    }
    { Fl_Value_Input* o = widthv_units = new Fl_Value_Input(35, 130, 70, 20);
      o->color((Fl_Color)53);
      o->textsize(9);
      o->callback((Fl_Callback*)cb_widthv_units);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Value_Input* o = minv = new Fl_Value_Input(55, 155, 50, 20, "min");
      o->maximum(65535);
      o->step(1);
      o->textsize(9);
      o->callback((Fl_Callback*)cb_minv);
    }
    { Fl_Slider* o = minslider = new Fl_Slider(105, 155, 135, 20);
      o->type(3);
      o->maximum(65535);
      o->callback((Fl_Callback*)cb_minslider);
    }
    { Fl_Roller* o = minroller = new Fl_Roller(105, 175, 135, 20);
      o->type(1);
      o->maximum(65535);
      o->step(10);
      o->callback((Fl_Callback*)cb_minroller);
    }
    { Fl_Value_Input* o = minv_units = new Fl_Value_Input(35, 175, 70, 20);
      o->color((Fl_Color)53);
      o->textsize(9);
      o->callback((Fl_Callback*)cb_minv_units);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Value_Input* o = maxv = new Fl_Value_Input(55, 200, 50, 20, "max");
      o->maximum(65535);
      o->step(1);
      o->value(1);
      o->textsize(9);
      o->callback((Fl_Callback*)cb_maxv);
    }
    { Fl_Slider* o = maxslider = new Fl_Slider(105, 200, 135, 20);
      o->type(3);
      o->maximum(65535);
      o->callback((Fl_Callback*)cb_maxslider);
    }
    { Fl_Roller* o = maxroller = new Fl_Roller(105, 220, 135, 20);
      o->type(1);
      o->maximum(65535);
      o->step(10);
      o->callback((Fl_Callback*)cb_maxroller);
    }
    { Fl_Value_Input* o = maxv_units = new Fl_Value_Input(35, 220, 70, 20);
      o->color(FL_LIGHT2);
      o->textsize(9);
      o->callback((Fl_Callback*)cb_maxv_units);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Value_Input* o = gammav = new Fl_Value_Input(55, 245, 50, 20, "gamma");
      o->labelsize(12);
      o->value(1);
      o->callback((Fl_Callback*)cb_gammav);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Slider* o = gammaslider = new Fl_Slider(105, 245, 135, 20);
      o->type(3);
      o->minimum(-4.6);
      o->maximum(4.6);
      o->step(0.001);
      o->callback((Fl_Callback*)cb_gammaslider);
    }
    { Fl_Roller* o = gammaroller = new Fl_Roller(105, 265, 135, 20);
      o->type(1);
      o->minimum(-4.6);
      o->maximum(4.6);
      o->callback((Fl_Callback*)cb_gammaroller);
    }
    { Fl_Light_Button* o = squareb = new Fl_Light_Button(5, 335, 85, 25, "Square");
      o->callback((Fl_Callback*)cb_squareb);
    }
    { Fl_Button* o = new Fl_Button(95, 335, 145, 25, "Image Processing");
      o->callback((Fl_Callback*)cb_Image);
    }
    { Fl_Button* o = new Fl_Button(5, 365, 140, 25, "Axis Units && Ranges");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Axis);
    }
    { Fl_Choice* o = cmapch = new Fl_Choice(315, 5, 140, 25, "ColorMap");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cmapch_cb);
      o->when(FL_WHEN_RELEASE_ALWAYS);
    }
    { Fl_Light_Button* o = invertb = new Fl_Light_Button(335, 40, 75, 25, "Invert");
      o->tooltip("Individually invert each color channel");
      o->callback((Fl_Callback*)cb_invertb);
    }
    { Fl_Light_Button* o = negateb = new Fl_Light_Button(415, 40, 70, 25, "Negate");
      o->tooltip("Negate the data before plotting");
      o->callback((Fl_Callback*)cb_negateb);
    }
    { Fl_Button* o = normb = new Fl_Button(250, 40, 80, 25, "Normalize");
      o->callback((Fl_Callback*)cb_normb);
    }
    { Fl_Button* o = new Fl_Button(250, 70, 115, 25, "Load Options");
      o->callback((Fl_Callback*)cb_Load);
    }
    { Fl_Value_Input* o = bpbox = new Fl_Value_Input(315, 110, 50, 25, "Black %");
      o->maximum(100);
      o->step(0.1);
      o->callback((Fl_Callback*)cb_bpbox);
    }
    { Fl_Value_Input* o = wpbox = new Fl_Value_Input(435, 110, 50, 25, "White %");
      o->maximum(100);
      o->step(0.1);
      o->callback((Fl_Callback*)cb_wpbox);
    }
    { Fl_Input* o = savebox = new Fl_Input(320, 300, 245, 25, "basename:");
      o->labelsize(11);
      o->textsize(10);
      o->callback((Fl_Callback*)cb_savebox);
    }
    { Fl_Button* o = saveb = new Fl_Button(415, 335, 70, 25, "Save PPM");
      o->tooltip("Save color image as PPM");
      o->labelsize(12);
      o->callback((Fl_Callback*)saveb_cb);
    }
    { Fl_Button* o = dismissb = new Fl_Button(460, 365, 60, 25, "dismiss");
      o->callback((Fl_Callback*)cb_dismissb);
    }
    { Fl_Button* o = exitb = new Fl_Button(525, 365, 40, 25, "exit");
      o->shortcut(0x80071);
      o->callback((Fl_Callback*)cb_exitb);
    }
    { Fl_Button* o = new Fl_Button(55, 265, 50, 20, "reset");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_reset);
    }
    { Fl_Button* o = xsecb = new Fl_Button(150, 365, 90, 25, "3D XSection");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_xsecb);
    }
    { Fl_Button* o = new Fl_Button(250, 335, 80, 25, "Save MTX");
      o->tooltip("Save the file with an MTX extension");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Save);
    }
    { Fl_Button* o = location_bar = new Fl_Button(5, 395, 210, 25, "button");
      o->labelsize(10);
      o->callback((Fl_Callback*)cb_location_bar);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Output* o = help_bar = new Fl_Output(215, 395, 240, 25);
      o->color(FL_BACKGROUND_COLOR);
      o->textfont(8);
      o->textsize(10);
    }
    { Fl_Box* o = colormap_placeholder = new Fl_Box(495, 35, 35, 260);
      o->box(FL_DOWN_BOX);
    }
    { Fl_Button* o = new Fl_Button(495, 5, 70, 25, "Save Cmap");
      o->labelsize(10);
      o->callback((Fl_Callback*)save_cmap_cb);
    }
    { Fl_Button* o = exportb = new Fl_Button(335, 335, 75, 25, "Export");
      o->tooltip("Export data to file basename.export.xxx");
      o->callback((Fl_Callback*)cb_exportb);
    }
    { Fl_Value_Input* o = xzoom_value = new Fl_Value_Input(515, 395, 25, 25);
      o->tooltip("X Zoom");
      o->minimum(-100);
      o->maximum(100);
      o->callback((Fl_Callback*)cb_xzoom_value);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Value_Input* o = yzoom_value = new Fl_Value_Input(540, 395, 25, 25);
      o->tooltip("Y  Zoom");
      o->minimum(-100);
      o->maximum(100);
      o->callback((Fl_Callback*)cb_yzoom_value);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Slider* o = cmap_min = new Fl_Slider(534, 35, 15, 260);
      o->minimum(1);
      o->maximum(0);
      o->callback((Fl_Callback*)cb_cmap_min);
    }
    { Fl_Slider* o = cmap_max = new Fl_Slider(550, 35, 15, 260);
      o->minimum(1);
      o->maximum(0);
      o->value(1);
      o->callback((Fl_Callback*)cb_cmap_max);
    }
    { Fl_Button* o = new Fl_Button(5, 35, 65, 25, "Load...");
      o->tooltip("Add or load new files from a pattern or browser");
      o->labelsize(13);
      o->callback((Fl_Callback*)cb_Load1);
    }
    { Fl_Button* o = new Fl_Button(490, 335, 75, 25, "Postscript");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Postscript);
    }
    { Fl_Button* o = new Fl_Button(250, 365, 105, 25, "Save Settings");
      o->tooltip("Save the spyview settings");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Save1);
    }
    { Fl_Button* o = new Fl_Button(360, 365, 95, 25, "Load Settings");
      o->tooltip("Load the Spyview settings");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Load2);
    }
    { Fl_Value_Output* o = xsize = new Fl_Value_Output(455, 395, 30, 25);
      o->tooltip("Data Height");
      o->textsize(11);
    }
    { Fl_Value_Output* o = ysize = new Fl_Value_Output(485, 395, 30, 25);
      o->tooltip("Data Width");
      o->textsize(11);
    }
    { Fl_Value_Input* o = gcenterv = new Fl_Value_Input(55, 290, 50, 20, "gamma");
      o->labelsize(12);
      o->maximum(0.999);
      o->callback((Fl_Callback*)cb_gcenterv);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Slider* o = gcenterslider = new Fl_Slider(105, 290, 135, 20);
      o->type(3);
      o->maximum(0.999);
      o->step(0.001);
      o->callback((Fl_Callback*)cb_gcenterslider);
    }
    { Fl_Roller* o = gcenterroller = new Fl_Roller(105, 310, 135, 20);
      o->type(1);
      o->maximum(0.999);
      o->callback((Fl_Callback*)cb_gcenterroller);
    }
    { Fl_Button* o = new Fl_Button(55, 310, 50, 20, "reset");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_reset1);
    }
    { Fl_Box* o = new Fl_Box(20, 308, 32, 17, "center");
      o->labelsize(12);
      o->align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
    }
    { Fl_Choice* o = export_type = new Fl_Choice(350, 270, 135, 25, "Export Type:");
      o->down_box(FL_BORDER_BOX);
      o->menu(menu_export_type);
    }
    { Fl_Button* o = new Fl_Button(370, 70, 115, 25, "Edit cmap...");
      o->callback((Fl_Callback*)cb_Edit);
    }
    { Fl_Button* o = new Fl_Button(255, 145, 110, 25, "Fixed colors");
      o->tooltip("Keep colormapping and quantization fixed for new images (Disable normalize an\
d Autoquantize)");
      o->callback((Fl_Callback*)cb_Fixed);
    }
    { Fl_Button* o = new Fl_Button(370, 145, 115, 25, "Auto colors");
      o->tooltip("Audjust colormap and quantization for each image (Re-enable normalize and aut\
o quantize)");
      o->callback((Fl_Callback*)cb_Auto);
    }
    { Fl_Button* o = new Fl_Button(255, 175, 100, 25, "Reload file");
      o->callback((Fl_Callback*)cb_Reload);
    }
    { Fl_Button* o = new Fl_Button(360, 175, 125, 25, "Plane settings");
      o->callback((Fl_Callback*)cb_Plane);
    }
    { Fl_Button* o = new Fl_Button(320, 205, 95, 25, "Load default");
      o->tooltip("Load colors from a \".colors\" file with the default name (same as filename)");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Load3);
    }
    { Fl_Box* o = new Fl_Box(255, 218, 55, 17, "Color");
      o->labelsize(12);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Button* o = new Fl_Button(320, 235, 95, 25, "Save default");
      o->tooltip("Save colors to a \".colors\" file with the default name (same as filename)");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Save2);
    }
    { Fl_Button* o = new Fl_Button(420, 205, 65, 25, "Load...");
      o->tooltip("Load color settings from file");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Load4);
    }
    { Fl_Button* o = new Fl_Button(420, 235, 65, 25, "Save...");
      o->tooltip("Save color settings to file");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_Save3);
    }
    { Fl_Box* o = new Fl_Box(255, 236, 55, 19, "Settings:");
      o->labelsize(12);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Button* o = new Fl_Button(460, 5, 25, 25);
      o->tooltip("Edit the current colormap.  If the colormap is a .ppm file, an import wizard \
will open to help you convert it to .spp");
      o->image(image_edit);
      o->callback((Fl_Callback*)cmapedit_cb);
    }
    o->end();
  }
  { ImageWindow* o = iw = new ImageWindow(136, 125, "image");
    w = o;
    o->box(FL_FLAT_BOX);
    o->color(FL_BACKGROUND_COLOR);
    o->selection_color(FL_BACKGROUND_COLOR);
    o->labeltype(FL_NO_LABEL);
    o->labelfont(0);
    o->labelsize(14);
    o->labelcolor(FL_FOREGROUND_COLOR);
    o->align(FL_ALIGN_TOP);
    o->when(FL_WHEN_RELEASE);
    o->end();
    o->resizable(o);
  }
  { Fl_Double_Window* o = procwin = new Fl_Double_Window(330, 445, "Image Processing");
    w = o;
    proc_description = new Fl_Output(0, 420, 330, 25);
    { Fl_Input* o = new Fl_Input(210, 240, 110, 25, "input:");
      o->type(1);
      o->callback((Fl_Callback*)cb_input);
      proc_parameters.push_back(o);
      o->hide();
    }
    { Fl_Input* o = new Fl_Input(210, 270, 110, 25, "input:");
      o->type(1);
      o->callback((Fl_Callback*)cb_input1);
      proc_parameters.push_back(o);
      o->hide();
    }
    { Fl_Input* o = new Fl_Input(210, 300, 110, 25, "input:");
      o->type(1);
      o->callback((Fl_Callback*)cb_input2);
      proc_parameters.push_back(o);
      o->hide();
    }
    { Fl_Input* o = new Fl_Input(210, 330, 110, 25, "input:");
      o->type(1);
      o->callback((Fl_Callback*)cb_input3);
      proc_parameters.push_back(o);
      o->hide();
    }
    { Fl_Input* o = new Fl_Input(210, 360, 110, 25, "input:");
      o->type(1);
      o->callback((Fl_Callback*)cb_input4);
      proc_parameters.push_back(o);
      o->hide();
    }
    { Fl_Check_Button* o = new Fl_Check_Button(300, 240, 20, 25, "button");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_button);
      o->align(FL_ALIGN_LEFT);
      proc_bool_parameters.push_back(o);
      o->hide();
    }
    { Fl_Check_Button* o = new Fl_Check_Button(300, 270, 20, 25, "button");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_button1);
      o->align(FL_ALIGN_LEFT);
      proc_bool_parameters.push_back(o);
      o->hide();
    }
    { Fl_Check_Button* o = new Fl_Check_Button(300, 300, 20, 25, "button");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_button2);
      o->align(FL_ALIGN_LEFT);
      proc_bool_parameters.push_back(o);
      o->hide();
    }
    { Fl_Check_Button* o = new Fl_Check_Button(300, 330, 20, 25, "button");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_button3);
      o->align(FL_ALIGN_LEFT);
      proc_bool_parameters.push_back(o);
      o->hide();
    }
    { Fl_Check_Button* o = new Fl_Check_Button(300, 360, 20, 25, "button");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_button4);
      o->align(FL_ALIGN_LEFT);
      proc_bool_parameters.push_back(o);
      o->hide();
    }
    { Fl_Check_Button* o = enable_filter = new Fl_Check_Button(10, 390, 110, 25, "&Enable Filter");
      o->down_box(FL_DOWN_BOX);
      o->callback((Fl_Callback*)cb_enable_filter);
      o->when(FL_WHEN_CHANGED);
      o->deactivate();
    }
    { Fl_Group* o = new Fl_Group(0, 0, 330, 385);
      { Fl_Browser* o = options = new Fl_Browser(10, 20, 110, 365, "Options");
        o->type(2);
        o->callback((Fl_Callback*)cb_options);
        o->align(FL_ALIGN_TOP);
      }
      { Fl_Browser* o = pqueue = new Fl_Browser(210, 20, 110, 215, "Queue");
        o->type(2);
        o->callback((Fl_Callback*)cb_pqueue);
        o->align(FL_ALIGN_TOP);
      }
      { Fl_Button* o = new Fl_Button(130, 20, 70, 20, "@->  add");
        o->callback((Fl_Callback*)cb_add);
        o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      }
      { Fl_Button* o = new Fl_Button(130, 105, 70, 20, "remove");
        o->callback((Fl_Callback*)cb_remove);
      }
      { Fl_Button* o = new Fl_Button(130, 130, 70, 20, "clear");
        o->callback((Fl_Callback*)cb_clear);
      }
      { Fl_Button* o = new Fl_Button(130, 50, 70, 20, "up @8->");
        o->callback((Fl_Callback*)cb_up);
        o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      }
      { Fl_Button* o = new Fl_Button(130, 75, 70, 20, "down @2");
        o->callback((Fl_Callback*)cb_down);
        o->align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
      }
      { Fl_Button* o = new Fl_Button(130, 215, 70, 20, "dismiss");
        o->callback((Fl_Callback*)cb_dismiss);
      }
      { Fl_Button* o = new Fl_Button(175, 160, 25, 20, "def");
        o->tooltip("Load with default name");
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_def);
      }
      { Fl_Button* o = new Fl_Button(175, 185, 25, 20, "def");
        o->tooltip("Save with default name");
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_def1);
      }
      { Fl_Button* o = new Fl_Button(130, 160, 45, 20, "Load...");
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Load5);
      }
      { Fl_Button* o = new Fl_Button(130, 185, 45, 20, "Save...");
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_Save4);
      }
      o->end();
      Fl_Group::current()->resizable(o);
    }
    { Fl_Choice* o = new Fl_Choice(210, 240, 110, 25, "choice:");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cb_choice);
      proc_choice_parameters.push_back(o);
      o->hide();
    }
    { Fl_Choice* o = new Fl_Choice(210, 270, 110, 25, "choice:");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cb_choice1);
      proc_choice_parameters.push_back(o);
      o->hide();
    }
    { Fl_Choice* o = new Fl_Choice(210, 300, 110, 25, "choice:");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cb_choice2);
      proc_choice_parameters.push_back(o);
      o->hide();
    }
    { Fl_Choice* o = new Fl_Choice(210, 330, 110, 25, "choice:");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cb_choice3);
      proc_choice_parameters.push_back(o);
      o->hide();
    }
    { Fl_Choice* o = new Fl_Choice(210, 360, 110, 25, "choice:");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cb_choice4);
      proc_choice_parameters.push_back(o);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(120, 390, 95, 25, "button");
      proc_button_parameters.push_back(o);
      o->hide();
    }
    { Fl_Button* o = new Fl_Button(225, 390, 95, 25, "button");
      proc_button_parameters.push_back(o);
      o->hide();
    }
    o->end();
  }
  { Fl_Double_Window* o = normwin = new Fl_Double_Window(275, 485, "Options on Loading File");
    w = o;
    { Fl_Box* o = new Fl_Box(5, 371, 135, 24, "Window Size:");
      o->labelfont(1);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Button* o = new Fl_Button(190, 450, 75, 25, "Dismiss");
      o->callback((Fl_Callback*)cb_Dismiss);
    }
    { Fl_Group* o = new Fl_Group(25, 388, 185, 67);
      { Fl_Round_Button* o = keep_zoom = new Fl_Round_Button(25, 394, 170, 25, "Keep Zoom");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->value(1);
        o->callback((Fl_Callback*)cb_keep_zoom);
      }
      { Fl_Round_Button* o = keep_size = new Fl_Round_Button(25, 419, 170, 25, "Keep Size");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)cb_keep_size);
      }
      { Fl_Round_Button* o = reset_zoom = new Fl_Round_Button(135, 394, 70, 25, "Reset zoom");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)cb_reset_zoom);
      }
      o->end();
    }
    { Fl_Check_Button* o = norm_on_load = new Fl_Check_Button(25, 35, 95, 15, "Normalize");
      o->down_box(FL_DOWN_BOX);
      o->value(1);
    }
    { Fl_Box* o = new Fl_Box(5, 6, 135, 24, "Contrast Adjustments:");
      o->labelfont(1);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Box* o = new Fl_Box(5, 56, 135, 24, "Quantization Control:");
      o->labelfont(1);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Group* o = new Fl_Group(25, 80, 170, 90);
      o->callback((Fl_Callback*)cb_);
      { Fl_Round_Button* o = a_quant = new Fl_Round_Button(25, 85, 120, 15, "Auto Quantize:");
        o->tooltip("Automatically pick quantization");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->value(1);
        o->callback((Fl_Callback*)cb_a_quant);
      }
      { Fl_Round_Button* o = man_quant = new Fl_Round_Button(25, 110, 170, 15, "Manually set Min/Max:");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)cb_man_quant);
      }
      o->end();
    }
    { Fl_Value_Input* o = a_quant_percent = new Fl_Value_Input(220, 82, 45, 20, "Percent:");
      o->tooltip("Percent of dynamic range to use");
      o->labelsize(12);
      o->maximum(1000);
      o->value(50);
      o->callback((Fl_Callback*)cb_a_quant_percent);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Group* o = manual_quant = new Fl_Group(60, 130, 211, 57);
      { Fl_Value_Input* o = qmin = new Fl_Value_Input(70, 135, 115, 20, "Min:");
        o->callback((Fl_Callback*)cb_qmin);
      }
      { Fl_Value_Input* o = qmax = new Fl_Value_Input(70, 160, 115, 20, "Max:");
        o->callback((Fl_Callback*)cb_qmax);
      }
      { Fl_Button* o = new Fl_Button(190, 135, 75, 20, "Use Slider");
        o->tooltip("Pick value based on \"Min\" slider in control window");
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_Use);
      }
      { Fl_Button* o = new Fl_Button(190, 160, 75, 20, "Use Slider");
        o->tooltip("Pick value based on \"Max\" slider in control window");
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_Use1);
      }
      o->end();
    }
    { Fl_Box* o = new Fl_Box(5, 191, 135, 24, "DAT File Handling:");
      o->labelfont(1);
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Group* o = new Fl_Group(25, 195, 240, 165);
      { Fl_Round_Button* o = dat_type_mat = new Fl_Round_Button(25, 220, 115, 15, "Matrix Format");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->value(1);
        o->callback((Fl_Callback*)cb_dat_type_mat);
      }
      { Fl_Round_Button* o = dat_type_gp = new Fl_Round_Button(25, 245, 130, 15, "Gnuplot Format");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)cb_dat_type_gp);
      }
      { Fl_Group* o = new Fl_Group(45, 265, 105, 50);
        { Fl_Round_Button* o = gp_type_col = new Fl_Round_Button(45, 270, 70, 15, "2D");
          o->tooltip("3rd dimension from column number (indices ignored)");
          o->type(102);
          o->down_box(FL_ROUND_DOWN_BOX);
          o->value(1);
          o->callback((Fl_Callback*)cb_gp_type_col);
        }
        { Fl_Round_Button* o = gp_type_index = new Fl_Round_Button(45, 295, 70, 15, "3D");
          o->tooltip("3rd dimension from index number");
          o->type(102);
          o->down_box(FL_ROUND_DOWN_BOX);
          o->callback((Fl_Callback*)cb_gp_type_index);
        }
        o->end();
      }
      { Fl_Round_Button* o = dat_type_delft = new Fl_Round_Button(25, 320, 155, 15, "Delft Legacy Format");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)cb_dat_type_delft);
      }
      { Fl_Check_Button* o = gp_parse_txt = new Fl_Check_Button(145, 265, 70, 15, "Parse txt file");
        o->tooltip("Read metadata from the delft txt file");
        o->down_box(FL_DOWN_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_gp_parse_txt);
      }
      { Fl_Check_Button* o = gp_delft_raw = new Fl_Check_Button(145, 280, 70, 15, "Raw units");
        o->tooltip("Use the raw units from the deflt txt file");
        o->down_box(FL_DOWN_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_gp_delft_raw);
      }
      { Fl_Round_Button* o = dat_type_meta = new Fl_Round_Button(25, 345, 155, 15, "DAT with meta.txt");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->callback((Fl_Callback*)cb_dat_type_meta);
      }
      { Fl_Check_Button* o = gp_delft_set = new Fl_Check_Button(145, 295, 70, 15, "Settings");
        o->tooltip("Put settings in \"sweep\" axis name");
        o->down_box(FL_DOWN_BOX);
        o->labelsize(10);
        o->callback((Fl_Callback*)cb_gp_delft_set);
      }
      o->end();
    }
    { Fl_Button* o = requantize = new Fl_Button(10, 450, 100, 25, "Requantize");
      o->callback((Fl_Callback*)cb_requantize);
    }
    { Fl_Button* o = new Fl_Button(115, 450, 70, 25, "Reload");
      o->callback((Fl_Callback*)cb_Reload1);
    }
    { Fl_Value_Input* o = gp_col = new Fl_Value_Input(205, 242, 45, 20, "Col #:");
      o->tooltip("Set column for 3D data, or default displayed column for 2D data\\nNote: first\
 column is 1!");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_gp_col);
    }
    o->end();
  }
  { Fl_Double_Window* o = unitswin = new Fl_Double_Window(290, 235, "Units");
    w = o;
    { Fl_Group* o = new Fl_Group(200, 25, 85, 85);
      o->end();
      Fl_Group::current()->resizable(o);
    }
    { Fl_Value_Input* o = xmin = new Fl_Value_Input(20, 25, 85, 25, "X");
      o->tooltip("left of image");
      o->callback((Fl_Callback*)cb_xmin);
      o->when(FL_WHEN_RELEASE);
    }
    { Fl_Value_Input* o = xmax = new Fl_Value_Input(110, 25, 85, 25);
      o->tooltip("right of image");
      o->callback((Fl_Callback*)cb_xmax);
      o->when(FL_WHEN_RELEASE);
    }
    { Fl_Input* o = xunitname = new Fl_Input(200, 25, 85, 25);
      o->callback((Fl_Callback*)cb_xunitname);
    }
    { Fl_Value_Input* o = ymin = new Fl_Value_Input(20, 55, 85, 25, "Y");
      o->tooltip("bottom of image");
      o->callback((Fl_Callback*)cb_ymin);
      o->when(FL_WHEN_RELEASE);
    }
    { Fl_Value_Input* o = ymax = new Fl_Value_Input(110, 55, 85, 25);
      o->tooltip("top of image");
      o->callback((Fl_Callback*)cb_ymax);
      o->when(FL_WHEN_RELEASE);
    }
    { Fl_Input* o = yunitname = new Fl_Input(200, 55, 85, 25);
      o->callback((Fl_Callback*)cb_yunitname);
    }
    { Fl_Value_Input* o = zmin = new Fl_Value_Input(20, 85, 85, 25);
      o->when(FL_WHEN_RELEASE);
      o->deactivate();
    }
    { Fl_Value_Input* o = zmax = new Fl_Value_Input(110, 85, 85, 25);
      o->when(FL_WHEN_RELEASE);
      o->deactivate();
    }
    { Fl_Input* o = zunitname = new Fl_Input(200, 85, 85, 25);
      o->callback((Fl_Callback*)cb_zunitname);
    }
    new Fl_Box(200, 3, 85, 25, "Unit");
    new Fl_Box(20, 3, 85, 25, "Min (b/l)");
    new Fl_Box(110, 3, 85, 25, "Max (t/r)");
    { Fl_Input* o = gpusing = new Fl_Input(5, 130, 210, 25, "Gnuplot \"using\" string:");
      o->callback((Fl_Callback*)cb_gpusing);
      o->align(FL_ALIGN_TOP);
    }
    { Fl_Input* o = gpwith = new Fl_Input(220, 130, 65, 25, "GP \"with\":");
      o->tooltip("Line style (gnuplot \"with ...\")");
      o->callback((Fl_Callback*)cb_gpwith);
      o->align(FL_ALIGN_TOP);
    }
    { Fl_Input* o = new Fl_Input(5, 175, 210, 25, "Send Gnuplot Command");
      o->callback((Fl_Callback*)cb_Send);
      o->align(FL_ALIGN_TOP);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Button* o = new Fl_Button(200, 205, 85, 25, "Dismiss");
      o->callback((Fl_Callback*)cb_Dismiss1);
    }
    { Fl_Choice* o = axis_type = new Fl_Choice(110, 205, 85, 25, "Diag. LC axis:");
      o->tooltip("Data to use for x-axis on diagonal line cuts");
      o->down_box(FL_BORDER_BOX);
      o->callback((Fl_Callback*)cb_axis_type);
      o->menu(menu_axis_type);
    }
    new Fl_Box(200, 25, 85, 85);
    new Fl_Box(-3, 88, 32, 17, "Z");
    { Fl_Light_Button* o = xrange = new Fl_Light_Button(220, 175, 65, 25, "Auto");
      o->callback((Fl_Callback*)cb_xrange);
    }
    { Fl_Box* o = new Fl_Box(219, 158, 55, 15, "Xrange:");
      o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
    }
    o->end();
  }
  { Fl_Double_Window* o = xsecwin = new Fl_Double_Window(295, 210, "3D Cross Section Control");
    w = o;
    { Fl_Group* o = units3d = new Fl_Group(60, 20, 230, 80);
      { Fl_Input* o = mtx_xname = new Fl_Input(60, 20, 80, 20, "Name:");
        o->callback((Fl_Callback*)cb_mtx_xname);
      }
      { Fl_Input* o = mtx_yname = new Fl_Input(140, 20, 75, 20);
        o->callback((Fl_Callback*)cb_mtx_yname);
      }
      { Fl_Input* o = mtx_zname = new Fl_Input(215, 20, 75, 20);
        o->callback((Fl_Callback*)cb_mtx_zname);
      }
      { Fl_Value_Input* o = mtx_xmin = new Fl_Value_Input(60, 60, 80, 20, "Min:");
        o->callback((Fl_Callback*)cb_mtx_xmin);
        o->when(FL_WHEN_RELEASE);
      }
      { Fl_Value_Input* o = mtx_ymin = new Fl_Value_Input(140, 60, 75, 20);
        o->callback((Fl_Callback*)cb_mtx_ymin);
        o->when(FL_WHEN_RELEASE);
      }
      { Fl_Value_Input* o = mtx_zmin = new Fl_Value_Input(215, 60, 75, 20);
        o->callback((Fl_Callback*)cb_mtx_zmin);
        o->when(FL_WHEN_RELEASE);
      }
      { Fl_Value_Input* o = mtx_xmax = new Fl_Value_Input(60, 80, 80, 20, "Max:");
        o->callback((Fl_Callback*)cb_mtx_xmax);
        o->when(FL_WHEN_RELEASE);
      }
      { Fl_Value_Input* o = mtx_ymax = new Fl_Value_Input(140, 80, 75, 20);
        o->callback((Fl_Callback*)cb_mtx_ymax);
        o->when(FL_WHEN_RELEASE);
      }
      { Fl_Value_Input* o = mtx_zmax = new Fl_Value_Input(215, 80, 75, 20);
        o->callback((Fl_Callback*)cb_mtx_zmax);
        o->when(FL_WHEN_RELEASE);
      }
      { Fl_Value_Output* o = mtx_x = new Fl_Value_Output(60, 40, 80, 20, "Size:");
        o->box(FL_DOWN_BOX);
      }
      mtx_y = new Fl_Value_Output(140, 40, 75, 20);
      mtx_z = new Fl_Value_Output(215, 40, 75, 20);
      o->end();
      Fl_Group::current()->resizable(o);
    }
    { Fl_Group* o = controls3d = new Fl_Group(10, 105, 280, 40);
      { Fl_Value_Input* o = indexbox = new Fl_Value_Input(55, 105, 35, 20, "Index:");
        o->callback((Fl_Callback*)cb_indexbox);
        o->when(FL_WHEN_ENTER_KEY);
      }
      { Fl_Slider* o = indexslider = new Fl_Slider(90, 105, 200, 20);
        o->type(3);
        o->step(1);
        o->callback((Fl_Callback*)cb_indexslider);
      }
      { Fl_Roller* o = indexroller = new Fl_Roller(90, 125, 200, 20);
        o->type(1);
        o->step(1);
        o->callback((Fl_Callback*)cb_indexroller);
      }
      index_value = new Fl_Value_Output(10, 125, 80, 20);
      o->end();
    }
    { Fl_Group* o = new Fl_Group(95, 150, 80, 25);
      { Fl_Group* o = new Fl_Group(95, 150, 80, 25);
        { Fl_Choice* o = dim = new Fl_Choice(95, 150, 80, 25, "Dimension:");
          o->down_box(FL_BORDER_BOX);
          o->callback((Fl_Callback*)cb_dim);
          o->align(36);
          o->menu(menu_dim);
        }
        o->end();
      }
      o->end();
    }
    new Fl_Box(235, 3, 32, 17, "Z");
    new Fl_Box(160, 3, 32, 17, "Y");
    new Fl_Box(85, 3, 32, 17, "X");
    { Fl_Button* o = new Fl_Button(10, 180, 280, 25, "dismiss");
      o->callback((Fl_Callback*)cb_dismiss1);
    }
    { Fl_Light_Button* o = mtx_label = new Fl_Light_Button(180, 150, 110, 25, "Label");
      o->tooltip("Label data name (Z name in units) with the cross section position");
      o->callback((Fl_Callback*)cb_mtx_label);
    }
    o->end();
  }
  { Fl_Double_Window* o = reload_window = new Fl_Double_Window(360, 65, "Load Files");
    w = o;
    { Fl_Input* o = reload_text = new Fl_Input(65, 5, 285, 25, "Pattern:");
      o->tooltip("Enter a list of files or shell wildcards");
      o->callback((Fl_Callback*)reload_cb);
      o->when(FL_WHEN_ENTER_KEY_ALWAYS);
    }
    { Fl_Button* o = new Fl_Button(260, 35, 90, 25, "Dismiss");
      o->callback((Fl_Callback*)cb_Dismiss2);
    }
    { Fl_Button* o = new Fl_Button(160, 35, 95, 25, "Browse...");
      o->callback((Fl_Callback*)cb_Browse);
    }
    { Fl_Group* o = new Fl_Group(5, 35, 170, 25);
      { Fl_Round_Button* o = new Fl_Round_Button(15, 40, 70, 15, "Add");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
      }
      { Fl_Round_Button* o = replaceb = new Fl_Round_Button(70, 40, 70, 15, "Replace");
        o->type(102);
        o->down_box(FL_ROUND_DOWN_BOX);
        o->value(1);
      }
      o->end();
    }
    o->end();
  }
  { Fl_Double_Window* o = cmapedwin = new Fl_Double_Window(250, 90, "Colormap Editor");
    w = o;
    { Fl_Value_Slider* o = cmrot = new Fl_Value_Slider(45, 10, 195, 20);
      o->type(3);
      o->minimum(-360);
      o->maximum(360);
      o->step(0.1);
      o->callback((Fl_Callback*)cb_cmrot);
      o->align(FL_ALIGN_LEFT);
    }
    { Fl_Button* o = new Fl_Button(45, 30, 35, 20, "zero");
      o->labelsize(9);
      o->callback((Fl_Callback*)cb_zero);
    }
    { Fl_Button* o = m60 = new Fl_Button(80, 30, 25, 20, "-60");
      o->labelsize(9);
      o->callback((Fl_Callback*)cb_m60);
    }
    { Fl_Roller* o = cmrot_roller = new Fl_Roller(105, 30, 110, 20);
      o->type(1);
      o->minimum(-360);
      o->maximum(360);
      o->step(0.1);
      o->callback((Fl_Callback*)cb_cmrot_roller);
    }
    { Fl_Button* o = p60 = new Fl_Button(215, 30, 25, 20, "+60");
      o->labelsize(9);
      o->callback((Fl_Callback*)cb_p60);
    }
    new Fl_Box(10, 5, 25, 25, "HSV");
    new Fl_Box(10, 20, 25, 25, "Rot.");
    { Fl_Button* o = new Fl_Button(10, 58, 230, 25, "Dismiss");
      o->callback((Fl_Callback*)cb_Dismiss3);
    }
    o->end();
  }
  { Fl_Double_Window* o = location_window = new Fl_Double_Window(395, 160, "Cursor Position");
    w = o;
    { Fl_Output* o = location_x = new Fl_Output(45, 20, 145, 20, "X");
      o->color(FL_BACKGROUND_COLOR);
      o->labelsize(12);
      o->textfont(8);
      o->textsize(10);
      o->align(FL_ALIGN_TOP);
    }
    { Fl_Output* o = location_y = new Fl_Output(240, 20, 150, 20, "Y");
      o->color(FL_BACKGROUND_COLOR);
      o->labelsize(12);
      o->textfont(8);
      o->textsize(10);
      o->align(FL_ALIGN_TOP);
    }
    { Fl_Output* o = location_data = new Fl_Output(250, 45, 140, 20);
      o->color(FL_BACKGROUND_COLOR);
      o->labelsize(11);
      o->textfont(8);
      o->textsize(10);
    }
    { Fl_Input* o = location_fmt = new Fl_Input(65, 135, 125, 20, "Format:");
      o->labelsize(12);
      o->textsize(12);
      o->when(FL_WHEN_CHANGED);
    }
    { Fl_Button* o = new Fl_Button(195, 135, 195, 20, "dismiss");
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_dismiss2);
    }
    { Fl_Group* o = zoom_group = new Fl_Group(0, 63, 390, 67);
      { Fl_Output* o = zx1v = new Fl_Output(45, 85, 145, 20);
        o->color(FL_BACKGROUND_COLOR);
        o->labelsize(12);
        o->textfont(8);
        o->textsize(10);
        o->align(FL_ALIGN_TOP);
      }
      { Fl_Output* o = zx2v = new Fl_Output(45, 105, 145, 20);
        o->color(FL_BACKGROUND_COLOR);
        o->labelsize(12);
        o->textfont(8);
        o->textsize(10);
        o->align(FL_ALIGN_TOP);
      }
      { Fl_Output* o = zy2v = new Fl_Output(240, 105, 145, 20);
        o->color(FL_BACKGROUND_COLOR);
        o->labelsize(12);
        o->textfont(8);
        o->textsize(10);
        o->align(FL_ALIGN_TOP);
      }
      { Fl_Output* o = zy1v = new Fl_Output(240, 85, 145, 20);
        o->color(FL_BACKGROUND_COLOR);
        o->labelsize(12);
        o->textfont(8);
        o->textsize(10);
        o->align(FL_ALIGN_TOP);
      }
      { Fl_Value_Output* o = zx1 = new Fl_Value_Output(5, 85, 40, 20);
        o->textsize(10);
      }
      { Fl_Value_Output* o = zx2 = new Fl_Value_Output(5, 105, 40, 20);
        o->textsize(10);
      }
      { Fl_Value_Output* o = zy2 = new Fl_Value_Output(200, 105, 40, 20);
        o->textsize(10);
      }
      { Fl_Value_Output* o = zy1 = new Fl_Value_Output(200, 85, 40, 20);
        o->textsize(10);
      }
      { Fl_Box* o = new Fl_Box(5, 68, 32, 17, "Zoom Window:");
        o->labelsize(11);
        o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
      }
      o->end();
    }
    { Fl_Value_Output* o = x_col = new Fl_Value_Output(5, 20, 40, 20);
      o->textsize(10);
    }
    { Fl_Value_Output* o = y_row = new Fl_Value_Output(200, 20, 40, 20);
      o->textsize(10);
    }
    { Fl_Output* o = data_name = new Fl_Output(5, 45, 245, 20);
      o->box(FL_NO_BOX);
      o->color(FL_BACKGROUND_COLOR);
      o->labelsize(11);
      o->textfont(8);
      o->textsize(10);
    }
    o->end();
    o->resizable(o);
  }
  { Fl_Double_Window* o = helpwin = new Fl_Double_Window(325, 500);
    w = o;
    { Fl_Text_Display* o = help_text = new Fl_Text_Display(5, 5, 315, 465);
      o->textfont(5);
      o->textsize(11);
      Fl_Group::current()->resizable(o);
    }
    { Fl_Button* o = new Fl_Button(5, 475, 315, 20, "Dismiss");
      o->callback((Fl_Callback*)cb_Dismiss4);
    }
    o->end();
  }
  { Fl_Double_Window* o = plane_win = new Fl_Double_Window(245, 165, "Plane subtraction");
    w = o;
    { Fl_Light_Button* o = planeb = new Fl_Light_Button(5, 5, 115, 25, "Subt. Plane");
      o->tooltip("Enable or disable the plane correction");
      o->callback((Fl_Callback*)cb_planeb);
    }
    { Fl_Button* o = fitplane = new Fl_Button(125, 5, 55, 25, "Fit");
      o->tooltip("Do a least-squares fit of the plane correction to the data set");
      o->callback((Fl_Callback*)cb_fitplane);
    }
    { Fl_Button* o = zeroplane = new Fl_Button(185, 5, 55, 25, "Zero ");
      o->tooltip("Zero the plane correction");
      o->callback((Fl_Callback*)cb_zeroplane);
    }
    { Fl_Value_Input* o = plane_a = new Fl_Value_Input(55, 40, 70, 20, "Vert:");
      o->minimum(-2);
      o->maximum(2);
      o->callback((Fl_Callback*)cb_plane_a);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Slider* o = plane_aslider = new Fl_Slider(125, 40, 115, 20);
      o->type(3);
      o->minimum(-2);
      o->maximum(2);
      o->step(0.0001);
      o->callback((Fl_Callback*)cb_plane_aslider);
    }
    { Fl_Roller* o = plane_aroller = new Fl_Roller(55, 60, 185, 20);
      o->type(1);
      o->minimum(-2);
      o->maximum(2);
      o->step(0.0001);
      o->callback((Fl_Callback*)cb_plane_aroller);
    }
    { Fl_Value_Input* o = plane_b = new Fl_Value_Input(55, 90, 70, 20, "Horz:");
      o->minimum(-2);
      o->maximum(2);
      o->callback((Fl_Callback*)cb_plane_b);
      o->when(FL_WHEN_ENTER_KEY);
    }
    { Fl_Slider* o = plane_bslider = new Fl_Slider(125, 90, 115, 20);
      o->type(3);
      o->minimum(-2);
      o->maximum(2);
      o->step(0.0001);
      o->callback((Fl_Callback*)cb_plane_bslider);
    }
    { Fl_Roller* o = plane_broller = new Fl_Roller(55, 110, 185, 20);
      o->type(1);
      o->minimum(-2);
      o->maximum(2);
      o->step(0.0001);
      o->callback((Fl_Callback*)cb_plane_broller);
    }
    { Fl_Button* o = new Fl_Button(5, 135, 235, 25, "dismiss");
      o->callback((Fl_Callback*)cb_dismiss3);
    }
    o->end();
  }
}
std::vector<Fl_Input *> proc_parameters;
Fl_Browser *last_proc_side; // Last side clicked on in the proc window;
std::vector<Fl_Check_Button *> proc_bool_parameters;
std::vector<Fl_Choice *> proc_choice_parameters;
std::vector<Fl_Button *> proc_button_parameters;

void reload_data() {
  iw->reRunQueue();
if (norm_on_load->value())
    iw->normalize();
}
