/***************************************************************************
 *   Copyright (C) 2006-2025 by Ilya Kotov                                 *
 *   forkotov02@ya.ru                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef FFVIDEOFACTORY_H
#define FFVIDEOFACTORY_H

#include <qmmp/abstractengine.h>

class FFVideoFactory : public QObject, EngineFactory
{
Q_OBJECT
Q_PLUGIN_METADATA(IID "org.qmmp.qmmp.EngineFactoryInterface.1.0")
Q_INTERFACES(EngineFactory)

public:
    FFVideoFactory();
    EngineProperties properties() const override;
    bool supports(const QString &source) const override;
    AbstractEngine *create(QObject *parent = nullptr) override;
    QList<TrackInfo *> createPlayList(const QString &path, TrackInfo::Parts parts, QStringList *) override;
    MetaDataModel* createMetaDataModel(const QString &path, bool readOnly) override;
    QDialog *createSettings(QWidget *) override;
    void showAbout(QWidget *parent) override;
    QString translation() const override;
};

#endif
