/*-
 * Copyright (c) 2001, 2005 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: cfgvar.h,v 1.17 2005/03/22 17:55:14 vlm Exp $
 */
#ifndef	__CFGVAR_H__
#define	__CFGVAR_H__

#include "ipcad.h"

/*
 * IP networks aggregation list.
 * This list implies linear scan, but should be fine for
 * small number of aggregated networks.
 */
struct atable {
	struct in_addr ip;
	struct in_addr mask;
	struct in_addr strip;
	struct atable *next;
	int strip_bits;
};

/*
 * Ports aggregation table.
 */
extern int agr_portmap[65536];

typedef struct config_s {
	uid_t set_uid;
	gid_t set_gid;

	char *chroot_to;
	char *pidfile;

	char *dump_table_file;	/* File to dump the table */

	unsigned memsize;	/* Memory usage size */
	unsigned bufsize;	/* Capture buffers size */

	int rsh_ttl;	/* Default IP TTL for RSH */

	packet_source_t *packet_sources_head;

	struct atable *atable;

	int capture_ports;	/* Whether to display UDP/TCP ports */

	int netflow_enabled;	/* Whether to perform NetFlow export */
	int netflow_version;
	int netflow_timeout_active;	/* Flow timeout, in seconds */
	int netflow_timeout_inactive;	/* Flow timeout, in seconds */
	int netflow_packet_interval;	/* Sampling mode, in packets */
	int netflow_engine_type;	/* v5 engine-type */
	int netflow_engine_id;		/* v5 engine-id */
} config_t;

extern pthread_mutex_t packet_sources_list_lock;


/* Globally visible configuration */
extern config_t *conf;

/*
 * Run-time global variables
 */
extern size_t used_memory;


/*
 * Constructors used by the configuration reader.
 */

packet_source_t *cfg_add_iface(char *, int iflags, char *filter);
int cfg_add_rsh_host(char *ru, char *rh, int privlevel);
int cfg_check_rsh(char *ru, struct in_addr *);

int cfg_add_atable(char *ip, char *mask, char *strip);
int cfg_add_aggregate_ports_table(int from, int to, int into);

int cfg_add_ifclass_map(char *ifclass, int range_start, int range_stop);
int iface_to_snmp_id(const char *interface_name);


/*
 * Misc methods.
 */

int make_dump(char *, FILE *);
int import_table(char *, FILE *, int clear);

#endif	/* __CFGVAR_H__ */
