/*-
 * Copyright (c) 2001, 2002, 2004 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: loop-bpf.c,v 1.15 2007/04/22 07:22:40 vlm Exp $
 */

#include "ipcad.h"
#include "opt.h"

#define	bpf_header	((struct bpf_hdr *)packet)


/*
 * This is the interface loop - a busy horse handling interface statistics.
 */
void *
process_bpf(void *psp) {
	packet_source_t *ps = psp;
	ssize_t rd;
	char *packet, *safe_end;
	struct pollfd pfd;
	
	assert(ps->iface_type == IFACE_BPF);

	pfd.fd = ps->fd;
	pfd.events = POLLIN;

	for(rd = 0;;) {

		if(signoff_now)
			break;

		if(rd == -1) {
			if(errno != EAGAIN) {
				ps->fd = -1;
				close(pfd.fd);
				pfd.fd = -1;
			}
		}

		if(ps->state != PST_READY || ps->fd == -1) {
			if(init_packet_source(ps, 1)) {
				sleep(5);
				continue;
			}
			assert(ps->state == PST_READY);
			fprintf(stderr, "\n");
			pfd.fd = ps->fd;
		}

		rd = poll(&pfd, 1, 3000);

		/* Poll timeout is almost impossible thing */
		if(rd == 0)
			continue;

		if((rd == -1) || !(pfd.revents & POLLIN)) {
			if(rd > 0 && pfd.revents & POLLNVAL) {
				fprintf(stderr,
					"[%s: INVALID INTERFACE! (%d/%d/%d)]\n",
					ps->ifName, (int)rd, pfd.fd, pfd.revents);
				sleep(1);
			}
			rd = -1;
			continue;
		}

		if(signoff_now)
			break;

		rd = read(ps->fd, ps->buf, ps->bufsize);

		/*
		 * Processing packets
		 */
		for(packet = ps->buf,
		    safe_end = packet + rd - sizeof(struct bpf_hdr);
			packet < safe_end;
				packet += BPF_WORDALIGN(bpf_header->bh_hdrlen
				  + bpf_header->bh_caplen) )
		{
			void *ip_start = packet + bpf_header->bh_hdrlen;
			int toend_size = rd-((char *)ip_start-(char *)ps->buf);
			int captured_size = bpf_header->bh_caplen;
			if(toend_size < captured_size)	/* Paranoya */
				captured_size = toend_size;
			process_packet_data(ps, ip_start, captured_size, 0, 0);
		}

	}

	return 0;

}

