/*-
 * Copyright (c) 2003, 2006 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: loop-ulog.c,v 1.20 2006/03/27 13:57:29 vlm Exp $
 */

#include "ipcad.h"
#include "opt.h"


#ifndef	PSRC_ulog

void *
process_ulog(void *psp) {
	(void)psp;
	assert(!"Can't be here");
	return NULL;
}

#else	/* !PSRC_ulog */


/*
 * This is the interface loop - a busy horse handling interface statistics.
 */
void *
process_ulog(void *psp) {
	struct nlmsghdr *nlh;
	ulog_packet_msg_t *upkt;
	packet_source_t *ps = psp;
	ssize_t len = 0;
	socklen_t addrlen;

	assert(ps->iface_type == IFACE_ULOG);
	assert(ps->bufsize);

	for(;;) {

		if(signoff_now)
			break;

		if(len == -1) {
			if(errno != EAGAIN) {
				/* We can't deal with permanent errors.
				 * Just sleep a bit.
				 */
				printf("System call returned %d: %s\n",
					errno, strerror(errno));
				sleep(1);
			}
		}
		
		if(ps->state != PST_READY || ps->fd == -1) {
			if(init_packet_source(ps, 1)) {
				sleep(5);
				continue;
			}
			assert(ps->state == PST_READY);
			fprintf(stderr, "\n");
		}

		addrlen = sizeof(ps->iface.ulog.peer);
		len = recvfrom(ps->fd,
			ps->buf, ps->bufsize, 0,
			(struct sockaddr*)&ps->iface.ulog.peer, &addrlen);

		/*
		 * Read timeout or failure condition.
		 */
		if(len < (int)sizeof(struct nlmsghdr)) continue; /* Paranoya */
		if(addrlen != sizeof(ps->iface.ulog.peer))
			continue;

		nlh = (struct nlmsghdr*)ps->buf;
		if((nlh->nlmsg_flags & MSG_TRUNC)
		|| ((size_t)len > ps->bufsize))
			continue;

		while(NLMSG_OK(nlh, (size_t)len)) {

			upkt = NLMSG_DATA(nlh);

			/* If interface name is not given,
			 * fake it using ULOG group id */
			if(upkt->indev_name[0] == 0) {
				char *p = upkt->indev_name;
				int nlgroup = upkt->hook + 1;
				memcpy(p, "ulog", 4); p += 4;
				if(nlgroup >= 10)	/* Max is 32 anyway */
					*p++ = '0' + (nlgroup / 10);
				*p++ = '0' + (nlgroup % 10);
				*p = '\0';
			}
			process_packet_data(ps, upkt->payload, upkt->data_len,
				upkt->indev_name, upkt->outdev_name);
			
			if(nlh->nlmsg_type == NLMSG_DONE
				|| !(nlh->nlmsg_flags & NLM_F_MULTI)) {
				/* Last part of the multilink message */
				break;
			}

			nlh = NLMSG_NEXT(nlh, len);
		}
	}

	return 0;
}

#endif	/* ULOG support */
