/*
 *  Copyright (C) 2003 Allan Douglas
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include "player.h"

static char *ctable[] =
{
    "Light Yellow",
    "Red",
    "Green",
    "OffBlue",
    "Cyan",
    "Yellow",
    "Magenta",
    "Orange",
    "Indigo",
    "Aqua",
    "White",
    "Grey",
};

char *conColorToString(int num)
{
    if(num < 0 || num >= sizeof(ctable))
	return "Unknown";
    return ctable[num];
}


char *conReadyToString(Ready_pl ready)
{
    switch(ready)
    {
    case OBSERVER:
	return "Observer";
	break;
    case NOTREADY:
	return "Not Ready";
	break;
    case READY:
	return "Ready";
	break;
    case SCORING:
	return "Scoring";
	break;
    default:
	return "Unknown";
	break;
    }
}
