/* assembler
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __ASSEMBLE_H__
#define __ASSEMBLE_H__

extern FILE *assembler_file;
extern int location;
extern int last_location;
extern int *image;
extern boolean *location_used;
extern tree *assertions;
extern loc_t last_loc;
extern int assembled_code_size;
extern int assembled_page_instructions;
extern int assembled_bank_instructions;

void show_line(loc_t loc);

void emit_assembley(tree p, char *line, int phase);

void assemble_test(tree p, int phase);

void assemble_type(tree p, int phase);

void assemble_var(tree p, int phase);

void assemble_const(tree p, int phase);

void assemble_label(tree p, int phase);

void assemble_org(tree p, int phase);

void assemble_asm(tree p, int phase);

void assemble_statement(tree p, int phase);

#define eeprom_factor(i) \
   ((( i >= eeprom_start ) && ( target_cpu == pic_16 )) ? 1 : 2 )

int n_to_write(int i);

int low(int x);

int high(int x);

void checksum_add(int *x, int n);

/* write the hex result file */
void write_hex(char *file_name, int config);

/* write the statistics part of the assembler result file */
void assembler_statistics(void);

/* write the assembler header */
void assembler_header(void);

/* calculate the configuration value (and osc text for the SX) */
void calc_config(int *value, char **osc);

/* write the assembler configuration part */
void assembler_config(char *osc_string);


void assemble(tree * p);

#endif
