/* variables listing
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __JALCOMP_H__
#define __JALCOMP_H__

#ifdef _MSC_VER
#define BUILD_NATIVE_WINDOWS 
#define DEV_STUDIO
#endif 

/*
 * define this to enable mingw build for native windows users.
 * #define BUILD_NATIVE_WINDOWS
 *  
 */

#if defined(BUILD_NATIVE_WINDOWS)
#define HAVE_DOS_BASED_FILE_SYSTEM
#endif

#if defined(HAVE_DOS_BASED_FILE_SYSTEM)
#define directory_separator '\\'
#else
#define directory_separator '/'
#endif


#if defined(__WATCOMC__)
#if __WATCOMC__ < 1200
#define compiler          "Watcom C"
#define compiler_version  (__WATCOMC__ / 100)
#define compiler_minor    (__WATCOMC__ % 100)
#else
#define compiler          "Open Watcom C"
#define compiler_version  ((__WATCOMC__ - 1100) / 100)
#define compiler_minor    ((__WATCOMC__ - 1100) % 100)
#endif

#elif defined(__IBMC__)
#if __IBMC__ < 300
#define compiler          "IBM C/C++"
#else
#define compiler          "IBM VAC"
#endif
#define compiler_version    (__IBMC__ / 100)
#define compiler_minor      (__IBMC__ % 100)

#elif defined(__DJGPP__)
#define compiler            "DJGPP"
#define compiler_version    (__DJGPP__)
#define compiler_minor      (__DJGPP_MINOR__)

#elif defined(__GNUC__)
#define compiler            "GCC"
#define compiler_version    (__GNUC__)
#define compiler_minor      (__GNUC_MINOR__)

#elif defined(DEV_STUDIO)
#define compiler            "MSVC"
#define compiler_version    (_MSC_VER)
#define compiler_minor      (0)

#else
#define compiler            "BC"
#define compiler_version    (5)
#define compiler_minor      (5)

#endif

#endif
