/* optimizer
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __OPTIMIZER_H__
#define __OPTIMIZER_H__

/* incremented on each optimization,
 used to detect whether further optimization should be attempted */
extern int optimizations;

/* forward */
tree optimize_statement(tree p);

/* report whether the value of p is known */
boolean value_known(tree p);

/* optimize an op node */
tree optimize_op(tree p);

/* return a possibly optimized expression node p */
tree optimize_expression(tree p);

/* general statement optimization */
tree optimize_statement(tree p);

/* remove unused declarations */
void remove_unused(tree p);

/* copy var properties */
void propagation(tree p);

void show_optimization_settings(void);

void optimize1(tree * p);

void optimize2(tree * p);

#endif
