/* simulator
   Copyright (C) 1998, 1999, 2000, 2001, 2002, 2003
   Wouter van Ooijen

This file is part of jal.

jal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

jal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with jal; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef __SIMULATOR_H__
#define __SIMULATOR_H__

/* uses image,assertions, last_location */
extern boolean sim_run;
extern int sim_pc;
extern int sim_w;
extern int sim_mem[4096];
extern int sim_stack[9];
extern int sim_stack16[32];
extern int sim_sp;

extern int sim_instruction;
extern int sim_literal;
extern int sim_data_address;
extern int sim_call_label;
extern int sim_goto_label;
extern int sim_bra_address;
extern int sim_lfsr_address;
extern int sim_lfsr_dest;
extern int sim_bit;
extern int sim_bit_mask;
extern int sim_destination;
extern int sim_tris_address;

extern int sim_status;
extern int sim_reg_option;
extern int sim_intcon;
extern int sim_tmr0_prescaler;
extern int sim_tmr0_prescaler_start;
extern int sim_tmr0;

extern int sim_instruction_cycles;

#define intcon_gie  0x80
#define intcon_eeie 0x40
#define intcon_t0ie 0x20
#define intcon_inte 0x10
#define intcon_rbie 0x08
#define intcon_t0if 0x04
#define intcon_intf 0x02
#define intcon_rbif 0x01

#define option_psa  0x08 /* Changed by Ziya Erdemir 18.02.2003*/        /*#define option_psa  0x04 */

#define status_c    0x01
#define status_dc   0x02
#define status_z    0x04
#define status_ov   0x08  /* PIC16 cores */
#define status_n    0x10  /* PIC16 cores */
#define status_pd   0x08
#define status_to   0x10
#define status_rp0  0x20
#define status_rp1  0x40
#define status_irp  0x80
#define status_pa0  0x20
#define status_pa1  0x40
#define status_pa2  0x80

extern boolean sim_c_flag, sim_z_flag, sim_dc_flag;
extern boolean sim_check_int;

#define simulation_error( loc, x ){ string m; \
   sprintf x; \
   ffatal( loc, m ); \
}

#define extra_cycles_for_jump ( ( target_cpu == sx_12 ) ? 2 : 1 )
void instruction_cycle(int n);
void sim_update_option(void);
int sim_get(int a);
void sim_put(int a, int d);
int decode_address(int a) ;
void sim_store_result(int d);
void sim_show_literal(void);
void sim_show_call_label(void);
void sim_show_goto_label(void);
void sim_show_data_address(void);
void sim_show_bit(void);
void sim_show_tris_address(void);
void sim_show_new_w(void);

void sim_nop(void);
void sim_clrw(void);
void sim_return(void);
void sim_retfie(void);
void sim_option(void);
void sim_sleep(void);
void sim_clrwdt(void);
void sim_tris(void);
void sim_movwf(void);
void sim_clrf(void);
void sim_subwf(void);
void sim_decf(void);
void sim_decfsz(void);
void sim_rrf(void);
void sim_rlf(void);
void sim_iorwf(void);
void sim_andwf(void);
void sim_xorwf(void);
void sim_addwf(void);
void sim_movf(void);
void sim_comf(void);
void sim_incf(void);
void sim_incfsz(void);
void sim_swapf(void);
void sim_bcf(void);
void sim_bsf(void);
void sim_btfsc(void);
void sim_btfss(void);
void sim_call(void);
void sim_goto(void);
void sim_movlw(void);
void sim_retlw(void);
void sim_iorlw(void);
void sim_andlw(void);
void sim_xorlw(void);
void sim_sublw(void);
void sim_addlw(void);
void sim_bank(void);
void sim_page(void);
void sim_mullw(void);
void sim_mulwf(void);
void sim_cpfseq(void);
void sim_cpfsgt(void);
void sim_cpfslt(void);

void sim_stack16_get(void);
void sim_stack16_put(void);
void sim_addwfc(void);
void sim_dcfsnz(void);
void sim_infsnz(void);
void sim_negf(void);
void sim_rlncf(void);
void sim_rrncf(void);
void sim_setf(void);
void sim_subfwb(void);
void sim_subwfb(void);
void sim_tstfsz(void);
void sim_btg(void);
void sim_bc(void);
void sim_bn(void);
void sim_bnc(void);
void sim_bnn(void);
void sim_bnov(void);
void sim_bnz(void);
void sim_bov(void);
void sim_bz(void);
void sim_bra(void);
void sim_daw(void);
void sim_push(void);
void sim_pop(void);
void sim_rcall(void);
void sim_reset(void);
void sim_lfsr(void);
void sim_movlb(void);
void sim_tblrd(void);
void sim_tblrd_postinc(void);
void sim_tblrd_postdec(void);
void sim_tblrd_preinc(void);
void sim_tblwt(void);
void sim_tblwt_postinc(void);
void sim_tblwt_postdec(void);
void sim_tblwt_preinc(void);

#define try_op( v, s, f ) \
case v: \
   if( verbose_simulator ){ printf( "%-7s ", s ); } \
   f(); \
   return;

void sim12_00(void);
void sim12_01(void);
void sim12_02(void);
void sim12_03(void);
void sim12_rest(void);
void sim14_00(void);
void sim14_01(void);
void sim14_02(void);
void sim14_03(void);

#define sim_field( start, bits )\
   ( ( sim_instruction >> start ) & ( ( 1 << bits ) - 1 ) )

void show_location(void);
void sim_interrupt(void);
void simulate_one_instruction_12(void);
void simulate_one_instruction_14(void);
void simulate_one_instruction_16(void);
int mask(int n);
int get_mem(tree p);
boolean evaluate_assert(tree p, char *s);
void simulate_assertions(void);
extern int simulation_max_steps;
void simulate(tree * dummy);

#endif
