/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCpp;
import org.gradle.util.internal.VersionNumber;

public class ArchitectureSpecificVisualCpp
implements VisualCpp {
    private static final String COMPILER_FILENAME = "cl.exe";
    private static final String LINKER_FILENAME = "link.exe";
    private static final String ARCHIVER_FILENAME = "lib.exe";
    private final VersionNumber version;
    private final List<File> paths;
    private final File binDir;
    private final File libDir;
    private final File includeDir;
    private final String assemblerFilename;
    private final Map<String, String> definitions;
    private final File compilerPath;

    ArchitectureSpecificVisualCpp(VersionNumber version, List<File> paths, File binDir, File libDir, File compilerPath, File includeDir, String assemblerFilename, Map<String, String> definitions) {
        this.version = version;
        this.paths = paths;
        this.binDir = binDir;
        this.libDir = libDir;
        this.includeDir = includeDir;
        this.assemblerFilename = assemblerFilename;
        this.definitions = definitions;
        this.compilerPath = compilerPath;
    }

    @Override
    public VersionNumber getImplementationVersion() {
        return this.version;
    }

    @Override
    public File getBinDir() {
        return this.binDir;
    }

    @Override
    public List<File> getPath() {
        return this.paths;
    }

    @Override
    public File getCompilerExecutable() {
        return new File(this.binDir, COMPILER_FILENAME);
    }

    @Override
    public File getLinkerExecutable() {
        return new File(this.binDir, LINKER_FILENAME);
    }

    @Override
    public File getArchiverExecutable() {
        return new File(this.binDir, ARCHIVER_FILENAME);
    }

    @Override
    public File getAssemblerExecutable() {
        return new File(this.binDir, this.assemblerFilename);
    }

    @Override
    public List<File> getLibDirs() {
        return Collections.singletonList(this.libDir);
    }

    @Override
    public List<File> getIncludeDirs() {
        return Collections.singletonList(this.includeDir);
    }

    @Override
    public Map<String, String> getPreprocessorMacros() {
        return this.definitions;
    }

    public boolean isInstalled() {
        return this.binDir.exists() && this.compilerPath.exists() && this.libDir.exists();
    }
}

