/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OnlyOnceErrorHandler;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;

public abstract class AppenderSkeleton
implements Appender,
OptionHandler {
    public static final String THRESHOLD_OPTION = "Threshold";
    protected Layout layout;
    protected String name;
    protected Priority threshold;
    protected ErrorHandler errorHandler = new OnlyOnceErrorHandler();
    protected Filter headFilter;
    protected Filter tailFilter;
    protected boolean closed = false;

    public void activateOptions() {
    }

    public void addFilter(Filter filter) {
        if (this.headFilter == null) {
            this.headFilter = this.tailFilter = filter;
        } else {
            this.tailFilter.next = filter;
            this.tailFilter = filter;
        }
    }

    protected abstract void append(LoggingEvent var1);

    public void clearFilters() {
        this.tailFilter = null;
        this.headFilter = null;
    }

    public void finalize() {
        if (this.closed) {
            return;
        }
        LogLog.debug("Finalizing appender named [" + this.name + "].");
        this.close();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final Filter getFirstFilter() {
        return this.headFilter;
    }

    public final String getName() {
        return this.name;
    }

    public String[] getOptionStrings() {
        return new String[]{THRESHOLD_OPTION};
    }

    public boolean isAsSevereAsThreshold(Priority priority) {
        return this.threshold == null || priority.isGreaterOrEqual(this.threshold);
    }

    public synchronized void doAppend(LoggingEvent loggingEvent) {
        if (this.closed) {
            LogLog.error("Attempted to append to closed appender named [" + this.name + "].");
        }
        if (!this.isAsSevereAsThreshold(loggingEvent.priority)) {
            return;
        }
        Filter filter = this.headFilter;
        block5: while (filter != null) {
            switch (filter.decide(loggingEvent)) {
                case -1: {
                    return;
                }
                case 1: {
                    break block5;
                }
                case 0: {
                    filter = filter.next;
                }
                default: {
                    continue block5;
                }
            }
        }
        this.append(loggingEvent);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            LogLog.error("It is forbidden to set a null ErrorHandler. Ignoring directive.");
        } else {
            this.errorHandler = errorHandler;
        }
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase(THRESHOLD_OPTION)) {
            this.threshold = Priority.toPriority(string2);
        }
    }

    public void setThreshold(Priority priority) {
        this.threshold = priority;
    }

    public abstract void close();

    public abstract boolean requiresLayout();
}

