import com.onionnetworks.util.*;
import java.io.*;
import java.util.*;

public class IOPerformance {

    public static final File f = new File("/home/orasis/iotest.tmp");
    public static final Random rand = new Random();

    public static final void measureSequentialWriteVaryBuffer() throws Exception {
        String title = "Sequential Write Speed";
        String x = "Buffer Size (kB)";
        String y = "Time to Write 5MB (ms)";

        int[][] plots = new int[3][];
        int bufMin = 512;
        int bufMax = 32768;
        int fileSize = 51200000; // 5MB

        // run each one 3 times and throw out the two extremes.
        for (int p=0;p<3;p++) {
            plots[p] = new int[2*(int) ((Math.log(bufMax)/Math.log(2))-
                                (Math.log(bufMin)/Math.log(2)))+2];
            for (int n=bufMin,j=0;n<=bufMax;n*=2,j++) {
                System.out.println(n);
                f.delete();
                RandomAccessFile raf = new RandomAccessFile(f,"rw");
                byte[] b = new byte[n];
                java.util.Arrays.fill(b,(byte) 10);
                long t1 = System.currentTimeMillis();
                for (int a=0;a<fileSize;a+=n) {
                    raf.write(b);
                }
                long t2 = System.currentTimeMillis();
		raf.close();
                plots[p][2*j] = n/1024;
                plots[p][(2*j)+1] = (int) (t2 - t1);
            }
        }

        int[] result = new int[plots[0].length];
        for (int j=0;j<result.length;j++) {
            result[j] = SimUtil.getMedian(new int[] {plots[0][j],
                                                         plots[1][j],
                                                         plots[2][j]});
        }
        
        SimUtil.printGraphCommand(title,x,y,new int[][] {result},new String[]{"bob"});
    }

    public static final void measureSequentialReadVaryBuffer() throws Exception {
        String title = "Sequential Read Speed";
        String x = "Buffer Size (kB)";
        String y = "Time to Write 5MB (ms)";

        int[][] plots = new int[3][];
        int bufMin = 512;
        int bufMax = 32768;
        int fileSize = 51200000; // 5MB

        // run each one 3 times and throw out the two extremes.
        for (int p=0;p<3;p++) {
            plots[p] = new int[2*(int) ((Math.log(bufMax)/Math.log(2))-
                                (Math.log(bufMin)/Math.log(2)))+2];
            for (int n=bufMin,j=0;n<=bufMax;n*=2,j++) {
                System.out.println(n);
                RandomAccessFile raf = new RandomAccessFile(f,"rw");
                byte[] b = new byte[n];
                long t1 = System.currentTimeMillis();
                for (int a=0;a<fileSize;a+=n) {
                    raf.readFully(b);
                }
                long t2 = System.currentTimeMillis();
		raf.close();
                plots[p][2*j] = n/1024;
                plots[p][(2*j)+1] = (int) (t2 - t1);
            }
        }

        int[] result = new int[plots[0].length];
        for (int j=0;j<result.length;j++) {
            result[j] = SimUtil.getMedian(new int[] {plots[0][j],
                                                         plots[1][j],
                                                         plots[2][j]});
        }
        
        SimUtil.printGraphCommand(title,x,y,new int[][] {result},new String[]{"bob"});
    }


    public static final void measureRandomWriteVaryBuffer() throws Exception {
        String title = "Random Seek & Write Speed";
        String x = "Buffer Size (kB)";
        String y = "Time to Write 5MB (ms)";

        int[][] plots = new int[3][];
        int bufMin = 1024;
        int bufMax = 32768;
        int fileSize = 5120000; // 5MB

        // run each one 3 times and throw out the two extremes.
        for (int p=0;p<3;p++) {
            plots[p] = new int[2*(int) ((Math.log(bufMax)/Math.log(2))-
                                (Math.log(bufMin)/Math.log(2)))+2];
            for (int n=bufMin,j=0;n<=bufMax;n*=2,j++) {
                System.out.println(n);
                f.delete();
                RandomAccessFile raf = new RandomAccessFile(f,"rw");
                byte[] b = new byte[n];
                java.util.Arrays.fill(b,(byte) 10);
                long t1 = System.currentTimeMillis();
                for (int a=0;a<fileSize;a+=n) {
		    raf.seek(Math.abs(rand.nextInt())%fileSize);
                    raf.write(b);
                }
                long t2 = System.currentTimeMillis();
		raf.close();
                plots[p][2*j] = n/1024;
                plots[p][(2*j)+1] = (int) (t2 - t1);
            }
        }

        int[] result = new int[plots[0].length];
        for (int j=0;j<result.length;j++) {
            result[j] = SimUtil.getMedian(new int[] {plots[0][j],
                                                         plots[1][j],
                                                         plots[2][j]});
        }
        
        SimUtil.printGraphCommand(title,x,y,new int[][] {result},new String[]{"bob"});
    }

    public static final void measureWriteVarySeek() throws Exception {
        String title = "Write Speed Varying Seeks";
        String x = "Number of Seeks";
        String y = "Time to Write 50MB (ms)";

        int[][] plots = new int[3][];
        int seekMin = 0; // these numbers are percentages
        int seekMax = 100;
	int seekInc = 10;
        int fileSize = 51200000; // 50MB

	byte[] b = new byte[1024];
	java.util.Arrays.fill(b,(byte) 10);

        // run each one 3 times and throw out the two extremes.
        for (int p=0;p<3;p++) {
            plots[p] = new int[(2*(seekMax-seekMin)/seekInc)+
	    (seekMax % seekInc == 0 ? 2 : 0)];
            for (int n=seekMin,j=0;n<=seekMax;n+=seekInc,j++) {
		int numSeeks = 0;
                System.out.println(n);
                f.delete();
                RandomAccessFile raf = new RandomAccessFile(f,"rw");
                long t1 = System.currentTimeMillis();
                for (int a=0;a<fileSize;a+=1024) {
		    if (rand.nextInt(100) < n) {
			numSeeks++;
			raf.seek(Math.abs(rand.nextInt())%fileSize);
		    }
                    raf.write(b);
                }
                long t2 = System.currentTimeMillis();
		raf.close();
                plots[p][2*j] = numSeeks;
                plots[p][(2*j)+1] = (int) (t2 - t1);
            }
        }

        int[] result = new int[plots[0].length];
        for (int j=0;j<result.length;j++) {
            result[j] = SimUtil.getMedian(new int[] {plots[0][j],
                                                         plots[1][j],
                                                         plots[2][j]});
        }
        
        SimUtil.printGraphCommand(title,x,y,new int[][] {result},new String[]{"bob"});
    }

    public static void main(String[] args) throws Exception {
	//measureWriteVarySeek();
        //measureSequentialWriteVaryBuffer();
	//measureSequentialReadVaryBuffer();
	measureRandomWriteVaryBuffer();
    }
}
