/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class MoveDirectoryCommand
extends AbstractCommand {
    public static final String PREFIX = "%moveDirectory";
    private static final Logger LOG = Logger.getInstance(MoveDirectoryCommand.class);

    public MoveDirectoryCommand(@NotNull String text, int line) {
        if (text == null) {
            MoveDirectoryCommand.$$$reportNull$$$0(0);
        }
        super(text, line, true);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            MoveDirectoryCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        PsiManagerImpl myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
        String input = this.extractCommandArgument(PREFIX);
        String[] lineAndColumn = input.split(" ");
        String sourcePath = lineAndColumn[0];
        String targetPath = lineAndColumn[1];
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null) {
            VirtualFile sourceVirtualFile = projectDir.findFileByRelativePath(sourcePath);
            VirtualFile targetVirtualFile = projectDir.findFileByRelativePath(targetPath);
            if (sourceVirtualFile != null && targetVirtualFile != null) {
                PsiDirectory sourcePsiDir = myPsiManager.findDirectory(sourceVirtualFile);
                PsiDirectory targetPsiDir = myPsiManager.findDirectory(targetVirtualFile);
                ApplicationManager.getApplication().invokeAndWait(() -> WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                    MoveFilesOrDirectoriesUtil.doMoveDirectory((PsiDirectory)sourcePsiDir, (PsiDirectory)targetPsiDir);
                    LOG.info("Dir " + sourcePath + " has been moved to " + targetPath);
                    actionCallback.setDone();
                }), ModalityState.nonModal());
            } else {
                actionCallback.reject("Source or target dir is not found");
            }
        } else {
            actionCallback.reject("Project dir can't be guessed");
        }
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            MoveDirectoryCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/MoveDirectoryCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/MoveDirectoryCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

