/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.selector;

import com.intellij.collaboration.auth.ui.LoadingAccountsDetailsProvider;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.collaboration.ui.util.SwingBindingsKt;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ActionLink;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorComponentFactory;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorViewModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.AuthorizationType;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsDetailsProvider;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.selector.GHRepositoryAndAccountSelectorViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.selector.GHSelectorErrorStatusPresenter;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/selector/GHRepositoryAndAccountSelectorComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "vm", "Lorg/jetbrains/plugins/github/pullrequest/ui/selector/GHRepositoryAndAccountSelectorViewModel;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/ui/selector/GHRepositoryAndAccountSelectorViewModel;Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;)V", "create", "Ljavax/swing/JComponent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "createLoginButtons", "", "Ljavax/swing/JButton;", "createPopupLoginActions", "Ljavax/swing/AbstractAction;", "repo", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "loginToGithub", "", "forceNew", "authType", "Lorg/jetbrains/plugins/github/authentication/AuthorizationType;", "loginToGhe", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHRepositoryAndAccountSelectorComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHRepositoryAndAccountSelectorComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/selector/GHRepositoryAndAccountSelectorComponentFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1557#2:143\n1628#2,3:144\n*S KotlinDebug\n*F\n+ 1 GHRepositoryAndAccountSelectorComponentFactory.kt\norg/jetbrains/plugins/github/pullrequest/ui/selector/GHRepositoryAndAccountSelectorComponentFactory\n*L\n37#1:143\n37#1:144,3\n*E\n"})
public final class GHRepositoryAndAccountSelectorComponentFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final GHRepositoryAndAccountSelectorViewModel vm;
    @NotNull
    private final GHAccountManager accountManager;

    public GHRepositoryAndAccountSelectorComponentFactory(@NotNull Project project, @NotNull GHRepositoryAndAccountSelectorViewModel vm2, @NotNull GHAccountManager accountManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)vm2), (String)"vm");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        this.project = project;
        this.vm = vm2;
        this.accountManager = accountManager;
    }

    @NotNull
    public final JComponent create(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        GHAccountsDetailsProvider accountDetailsProvider = new GHAccountsDetailsProvider(scope, this.accountManager);
        GHSelectorErrorStatusPresenter errorPresenter2 = new GHSelectorErrorStatusPresenter(this.project, (Function0<Unit>)((Function0)() -> GHRepositoryAndAccountSelectorComponentFactory.create$lambda$0(this)));
        RepositoryAndAccountSelectorComponentFactory repositoryAndAccountSelectorComponentFactory = new RepositoryAndAccountSelectorComponentFactory((RepositoryAndAccountSelectorViewModel)this.vm);
        Function1 function1 = arg_0 -> GHRepositoryAndAccountSelectorComponentFactory.create$lambda$2(this, arg_0);
        LoadingAccountsDetailsProvider loadingAccountsDetailsProvider = (LoadingAccountsDetailsProvider)accountDetailsProvider;
        Function1 function12 = arg_0 -> GHRepositoryAndAccountSelectorComponentFactory.create$lambda$3(this, arg_0);
        String string = GithubBundle.message("pull.request.view.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return repositoryAndAccountSelectorComponentFactory.create(scope, function1, loadingAccountsDetailsProvider, function12, string, this.createLoginButtons(scope), (ErrorStatusPresenter)errorPresenter2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JButton> createLoginButtons(CoroutineScope scope) {
        void $this$createLoginButtons_u24lambda_u249;
        JButton $this$createLoginButtons_u24lambda_u247;
        JButton $this$createLoginButtons_u24lambda_u245;
        JButton jButton;
        Object[] objectArray = new JButton[3];
        JButton jButton2 = jButton = new JButton(GithubBundle.message("action.Github.Accounts.AddGHAccount.text", new Object[0]));
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        CollaborationToolsUIUtil.INSTANCE.setDefault($this$createLoginButtons_u24lambda_u245, true);
        $this$createLoginButtons_u24lambda_u245.setOpaque(false);
        $this$createLoginButtons_u24lambda_u245.addActionListener(arg_0 -> GHRepositoryAndAccountSelectorComponentFactory.createLoginButtons$lambda$5$lambda$4(this, arg_0));
        SwingBindingsKt.bindVisibilityIn((JComponent)$this$createLoginButtons_u24lambda_u245, (CoroutineScope)scope, (Flow)((Flow)this.vm.getGithubLoginAvailableState()));
        SwingBindingsKt.bindDisabledIn((JComponent)$this$createLoginButtons_u24lambda_u245, (CoroutineScope)scope, (Flow)((Flow)this.vm.getBusyState()));
        Unit unit = Unit.INSTANCE;
        objectArray2[n] = jButton;
        String string = GithubBundle.message("action.Github.Accounts.AddGHAccountWithToken.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createLoginButtons_u24lambda_u245 = jButton = new ActionLink(string, arg_0 -> GHRepositoryAndAccountSelectorComponentFactory.createLoginButtons$lambda$6(this, arg_0));
        n = 1;
        objectArray2 = objectArray;
        boolean bl2 = false;
        $this$createLoginButtons_u24lambda_u247.setAutoHideOnDisable(false);
        SwingBindingsKt.bindVisibilityIn((JComponent)$this$createLoginButtons_u24lambda_u247, (CoroutineScope)scope, (Flow)((Flow)this.vm.getGithubLoginAvailableState()));
        SwingBindingsKt.bindDisabledIn((JComponent)$this$createLoginButtons_u24lambda_u247, (CoroutineScope)scope, (Flow)((Flow)this.vm.getBusyState()));
        unit = Unit.INSTANCE;
        objectArray2[n] = jButton;
        $this$createLoginButtons_u24lambda_u247 = jButton = new JButton(GithubBundle.message("action.Github.Accounts.AddGHEAccount.text", new Object[0]));
        n = 2;
        objectArray2 = objectArray;
        boolean bl3 = false;
        CollaborationToolsUIUtil.INSTANCE.setDefault((JButton)$this$createLoginButtons_u24lambda_u249, true);
        $this$createLoginButtons_u24lambda_u249.setOpaque(false);
        $this$createLoginButtons_u24lambda_u249.addActionListener(arg_0 -> GHRepositoryAndAccountSelectorComponentFactory.createLoginButtons$lambda$9$lambda$8(this, arg_0));
        SwingBindingsKt.bindVisibilityIn((JComponent)((JComponent)$this$createLoginButtons_u24lambda_u249), (CoroutineScope)scope, (Flow)((Flow)this.vm.getGheLoginAvailableState()));
        SwingBindingsKt.bindDisabledIn((JComponent)((JComponent)$this$createLoginButtons_u24lambda_u249), (CoroutineScope)scope, (Flow)((Flow)this.vm.getBusyState()));
        unit = Unit.INSTANCE;
        objectArray2[n] = jButton;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<AbstractAction> createPopupLoginActions(GHGitRepositoryMapping repo) {
        List list;
        boolean isDotComServer;
        Object object = repo;
        boolean bl = object != null && (object = ((GHGitRepositoryMapping)object).getRepository()) != null && (object = ((GHRepositoryCoordinates)object).getServerPath()) != null ? ((GithubServerPath)object).isGithubDotCom() : (isDotComServer = false);
        if (isDotComServer) {
            Object[] objectArray = new AbstractAction[2];
            String string = GithubBundle.message("action.Github.Accounts.AddGHAccount.text", new Object[0]);
            objectArray[0] = new AbstractAction(this, string){
                final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(ActionEvent e) {
                    GHRepositoryAndAccountSelectorComponentFactory.access$loginToGithub(this.this$0, true, AuthorizationType.OAUTH);
                }
            };
            string = GithubBundle.message("action.Github.Accounts.AddGHAccountWithToken.text", new Object[0]);
            objectArray[1] = new AbstractAction(this, string){
                final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(ActionEvent e) {
                    GHRepositoryAndAccountSelectorComponentFactory.access$loginToGithub(this.this$0, true, AuthorizationType.TOKEN);
                }
            };
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            String string = GithubBundle.message("action.Github.Accounts.AddGHEAccount.text", new Object[0]);
            list = CollectionsKt.listOf((Object)new AbstractAction(this, repo, string){
                final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
                final /* synthetic */ GHGitRepositoryMapping $repo;
                {
                    this.this$0 = $receiver;
                    this.$repo = $repo;
                    super($super_call_param$1);
                }

                public void actionPerformed(ActionEvent e) {
                    GHGitRepositoryMapping gHGitRepositoryMapping = this.$repo;
                    Intrinsics.checkNotNull((Object)gHGitRepositoryMapping);
                    GHRepositoryAndAccountSelectorComponentFactory.access$loginToGhe(this.this$0, true, gHGitRepositoryMapping);
                }
            });
        }
        return list;
    }

    private final boolean loginToGithub(boolean forceNew, AuthorizationType authType) {
        GithubAccount account = (GithubAccount)((Object)this.vm.getAccountSelectionState().getValue());
        if (account == null || forceNew) {
            GithubAccount githubAccount;
            GithubAccount githubAccount2;
            GHAccountAuthData gHAccountAuthData = GHAccountsUtil.requestNewAccount$default(GithubServerPath.DEFAULT_SERVER, null, this.project, null, authType, 8, null);
            if (gHAccountAuthData != null && (githubAccount2 = gHAccountAuthData.getAccount()) != null) {
                GithubAccount githubAccount3;
                GithubAccount it = githubAccount3 = githubAccount2;
                boolean bl = false;
                this.vm.getAccountSelectionState().setValue((Object)it);
                githubAccount = githubAccount3;
            } else {
                githubAccount = null;
            }
            return githubAccount != null;
        }
        if (Intrinsics.areEqual((Object)this.vm.getMissingCredentialsState().getValue(), (Object)true)) {
            return GHAccountsUtil.requestReLogin$default(account, this.project, null, authType, 4, null) != null;
        }
        return false;
    }

    private final boolean loginToGhe(boolean forceNew, GHGitRepositoryMapping repo) {
        GithubServerPath server = repo.getRepository().getServerPath();
        GithubAccount account = (GithubAccount)((Object)this.vm.getAccountSelectionState().getValue());
        if (account == null || forceNew) {
            GHAccountAuthData gHAccountAuthData;
            GHAccountAuthData gHAccountAuthData2 = GHAccountsUtil.requestNewAccount$default(server, null, this.project, null, null, 24, null);
            if (gHAccountAuthData2 != null) {
                GHAccountAuthData gHAccountAuthData3;
                GHAccountAuthData it = gHAccountAuthData3 = gHAccountAuthData2;
                boolean bl = false;
                this.vm.getAccountSelectionState().setValue((Object)it.getAccount());
                gHAccountAuthData = gHAccountAuthData3;
            } else {
                gHAccountAuthData = null;
            }
            return gHAccountAuthData != null;
        }
        if (Intrinsics.areEqual((Object)this.vm.getMissingCredentialsState().getValue(), (Object)true)) {
            return GHAccountsUtil.requestReLogin$default(account, this.project, null, AuthorizationType.TOKEN, 4, null) != null;
        }
        return false;
    }

    private static final Unit create$lambda$0(GHRepositoryAndAccountSelectorComponentFactory this$0) {
        this$0.vm.submitSelection();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final String create$lambda$2(GHRepositoryAndAccountSelectorComponentFactory this$0, GHGitRepositoryMapping mapping) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Iterable $this$map$iv = (Iterable)this$0.vm.getRepositoriesState().getValue();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRepository());
        }
        List allRepositories = (List)destination$iv$iv;
        return GHUIUtil.INSTANCE.getRepositoryDisplayName(allRepositories, mapping.getRepository(), true);
    }

    private static final List create$lambda$3(GHRepositoryAndAccountSelectorComponentFactory this$0, GHGitRepositoryMapping it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createPopupLoginActions(it);
    }

    private static final void createLoginButtons$lambda$5$lambda$4(GHRepositoryAndAccountSelectorComponentFactory this$0, ActionEvent it) {
        if (this$0.loginToGithub(false, AuthorizationType.OAUTH)) {
            this$0.vm.submitSelection();
        }
    }

    private static final Unit createLoginButtons$lambda$6(GHRepositoryAndAccountSelectorComponentFactory this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.loginToGithub(false, AuthorizationType.TOKEN)) {
            this$0.vm.submitSelection();
        }
        return Unit.INSTANCE;
    }

    private static final void createLoginButtons$lambda$9$lambda$8(GHRepositoryAndAccountSelectorComponentFactory this$0, ActionEvent it) {
        GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)this$0.vm.getRepoSelectionState().getValue();
        if (gHGitRepositoryMapping == null) {
            return;
        }
        GHGitRepositoryMapping repo = gHGitRepositoryMapping;
        if (this$0.loginToGhe(false, repo)) {
            this$0.vm.submitSelection();
        }
    }

    public static final /* synthetic */ boolean access$loginToGithub(GHRepositoryAndAccountSelectorComponentFactory $this, boolean forceNew, AuthorizationType authType) {
        return $this.loginToGithub(forceNew, authType);
    }

    public static final /* synthetic */ boolean access$loginToGhe(GHRepositoryAndAccountSelectorComponentFactory $this, boolean forceNew, GHGitRepositoryMapping repo) {
        return $this.loginToGhe(forceNew, repo);
    }
}

