/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.FilledCircleLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.PointDimensionsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.LinesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.LinePath;
import org.jetbrains.letsPlot.core.plot.base.stat.DotplotStat;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0003IJKB\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u001bH\u0004J0\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u0002022\u0006\u0010*\u001a\u00020\u0005H\u0002J0\u00103\u001a\u00020-2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0014J>\u0010:\u001a\u00020-2\u0006\u00104\u001a\u0002052\f\u0010;\u001a\b\u0012\u0004\u0012\u00020/0<2\u0006\u00108\u001a\u0002092\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0005H\u0002J8\u0010=\u001a\u00020>2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u001b2\u0006\u00101\u001a\u000202H\u0002J\u0014\u0010@\u001a\u00020A2\n\u0010B\u001a\u0006\u0012\u0002\b\u00030CH\u0016J\b\u0010D\u001a\u00020\u001bH\u0004J0\u0010E\u001a\u0004\u0018\u00010A2\u0006\u0010.\u001a\u00020/2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050C2\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u001bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0007\"\u0004\b\"\u0010\t\u00a8\u0006L"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "()V", "dotSize", "", "getDotSize", "()D", "setDotSize", "(D)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "method", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "getMethod", "()Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "setMethod", "(Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;)V", "stackDir", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom$Stackdir;", "getStackDir", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom$Stackdir;", "setStackDir", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom$Stackdir;)V", "stackGroups", "", "getStackGroups", "()Z", "setStackGroups", "(Z)V", "stackRatio", "getStackRatio", "setStackRatio", "boundedStackSize", "", "stackSize", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "binWidthPx", "stacksAreVertical", "buildHint", "", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "dotId", "geomHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "buildIntern", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "buildStack", "dataPoints", "", "getDotCenter", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "flip", "preferableNullDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "stackDotsAcrossGroups", "widthSpan", "coordAes", "resolution", "isDiscrete", "Companion", "DotHelper", "Stackdir", "plot-base"})
@SourceDebugExtension(value={"SMAP\nDotplotGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotplotGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,243:1\n1477#2:244\n1502#2,3:245\n1505#2,3:255\n372#3,7:248\n215#4,2:258\n*S KotlinDebug\n*F\n+ 1 DotplotGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom\n*L\n78#1:244\n78#1:245,3\n78#1:255,3\n78#1:248,7\n79#1:258,2\n*E\n"})
public class DotplotGeom
extends GeomBase
implements WithWidth {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double dotSize = 1.0;
    private double stackRatio = 1.0;
    private boolean stackGroups;
    @NotNull
    private Stackdir stackDir = DEF_STACKDIR;
    @NotNull
    private DotplotStat.Method method = DEF_METHOD;
    public static final double DEF_DOTSIZE = 1.0;
    public static final double DEF_STACKRATIO = 1.0;
    public static final boolean DEF_STACKGROUPS = false;
    @NotNull
    private static final Stackdir DEF_STACKDIR = Stackdir.UP;
    @NotNull
    private static final DotplotStat.Method DEF_METHOD = DotplotStat.Method.DOTDENSITY;
    public static final boolean HANDLES_GROUPS = false;

    public final double getDotSize() {
        return this.dotSize;
    }

    public final void setDotSize(double d) {
        this.dotSize = d;
    }

    public final double getStackRatio() {
        return this.stackRatio;
    }

    public final void setStackRatio(double d) {
        this.stackRatio = d;
    }

    public final boolean getStackGroups() {
        return this.stackGroups;
    }

    public final void setStackGroups(boolean bl) {
        this.stackGroups = bl;
    }

    @NotNull
    public Stackdir getStackDir() {
        return this.stackDir;
    }

    public void setStackDir(@NotNull Stackdir stackdir) {
        Intrinsics.checkNotNullParameter((Object)((Object)stackdir), (String)"<set-?>");
        this.stackDir = stackdir;
    }

    @NotNull
    public final DotplotStat.Method getMethod() {
        return this.method;
    }

    public final void setMethod(@NotNull DotplotStat.Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"<set-?>");
        this.method = method;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new FilledCircleLegendKeyElementFactory();
    }

    @Override
    @NotNull
    public DoubleSpan preferableNullDomain(@NotNull Aes<?> aes2) {
        DoubleSpan doubleSpan;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(aes2, (String)"aes");
                if (!Intrinsics.areEqual(aes2, Aes.Companion.getY())) break block5;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getStackDir().ordinal()]) {
                    case 1: {
                        doubleSpan = new DoubleSpan(0.0, 1.0);
                        break block6;
                    }
                    case 2: {
                        doubleSpan = new DoubleSpan(-1.0, 0.0);
                        break block6;
                    }
                    case 3: 
                    case 4: {
                        doubleSpan = new DoubleSpan(-0.5, 0.5);
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            doubleSpan = super.preferableNullDomain(aes2);
        }
        return doubleSpan;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        double d;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Iterable<DataPointAesthetics> pointsWithBinWidth = GeomUtil.INSTANCE.withDefined(aesthetics2.dataPoints(), Aes.Companion.getBINWIDTH(), Aes.Companion.getX(), Aes.Companion.getY());
        if (!CollectionsKt.any(pointsWithBinWidth)) {
            return;
        }
        DataPointAesthetics it = (DataPointAesthetics)CollectionsKt.first(pointsWithBinWidth);
        boolean $i$a$-let-DotplotGeom$buildIntern$binWidthPx$22 = false;
        Double d2 = it.x();
        Intrinsics.checkNotNull((Object)d2);
        double x2 = d2;
        Double d3 = it.y();
        Intrinsics.checkNotNull((Object)d3);
        double y2 = d3;
        Double d4 = it.binwidth();
        Intrinsics.checkNotNull((Object)d4);
        double bw = d4;
        DoubleVector doubleVector = coord.toClient(new DoubleVector(x2, y2));
        Intrinsics.checkNotNull((Object)doubleVector);
        DoubleVector p0 = doubleVector;
        DoubleVector doubleVector2 = coord.toClient(new DoubleVector(x2 + bw, y2));
        Intrinsics.checkNotNull((Object)doubleVector2);
        DoubleVector p1 = doubleVector2;
        boolean bl = ctx2.getFlipped();
        if (!bl) {
            d = Math.abs(p0.getX() - p1.getX());
        } else if (bl) {
            d = Math.abs(p0.getY() - p1.getY());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double binWidthPx = d;
        Iterable<DataPointAesthetics> iterable = GeomUtil.INSTANCE.withDefined(pointsWithBinWidth, Aes.Companion.getX(), Aes.Companion.getSTACKSIZE());
        boolean $i$f$groupBy = false;
        void $i$a$-let-DotplotGeom$buildIntern$binWidthPx$22 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p02 = (DataPointAesthetics)element$iv$iv;
            boolean bl2 = false;
            Double key$iv$iv = p02.x();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl4 = false;
            List dataPointStack = (List)entry.getValue();
            this.buildStack(root, dataPointStack, pos, coord, ctx2, binWidthPx);
        }
    }

    private final void buildStack(SvgRoot root, Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2, double binWidthPx) {
        DotHelper dotHelper = new DotHelper(pos, coord, ctx2);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        int builtStackSize = 0;
        for (DataPointAesthetics dataPointAesthetics : dataPoints2) {
            Double d = dataPointAesthetics.stacksize();
            Intrinsics.checkNotNull((Object)d);
            int groupStackSize = this.boundedStackSize(builtStackSize + (int)d.doubleValue(), coord, ctx2, binWidthPx, ctx2.getFlipped()) - builtStackSize;
            int dotId = -1;
            for (int i = 0; i < groupStackSize; ++i) {
                dotId = this.stackDotsAcrossGroups() ? builtStackSize + i : i;
                Double d2 = dataPointAesthetics.stacksize();
                Intrinsics.checkNotNull((Object)d2);
                LinePath path2 = dotHelper.createDot(dataPointAesthetics, this.getDotCenter(dataPointAesthetics, dotId, (int)d2.doubleValue(), binWidthPx, ctx2.getFlipped(), geomHelper), this.dotSize * binWidthPx / (double)2);
                root.add(path2.getRootGroup());
            }
            this.buildHint(dataPointAesthetics, dotId, ctx2, geomHelper, binWidthPx);
            builtStackSize += groupStackSize;
        }
    }

    private final void buildHint(DataPointAesthetics p, int dotId, GeomContext ctx2, GeomHelper geomHelper, double binWidthPx) {
        double dotRadius = this.dotSize * binWidthPx / 2.0;
        int stackDirSign = this.getStackDir() == Stackdir.DOWN ? -1 : 1;
        int flipSign = ctx2.getFlipped() ? 1 : -1;
        Double d = p.stacksize();
        Intrinsics.checkNotNull((Object)d);
        DoubleVector center = this.getDotCenter(p, dotId, (int)d.doubleValue(), binWidthPx, ctx2.getFlipped(), geomHelper);
        DoubleVector shiftToOrigin = new DoubleVector(-dotRadius, (double)(stackDirSign * flipSign) * dotRadius);
        DoubleVector dimension = new DoubleVector(2.0 * dotRadius, 0.0);
        DoubleRectangle rect2 = ctx2.getFlipped() ? new DoubleRectangle(center.add(shiftToOrigin.flip()), dimension.flip()) : new DoubleRectangle(center.add(shiftToOrigin), dimension);
        Function1<DataPointAesthetics, List<Color>> colorMarkerMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.DOT_PLOT, ctx2);
        ctx2.getTargetCollector().addRectangle(p.index(), rect2, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorMarkerMapper.invoke((Object)p), 7, null), ctx2.getFlipped() ? TipLayoutHint.Kind.VERTICAL_TOOLTIP : TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
    }

    private final DoubleVector getDotCenter(DataPointAesthetics p, int dotId, int stackSize, double binWidthPx, boolean flip, GeomHelper geomHelper) {
        double d;
        Double d2 = p.x();
        Intrinsics.checkNotNull((Object)d2);
        double x2 = d2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStackDir().ordinal()]) {
            case 1: {
                d = (double)dotId + 1.0 / (2.0 * this.stackRatio);
                break;
            }
            case 2: {
                d = (double)(-dotId) - 1.0 / (2.0 * this.stackRatio);
                break;
            }
            case 3: {
                d = (double)dotId + 0.5 - (double)stackSize / 2.0;
                break;
            }
            case 4: {
                double parityShift = stackSize % 2 == 0 ? 0.0 : 0.5;
                d = (double)dotId + parityShift - (double)stackSize / 2.0 + 1.0 / (2.0 * this.stackRatio);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double shiftedDotId = d;
        DoubleVector shift = new DoubleVector(0.0, shiftedDotId * this.dotSize * this.stackRatio * binWidthPx);
        DoubleVector doubleVector = geomHelper.toClient(x2, 0.0, p);
        Intrinsics.checkNotNull((Object)doubleVector);
        return doubleVector.add(flip ? shift.flip() : shift.negate());
    }

    protected final boolean stackDotsAcrossGroups() {
        return this.stackGroups && this.method == DotplotStat.Method.HISTODOT;
    }

    protected final int boundedStackSize(int stackSize, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2, double binWidthPx, boolean stacksAreVertical) {
        double d;
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        DoubleRectangle bounds = ctx2.getAesBounds();
        DoubleRectangle doubleRectangle = coord.toClient(bounds);
        Intrinsics.checkNotNull((Object)doubleRectangle);
        DoubleRectangle boundsPx = doubleRectangle;
        boolean bl = stacksAreVertical;
        if (bl) {
            d = boundsPx.getWidth();
        } else if (!bl) {
            d = boundsPx.getHeight();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double it = d;
        boolean bl2 = false;
        int stackCapacityPx = (int)Math.ceil(it / (this.dotSize * this.stackRatio * binWidthPx)) + 1;
        int parityCorrectionTerm = stackSize % 2 == stackCapacityPx % 2 ? 0 : 1;
        return Math.min(stackSize, stackCapacityPx + parityCorrectionTerm);
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return PointDimensionsUtil.INSTANCE.dimensionSpan(p, coordAes, Aes.Companion.getBINWIDTH(), resolution);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom$Companion;", "", "()V", "DEF_DOTSIZE", "", "DEF_METHOD", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "getDEF_METHOD", "()Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "DEF_STACKDIR", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom$Stackdir;", "getDEF_STACKDIR", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom$Stackdir;", "DEF_STACKGROUPS", "", "DEF_STACKRATIO", "HANDLES_GROUPS", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Stackdir getDEF_STACKDIR() {
            return DEF_STACKDIR;
        }

        @NotNull
        public final DotplotStat.Method getDEF_METHOD() {
            return DEF_METHOD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom$DotHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/LinesHelper;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "(Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;)V", "createDot", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LinePath;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "center", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "r", "", "plot-base"})
    public static final class DotHelper
    extends LinesHelper {
        public DotHelper(@NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            super(pos, coord, ctx2);
        }

        @NotNull
        public final LinePath createDot(@NotNull DataPointAesthetics p, @NotNull DoubleVector center, double r) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            DoubleVector leftBound = center.add(new DoubleVector(-r, 0.0));
            DoubleVector rightBound = center.add(new DoubleVector(r, 0.0));
            SvgPathDataBuilder builder = new SvgPathDataBuilder(true);
            builder.moveTo(leftBound);
            builder.ellipticalArc(r, r, 0.0, false, false, rightBound);
            builder.ellipticalArc(r, r, 0.0, false, false, leftBound);
            builder.closePath();
            LinePath path2 = new LinePath(builder);
            this.decorate(path2, p, true, (Function1<? super DataPointAesthetics, Double>)((Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return AesScaling.pointStrokeWidth$default((AesScaling)this.receiver, p0, null, 2, null);
                }
            }));
            return path2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/DotplotGeom$Stackdir;", "", "(Ljava/lang/String;I)V", "UP", "DOWN", "CENTER", "CENTERWHOLE", "plot-base"})
    public static final class Stackdir
    extends Enum<Stackdir> {
        public static final /* enum */ Stackdir UP = new Stackdir();
        public static final /* enum */ Stackdir DOWN = new Stackdir();
        public static final /* enum */ Stackdir CENTER = new Stackdir();
        public static final /* enum */ Stackdir CENTERWHOLE = new Stackdir();
        private static final /* synthetic */ Stackdir[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Stackdir[] values() {
            return (Stackdir[])$VALUES.clone();
        }

        public static Stackdir valueOf(String value) {
            return Enum.valueOf(Stackdir.class, value);
        }

        @NotNull
        public static EnumEntries<Stackdir> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stackdirArray = new Stackdir[]{Stackdir.UP, Stackdir.DOWN, Stackdir.CENTER, Stackdir.CENTERWHOLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Stackdir.values().length];
            try {
                nArray[Stackdir.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stackdir.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stackdir.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Stackdir.CENTERWHOLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

