/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util.sizing;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.util.sizing.SizingMode;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicyKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u001b\u001a\u00020\u00002\u000e\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001dR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "", "widthMode", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;", "heightMode", "width", "", "height", "(Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;Ljava/lang/Double;Ljava/lang/Double;)V", "getHeight", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getHeightMode", "()Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;", "getWidth", "getWidthMode", "getFixedDefined", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "isFixedDefined", "", "normalize", "v", "resize", "figureSize", "toString", "", "withFixedWidth", "withUpdate", "options", "", "Companion", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nSizingPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SizingPolicy.kt\norg/jetbrains/letsPlot/core/util/sizing/SizingPolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
public final class SizingPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SizingMode widthMode;
    @NotNull
    private final SizingMode heightMode;
    @Nullable
    private final Double width;
    @Nullable
    private final Double height;
    @NotNull
    private static final SizingMode NOTEBOOK_WIDTH_MODE = SizingMode.MIN;
    @NotNull
    private static final SizingMode NOTEBOOK_HEIGHT_MODE = SizingMode.SCALED;

    public SizingPolicy(@NotNull SizingMode widthMode, @NotNull SizingMode heightMode, @Nullable Double width2, @Nullable Double height) {
        Intrinsics.checkNotNullParameter((Object)((Object)widthMode), (String)"widthMode");
        Intrinsics.checkNotNullParameter((Object)((Object)heightMode), (String)"heightMode");
        this.widthMode = widthMode;
        this.heightMode = heightMode;
        this.width = width2;
        this.height = height;
    }

    @NotNull
    public final SizingMode getWidthMode() {
        return this.widthMode;
    }

    @NotNull
    public final SizingMode getHeightMode() {
        return this.heightMode;
    }

    @Nullable
    public final Double getWidth() {
        return this.width;
    }

    @Nullable
    public final Double getHeight() {
        return this.height;
    }

    private final double normalize(double v) {
        return Math.max(1.0, v);
    }

    public final boolean isFixedDefined() {
        return this.widthMode == SizingMode.FIXED && this.heightMode == SizingMode.FIXED && this.width != null && this.height != null;
    }

    @NotNull
    public final DoubleVector getFixedDefined() {
        if (!this.isFixedDefined()) {
            boolean bl = false;
            String string = "Undefined fixed size: " + this;
            throw new IllegalStateException(string.toString());
        }
        Double d = this.width;
        Intrinsics.checkNotNull((Object)d);
        double d2 = this.normalize(d);
        Double d3 = this.height;
        Intrinsics.checkNotNull((Object)d3);
        return new DoubleVector(d2, this.normalize(d3));
    }

    @NotNull
    public final DoubleVector resize(@NotNull DoubleVector figureSize) {
        DoubleVector doubleVector;
        Double d;
        Double d2;
        Double definedHeight;
        Double d3;
        Double d4;
        Intrinsics.checkNotNullParameter((Object)figureSize, (String)"figureSize");
        DoubleVector figureSize2 = new DoubleVector(this.normalize(figureSize.getX()), this.normalize(figureSize.getY()));
        Double d5 = this.width;
        if (d5 != null) {
            double it = ((Number)d5).doubleValue();
            boolean bl = false;
            d4 = this.normalize(it);
        } else {
            d4 = null;
        }
        Double definedWidth = d4;
        Double d6 = this.height;
        if (d6 != null) {
            double it = ((Number)d6).doubleValue();
            boolean bl = false;
            d3 = this.normalize(it);
        } else {
            d3 = definedHeight = null;
        }
        if (this.widthMode == SizingMode.SCALED && this.heightMode == SizingMode.SCALED) {
            if (!(definedWidth != null && definedHeight != null)) {
                boolean $i$a$-require-SizingPolicy$resize$22 = false;
                String $i$a$-require-SizingPolicy$resize$22 = "Both 'width' and 'height' are required when both sides scaled: " + this;
                throw new IllegalArgumentException($i$a$-require-SizingPolicy$resize$22.toString());
            }
            DoubleVector containerSize = new DoubleVector(this.normalize(definedWidth), this.normalize(definedHeight));
            return new DoubleRectangle(DoubleVector.Companion.getZERO(), containerSize).shrinkToAspectRatio(figureSize2).getDimension();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.widthMode.ordinal()]) {
            case 1: {
                Double d7 = definedWidth;
                if (d7 == null) {
                    throw new IllegalArgumentException("Undefined `width`: " + this);
                }
                d2 = (double)d7;
                break;
            }
            case 2: {
                double d8;
                Double d9 = definedWidth;
                if (d9 != null) {
                    double it = ((Number)d9).doubleValue();
                    boolean bl = false;
                    double d10 = definedWidth;
                    d8 = Math.min(figureSize2.getX(), d10);
                } else {
                    d8 = figureSize2.getX();
                }
                d2 = d8;
                break;
            }
            case 3: {
                d2 = null;
                break;
            }
            case 4: {
                Double d11 = definedWidth;
                d2 = d11 != null ? d11.doubleValue() : figureSize2.getX();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Double widthFixed = d2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.heightMode.ordinal()]) {
            case 1: {
                Double d12 = definedHeight;
                if (d12 == null) {
                    throw new IllegalArgumentException("Undefined `height`: " + this);
                }
                d = (double)d12;
                break;
            }
            case 2: {
                double d13;
                Double d14 = definedHeight;
                if (d14 != null) {
                    double it = ((Number)d14).doubleValue();
                    boolean bl = false;
                    double d15 = definedHeight;
                    d13 = Math.min(figureSize2.getY(), d15);
                } else {
                    d13 = figureSize2.getY();
                }
                d = d13;
                break;
            }
            case 3: {
                d = null;
                break;
            }
            case 4: {
                Double d16 = definedHeight;
                d = d16 != null ? d16.doubleValue() : figureSize2.getY();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Double heightFixed = d;
        if (widthFixed != null && heightFixed != null) {
            doubleVector = new DoubleVector(widthFixed, heightFixed);
        } else if (widthFixed != null) {
            double height = widthFixed / figureSize2.getX() * figureSize2.getY();
            doubleVector = new DoubleVector(widthFixed, height);
        } else if (heightFixed != null) {
            double width2 = heightFixed / figureSize2.getY() * figureSize2.getX();
            doubleVector = new DoubleVector(width2, heightFixed);
        } else {
            doubleVector = figureSize2;
        }
        return doubleVector;
    }

    @NotNull
    public final SizingPolicy withFixedWidth(double width2) {
        SizingMode sizingMode2 = SizingMode.FIXED;
        SizingMode sizingMode3 = this.heightMode;
        Double d = this.height;
        return new SizingPolicy(sizingMode2, sizingMode3, width2, d);
    }

    @NotNull
    public final SizingPolicy withUpdate(@NotNull Map<?, ?> options) {
        SizingMode sizingMode2;
        SizingMode widthMode;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        SizingMode sizingMode3 = SizingPolicy.Companion.sizingMode(options, "width_mode");
        if (sizingMode3 == null) {
            sizingMode3 = widthMode = this.widthMode;
        }
        if ((sizingMode2 = SizingPolicy.Companion.sizingMode(options, "height_mode")) == null) {
            sizingMode2 = this.heightMode;
        }
        SizingMode heightMode = sizingMode2;
        Object obj = options.get("width");
        Number number = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
        Double width2 = number != null ? Double.valueOf(number.doubleValue()) : this.width;
        Object obj2 = options.get("height");
        Number number2 = obj2 instanceof Number ? (Number)((Number)obj2) : (Number)null;
        Double height = number2 != null ? Double.valueOf(number2.doubleValue()) : this.height;
        return new SizingPolicy(widthMode, heightMode, width2, height);
    }

    @NotNull
    public String toString() {
        return "SizingPolicy(widthMode=" + (Object)((Object)this.widthMode) + ", heightMode=" + (Object)((Object)this.heightMode) + ", width=" + this.width + ", height=" + this.height + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tJ\u0006\u0010\n\u001a\u00020\u0007J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy$Companion;", "", "()V", "NOTEBOOK_HEIGHT_MODE", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingMode;", "NOTEBOOK_WIDTH_MODE", "create", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "options", "", "notebookCell", "sizingMode", "option", "", "plot-stem"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SizingPolicy notebookCell() {
            return new SizingPolicy(NOTEBOOK_WIDTH_MODE, NOTEBOOK_HEIGHT_MODE, null, null);
        }

        @NotNull
        public final SizingPolicy create(@NotNull Map<?, ?> options) {
            SizingMode sizingMode2;
            SizingMode widthMode;
            Intrinsics.checkNotNullParameter(options, (String)"options");
            Object obj = options.get("width");
            Number number = obj instanceof Number ? (Number)((Number)obj) : (Number)null;
            Double width2 = number != null ? Double.valueOf(number.doubleValue()) : null;
            Object obj2 = options.get("height");
            Number number2 = obj2 instanceof Number ? (Number)((Number)obj2) : (Number)null;
            Double height = number2 != null ? Double.valueOf(number2.doubleValue()) : null;
            boolean defaultFixed = width2 != null && height != null;
            SizingMode defaultWidthMode = defaultFixed ? SizingMode.FIXED : NOTEBOOK_WIDTH_MODE;
            SizingMode defaultHeightMode = defaultFixed ? SizingMode.FIXED : NOTEBOOK_HEIGHT_MODE;
            SizingMode sizingMode3 = this.sizingMode(options, "width_mode");
            if (sizingMode3 == null) {
                sizingMode3 = widthMode = defaultWidthMode;
            }
            if ((sizingMode2 = this.sizingMode(options, "height_mode")) == null) {
                sizingMode2 = defaultHeightMode;
            }
            SizingMode heightMode = sizingMode2;
            return new SizingPolicy(widthMode, heightMode, width2, height);
        }

        private final SizingMode sizingMode(Map<?, ?> options, String option) {
            SizingMode sizingMode2;
            Object obj = options.get(option);
            if (obj != null) {
                Object value = obj;
                boolean bl = false;
                sizingMode2 = SizingMode.Companion.byNameIgnoreCase((String)value);
                if (sizingMode2 == null) {
                    Companion it = Companion;
                    boolean bl2 = false;
                    SizingPolicyKt.access$getLOG$p().info((Function0<String>)((Function0)new Function0<String>(option, value){
                        final /* synthetic */ String $option;
                        final /* synthetic */ Object $value;
                        {
                            this.$option = $option;
                            this.$value = $value;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Option " + this.$option + ": unexpected value '" + this.$value + '\'';
                        }
                    }));
                    sizingMode2 = null;
                }
            } else {
                sizingMode2 = null;
            }
            return sizingMode2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SizingMode.values().length];
            try {
                nArray[SizingMode.FIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizingMode.MIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizingMode.SCALED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizingMode.FIXED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

