/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.AwtFontInteropKt;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import java.awt.Color;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0006\u0010\u0003\u001a\u00020\u0001\u00a8\u0006\u0004"}, d2={"retrieveDefaultTextStyle", "Landroidx/compose/ui/text/TextStyle;", "retrieveEditorTextStyle", "retrieveConsoleTextStyle", "intellij.platform.jewel.ideLafBridge"})
@SourceDebugExtension(value={"SMAP\nIntUiBridgeText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntUiBridgeText.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeTextKt\n+ 2 TextUnit.kt\nandroidx/compose/ui/unit/TextUnit\n*L\n1#1,49:1\n147#2,2:50\n147#2,2:52\n*S KotlinDebug\n*F\n+ 1 IntUiBridgeText.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeTextKt\n*L\n25#1:50,2\n45#1:52,2\n*E\n"})
public final class IntUiBridgeTextKt {
    @NotNull
    public static final TextStyle retrieveDefaultTextStyle() {
        return BridgeUtilsKt.retrieveTextStyle-tD9LlGs$default("Label.font", "Label.foreground", 0L, false, 0, 0L, 60, null);
    }

    @NotNull
    public static final TextStyle retrieveEditorTextStyle() {
        EditorColorsScheme editorColorScheme = BridgeUtilsKt.retrieveEditorColorScheme();
        long fontSize = TextUnitKt.getSp((int)editorColorScheme.getEditorFontSize());
        TextStyle textStyle = IntUiBridgeTextKt.retrieveDefaultTextStyle();
        Color color = editorColorScheme.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultForeground(...)");
        long l = BridgeUtilsKt.toComposeColor(color);
        Font font = editorColorScheme.getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        FontFamily fontFamily = AwtFontInteropKt.asComposeFontFamily((Font)font);
        float other$iv = editorColorScheme.getLineSpacing();
        boolean bl = false;
        TextUnitKt.checkArithmetic--R2X_6o((long)fontSize);
        long l2 = TextUnitKt.pack((long)TextUnit.getRawType-impl((long)fontSize), (float)(TextUnit.getValue-impl((long)fontSize) * other$iv));
        String string = !editorColorScheme.isUseLigatures() ? "liga 0" : "liga 1";
        return TextStyle.copy-p1EtxEg$default((TextStyle)textStyle, (long)l, (long)fontSize, null, null, null, (FontFamily)fontFamily, (String)string, (long)0L, null, null, null, (long)0L, null, null, null, (int)0, (int)0, (long)l2, null, null, null, (int)0, (int)0, null, (int)16646044, null);
    }

    @NotNull
    public static final TextStyle retrieveConsoleTextStyle() {
        EditorColorsScheme editorColorScheme = BridgeUtilsKt.retrieveEditorColorScheme();
        if (editorColorScheme.isUseEditorFontPreferencesInConsole()) {
            return IntUiBridgeTextKt.retrieveEditorTextStyle();
        }
        long fontSize = TextUnitKt.getSp((int)editorColorScheme.getConsoleFontSize());
        Color color = editorColorScheme.getColor(ColorKey.createColorKey((String)"BLOCK_TERMINAL_DEFAULT_FOREGROUND"));
        if (color == null) {
            Color color2 = editorColorScheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
        }
        Color fontColor = color;
        TextStyle textStyle = IntUiBridgeTextKt.retrieveDefaultTextStyle();
        long l = BridgeUtilsKt.toComposeColor(fontColor);
        Font font = editorColorScheme.getFont(EditorFontType.CONSOLE_PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        FontFamily fontFamily = AwtFontInteropKt.asComposeFontFamily((Font)font);
        float other$iv = editorColorScheme.getLineSpacing();
        boolean bl = false;
        TextUnitKt.checkArithmetic--R2X_6o((long)fontSize);
        long l2 = TextUnitKt.pack((long)TextUnit.getRawType-impl((long)fontSize), (float)(TextUnit.getValue-impl((long)fontSize) * other$iv));
        String string = !editorColorScheme.isUseLigatures() ? "liga 0" : "liga 1";
        return TextStyle.copy-p1EtxEg$default((TextStyle)textStyle, (long)l, (long)fontSize, null, null, null, (FontFamily)fontFamily, (String)string, (long)0L, null, null, null, (long)0L, null, null, null, (int)0, (int)0, (long)l2, null, null, null, (int)0, (int)0, null, (int)16646044, null);
    }
}

