/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.ScanningFileListener;
import com.intellij.javascript.nodejs.library.ScanningFileListenerContributor;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeNodeProcessingResult;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.kind.ContentOrigin;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.ProjectFileOrDirOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDetectingProjectFileScanner
implements IndexableFileScanner {
    @NotNull
    public IndexableFileScanner.ScanSession startSession(final @NotNull Project project) {
        if (project == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(0);
        }
        final ScanningFileListenerRegistrarImpl registrar = new ScanningFileListenerRegistrarImpl(project);
        for (ScanningFileListenerContributor listener2 : ScanningFileListenerContributor.EP_NAME.getExtensionList()) {
            listener2.register(registrar);
        }
        final AtomicBoolean newNodeModulesScanned = new AtomicBoolean(false);
        IndexableFileScanner.ScanSession scanSession = fileSet -> fileSet instanceof ContentOrigin || fileSet instanceof ProjectFileOrDirOrigin ? new IndexableFileScanner.IndexableFileVisitor(){

            public void visitFile(@NotNull VirtualFile fileOrDir) {
                if (fileOrDir == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSDetectingProjectFileScanner.visitFileForNewNodeModules(project, newNodeModulesScanned, fileSet, fileOrDir, registrar);
            }

            public void visitingFinished() {
                registrar.fireListeners();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/library/JSDetectingProjectFileScanner$1", "visitFile"));
            }
        } : null;
        if (scanSession == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(1);
        }
        return scanSession;
    }

    private static void visitFileForNewNodeModules(@NotNull Project project, @NotNull AtomicBoolean newNodeModulesScanned, @NotNull IndexableSetOrigin fileSet, @NotNull VirtualFile fileOrDir, @NotNull ScanningFileListenerRegistrarImpl registrar) {
        Runnable outsideReadActionRunnable;
        if (project == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(2);
        }
        if (newNodeModulesScanned == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(3);
        }
        if (fileSet == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(4);
        }
        if (fileOrDir == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(5);
        }
        if (registrar == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(6);
        }
        if ((outsideReadActionRunnable = (Runnable)ReadAction.compute(() -> {
            NodeModulesDirectoryManager manager;
            if (project.isDisposed() || !fileOrDir.isValid()) {
                return null;
            }
            String fileName = fileOrDir.getName();
            boolean isDirectory = fileOrDir.isDirectory();
            registrar.fileFound(fileOrDir, fileName, isDirectory);
            if (isDirectory && NodeModulesDirectoryManager.isNodeModulesDir(fileOrDir) && !(manager = NodeModulesDirectoryManager.getInstance(project)).isAdded(fileOrDir) && manager.canAddNodeModulesDir(fileOrDir)) {
                return () -> {
                    AtomicBoolean atomicBoolean = newNodeModulesScanned;
                    synchronized (atomicBoolean) {
                        if (newNodeModulesScanned.compareAndSet(false, true)) {
                            VirtualFile singleRoot = fileSet instanceof ProjectFileOrDirOrigin ? ((ProjectFileOrDirOrigin)fileSet).getFileOrDir() : null;
                            JSDetectingProjectFileScanner.scanAndAddAllNewNodeModulesDirs(manager, singleRoot);
                        }
                    }
                };
            }
            return null;
        })) != null) {
            outsideReadActionRunnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanAndAddAllNewNodeModulesDirs(@NotNull NodeModulesDirectoryManager manager, @Nullable VirtualFile singleRoot) {
        if (manager == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(7);
        }
        List nodeModulesDirs = Collections.synchronizedList(new ArrayList());
        AtomicBoolean done = new AtomicBoolean(false);
        try {
            JSDetectingProjectFileScanner.scan(manager.getProject(), singleRoot, fileOrDir -> {
                if (JSDetectingProjectFileScanner.isNewNodeModules(fileOrDir, manager)) {
                    if (done.get()) {
                        throw new AssertionError((Object)"Visiting file after scan finished");
                    }
                    nodeModulesDirs.add(fileOrDir);
                    return TreeNodeProcessingResult.SKIP_CHILDREN;
                }
                return TreeNodeProcessingResult.CONTINUE;
            });
        }
        finally {
            done.set(true);
            JSDetectingProjectFileScanner.finish(manager, new ArrayList<VirtualFile>(nodeModulesDirs));
        }
    }

    private static void scan(@NotNull Project project, @Nullable VirtualFile singleRoot, @NotNull ContentIteratorEx iterator) {
        if (project == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(8);
        }
        if (iterator == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(9);
        }
        if (singleRoot != null) {
            ProjectFileIndex fileIndex = (ProjectFileIndex)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)project));
            fileIndex.iterateContentUnderDirectory(singleRoot, (ContentIterator)iterator);
        } else {
            ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (progress != null) {
                PushedFilePropertiesUpdaterImpl.scanProject((Project)project, module -> iterator);
            } else {
                ProgressManager.getInstance().runProcess(() -> PushedFilePropertiesUpdaterImpl.scanProject((Project)project, module -> iterator), (ProgressIndicator)new EmptyProgressIndicator());
            }
        }
    }

    private static boolean isNewNodeModules(@NotNull VirtualFile fileOrDir, @NotNull NodeModulesDirectoryManager manager) {
        if (fileOrDir == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(11);
        }
        return (Boolean)ReadAction.compute(() -> fileOrDir.isDirectory() && fileOrDir.isValid() && !manager.getProject().isDisposed() && NodeModulesDirectoryManager.isNodeModulesDir(fileOrDir) && !manager.isAdded(fileOrDir) && manager.canAddNodeModulesDir(fileOrDir));
    }

    private static void finish(@NotNull NodeModulesDirectoryManager manager, @NotNull List<VirtualFile> nodeModulesDirs) {
        if (manager == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(12);
        }
        if (nodeModulesDirs == null) {
            JSDetectingProjectFileScanner.$$$reportNull$$$0(13);
        }
        if (!nodeModulesDirs.isEmpty()) {
            ReadAction.run(() -> {
                if (!manager.getProject().isDisposed()) {
                    manager.addNodeModulesDirs(nodeModulesDirs);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/JSDetectingProjectFileScanner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNodeModulesScanned";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/JSDetectingProjectFileScanner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startSession";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitFileForNewNodeModules";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "scanAndAddAllNewNodeModulesDirs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scan";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNewNodeModules";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "finish";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class ScanningFileListenerRegistrarImpl
    implements ScanningFileListenerContributor.Registrar {
        @NotNull
        private final Project myProject;
        private final MultiMap<String, ScanningFileListener> myFileListeners;
        private final MultiMap<String, ScanningFileListener> myDirectoryListeners;
        private final MultiMap<ScanningFileListener, VirtualFile> myListenersToFire;

        private ScanningFileListenerRegistrarImpl(@NotNull Project project) {
            if (project == null) {
                ScanningFileListenerRegistrarImpl.$$$reportNull$$$0(0);
            }
            this.myFileListeners = new MultiMap();
            this.myDirectoryListeners = new MultiMap();
            this.myListenersToFire = MultiMap.createConcurrentSet();
            this.myProject = project;
        }

        @Override
        public void registerFileListener(@NotNull String fileName, boolean isDirectory, @NotNull ScanningFileListener listener2) {
            if (fileName == null) {
                ScanningFileListenerRegistrarImpl.$$$reportNull$$$0(1);
            }
            if (listener2 == null) {
                ScanningFileListenerRegistrarImpl.$$$reportNull$$$0(2);
            }
            if (isDirectory) {
                this.myDirectoryListeners.putValue((Object)fileName, (Object)listener2);
            } else {
                this.myFileListeners.putValue((Object)fileName, (Object)listener2);
            }
        }

        private void fileFound(@NotNull VirtualFile fileOrDir, @NotNull String fileOrDirName, boolean isDirectory) {
            if (fileOrDir == null) {
                ScanningFileListenerRegistrarImpl.$$$reportNull$$$0(3);
            }
            if (fileOrDirName == null) {
                ScanningFileListenerRegistrarImpl.$$$reportNull$$$0(4);
            }
            Collection<ScanningFileListener> listeners = this.getListeners(fileOrDirName, isDirectory);
            for (ScanningFileListener listener2 : listeners) {
                this.myListenersToFire.putValue((Object)listener2, (Object)fileOrDir);
            }
        }

        @NotNull
        private Collection<ScanningFileListener> getListeners(@NotNull String fileOrDirName, boolean isDirectory) {
            if (fileOrDirName == null) {
                ScanningFileListenerRegistrarImpl.$$$reportNull$$$0(5);
            }
            MultiMap<String, ScanningFileListener> listenersMap = isDirectory ? this.myDirectoryListeners : this.myFileListeners;
            Collection collection = listenersMap.get((Object)fileOrDirName);
            if (collection == null) {
                ScanningFileListenerRegistrarImpl.$$$reportNull$$$0(6);
            }
            return collection;
        }

        private void fireListeners() {
            for (ScanningFileListener listener2 : this.myListenersToFire.keySet()) {
                ReadAction.run(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    Collection files = this.myListenersToFire.remove((Object)listener2);
                    if (files == null) {
                        return;
                    }
                    List<VirtualFile> validFiles = files.stream().filter(file -> file.isValid()).toList();
                    if (validFiles.isEmpty()) {
                        return;
                    }
                    listener2.filesFound(this.myProject, validFiles);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOrDir";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileOrDirName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/JSDetectingProjectFileScanner$ScanningFileListenerRegistrarImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/JSDetectingProjectFileScanner$ScanningFileListenerRegistrarImpl";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListeners";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "registerFileListener";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fileFound";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getListeners";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }
}

