/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.npm.WorkingDirectoryDependentNpmPackageVersionManager;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

class CustomNpmRegistryService {
    private static final Logger LOG = Logger.getInstance(CustomNpmRegistryService.class);
    private static final String SCOPED_REGISTRY_KEY_SUFFIX = ":registry";
    private static final String REGISTRY_KEY = "registry";
    private static final Set<String> PUBLIC_REGISTRY_URLS = Set.of("https://registry.npmjs.org", "https://registry.npmjs.org/", "https://registry.yarnpkg.com", "https://registry.yarnpkg.com/");
    private static final int TIMEOUT = 10000;
    private static final ExecutorService EXECUTOR = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)CustomNpmRegistryService.class.getSimpleName());
    private final Project myProject;
    private long myLastExternalChangesCount;
    private NodeJsInterpreterRef myLastInterpreterRef;
    private NodePackageRef myLastNpmPackageRef;
    private final Map<VirtualFile, Registries> myCache;
    private final Map<PackageKey, TimestampedVersions> myVersionsCache;

    CustomNpmRegistryService(@NotNull Project project) {
        if (project == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(0);
        }
        this.myCache = new ConcurrentHashMap<VirtualFile, Registries>();
        this.myVersionsCache = CollectionFactory.createConcurrentSoftMap();
        this.myProject = project;
    }

    @Nullable
    Registry findRegistry(@NotNull VirtualFile contextFileOrDir, @NotNull String packageNamePrefix) {
        if (contextFileOrDir == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(1);
        }
        if (packageNamePrefix == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(2);
        }
        ProgressIndicator indicator = CustomNpmRegistryService.getGlobalIndicator();
        VirtualFile directory = CustomNpmRegistryService.getDirectory(contextFileOrDir);
        if (directory == null) {
            LOG.warn("No directory for " + String.valueOf(contextFileOrDir) + ", npm registries won't be found");
            return null;
        }
        Registries registries = this.findRegistries(indicator, directory);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found registries: " + String.valueOf(registries));
        }
        return registries.findBestRegistry(packageNamePrefix);
    }

    @NotNull
    List<NodePackageBasicInfo> findPackages(@Nullable Registry registry, @NotNull VirtualFile contextFileOrDir, @NotNull String packageNamePrefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter) {
        List<NodePackageBasicInfo> list;
        if (contextFileOrDir == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(3);
        }
        if (packageNamePrefix == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(4);
        }
        if (filter == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(5);
        }
        ProgressIndicator indicator = CustomNpmRegistryService.getGlobalIndicator();
        VirtualFile directory = CustomNpmRegistryService.getDirectory(contextFileOrDir);
        if (directory == null) {
            List<NodePackageBasicInfo> list2 = List.of();
            if (list2 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(6);
            }
            return list2;
        }
        long startNano = System.nanoTime();
        String commandInfo = "npm search '" + packageNamePrefix + "', registry=" + String.valueOf(registry);
        try {
            List<NodePackageBasicInfo> result2 = this.npmSearch(indicator, directory, packageNamePrefix);
            LOG.info(commandInfo + " " + CustomNpmRegistryService.getContextDebugInfo(startNano, directory) + ": " + String.valueOf(ContainerUtil.map(result2, info -> info.getName())));
            list = result2.stream().filter(info -> filter.value(info) && info.getName().startsWith(packageNamePrefix)).limit(limit).collect(Collectors.toList());
        }
        catch (ExecutionException e) {
            LOG.info("Failed to run (" + commandInfo + ") " + CustomNpmRegistryService.getContextDebugInfo(startNano, directory), (Throwable)e);
            List<NodePackageBasicInfo> list3 = List.of();
            if (list3 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(8);
            }
            return list3;
        }
        if (list == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static ProgressIndicator getGlobalIndicator() {
        ProgressIndicator progressIndicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator());
        if (progressIndicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(9);
        }
        return progressIndicator;
    }

    @NotNull
    private List<NodePackageBasicInfo> npmSearch(@NotNull ProgressIndicator indicator, final @NotNull VirtualFile directory, final @NotNull String packageNamePrefix) throws ExecutionException {
        ProcessOutput output;
        List<NodePackageBasicInfo> result2;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(10);
        }
        if (directory == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(11);
        }
        if (packageNamePrefix == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(12);
        }
        if ((result2 = CustomNpmRegistryService.parsePackageInfos((output = this.run(indicator, directory, NodePackageRef.create("npm"), new TargetRunConfigurer(){

            @Override
            public void configure(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg) throws ExecutionException {
                if (targetRun == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (npmPkg == null) {
                    1.$$$reportNull$$$0(1);
                }
                NpmUtil.configureNpmCommand(targetRun, npmPkg, directory.toNioPath(), NpmCommand.SEARCH, List.of("--json", packageNamePrefix));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetRun";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "npmPkg";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$1";
                objectArray[2] = "configure";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).getStdout())) != null) {
            List<NodePackageBasicInfo> list = result2;
            if (list == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(13);
            }
            return list;
        }
        throw new ExecutionException("Failed to parse packages from " + output.getStdout());
    }

    @Nullable
    private static List<NodePackageBasicInfo> parsePackageInfos(@NotNull String stdout) {
        JsonArray array;
        if (stdout == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(14);
        }
        try {
            array = (JsonArray)ObjectUtils.tryCast((Object)JsonParser.parseString((String)stdout), JsonArray.class);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        if (array == null) {
            return null;
        }
        ArrayList<NodePackageBasicInfo> result2 = new ArrayList<NodePackageBasicInfo>();
        for (JsonElement element : array) {
            JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)element, JsonObject.class);
            if (obj == null) continue;
            String name = JsonUtil.getChildAsString((JsonObject)obj, (String)"name");
            String description = JsonUtil.getChildAsString((JsonObject)obj, (String)"description");
            if (name == null) continue;
            result2.add(new NodePackageBasicInfo(name, description));
        }
        return !array.isEmpty() && result2.isEmpty() ? null : result2;
    }

    @NotNull
    private Registries findRegistries(@NotNull ProgressIndicator indicator, @NotNull VirtualFile directory) {
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(15);
        }
        if (directory == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(16);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Registries registries = Registries.EMPTY;
            if (registries == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(17);
            }
            return registries;
        }
        Registries cachedRegistries = this.myCache.get(directory);
        if (cachedRegistries != null && SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount() == this.myLastExternalChangesCount && NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef().equals(this.myLastInterpreterRef) && NpmManager.getInstance(this.myProject).getPackageRef().equals(this.myLastNpmPackageRef)) {
            Registries registries = cachedRegistries;
            if (registries == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(18);
            }
            return registries;
        }
        Registries registries = this.doFindRegistries(indicator, directory);
        if (registries != null) {
            this.myCache.put(directory, registries);
            this.myLastExternalChangesCount = SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
            this.myLastInterpreterRef = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef();
            this.myLastNpmPackageRef = NpmManager.getInstance(this.myProject).getPackageRef();
            Registries registries2 = registries;
            if (registries2 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(19);
            }
            return registries2;
        }
        Registries registries3 = Objects.requireNonNullElse(cachedRegistries, Registries.EMPTY);
        if (registries3 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(20);
        }
        return registries3;
    }

    @Nullable
    private Registries doFindRegistries(@NotNull ProgressIndicator indicator, final @NotNull VirtualFile directory) {
        NodePackage npmPkg;
        NodeJsInterpreter interpreter2;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(21);
        }
        if (directory == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(22);
        }
        long startNano = System.nanoTime();
        NodePackageRef npmPkgRef = NpmManager.getInstance(this.myProject).getPackageRef();
        boolean isYarn = NpmUtil.isYarnAlikePackageRef(npmPkgRef);
        try {
            interpreter2 = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterOrThrow();
            npmPkg = NpmManager.getInstance(this.myProject).getPackageOrThrow(npmPkgRef, interpreter2);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot find registries", (Throwable)e);
            return null;
        }
        try {
            ProcessOutput output = this.run(indicator, directory, interpreter2, npmPkg, new TargetRunConfigurer(){

                @Override
                public void configure(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg) throws ExecutionException {
                    if (targetRun == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (npmPkg == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    NpmUtil.configureNpmCommand(targetRun, npmPkg, directory.toNioPath(), NpmCommand.CONFIG, List.of("list", "--json"));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "targetRun";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "npmPkg";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$2";
                    objectArray[2] = "configure";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Registries registries = CustomNpmRegistryService.parseRegistriesForNpmOrYarn1(output.getStdout(), isYarn);
            if (registries != null) {
                LOG.info("Found registries (" + npmPkg.getName() + " config list --json) " + CustomNpmRegistryService.getContextDebugInfo(startNano, directory) + ": " + String.valueOf(registries));
                return registries;
            }
            LOG.info("Failed to parse registries " + CustomNpmRegistryService.getContextDebugInfo(startNano, directory) + " from " + output.getStdout());
            return null;
        }
        catch (ExecutionException e) {
            if (isYarn) {
                try {
                    Registries registries = this.findRegistriesForYarn2(indicator, directory, interpreter2, npmPkg);
                    LOG.info("Found registries (" + npmPkg.getName() + " get npmScopes --json) " + CustomNpmRegistryService.getContextDebugInfo(startNano, directory) + ": " + String.valueOf(registries));
                    return registries;
                }
                catch (ExecutionException e2) {
                    LOG.info("Failed to get registries for Yarn2", (Throwable)e2);
                }
            }
            LOG.info("Failed to get registries using npm/Yarn1", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Registries parseRegistriesForNpmOrYarn1(@NotNull String stdout, boolean isYarn) {
        if (stdout == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(23);
        }
        JsonObject rootObj = CustomNpmRegistryService.parseAsJsonObject(stdout);
        if (isYarn && rootObj == null) {
            List<JsonObject> jsonLines = CustomNpmRegistryService.parseOutputAsJsonLinesFromYarn1(stdout);
            if (jsonLines == null) {
                return null;
            }
            return new Registries(jsonLines.stream().flatMap(json -> CustomNpmRegistryService.toRegistries(json).stream()).collect(Collectors.toList()));
        }
        return rootObj == null ? null : new Registries(CustomNpmRegistryService.toRegistries(rootObj));
    }

    @NotNull
    private Registries findRegistriesForYarn2(@NotNull ProgressIndicator indicator, final @NotNull VirtualFile directory, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPkg) throws ExecutionException {
        ProcessOutput output;
        JsonObject rootObj;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(24);
        }
        if (directory == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(25);
        }
        if (interpreter2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(26);
        }
        if (npmPkg == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(27);
        }
        if ((rootObj = CustomNpmRegistryService.parseAsJsonObject((output = this.run(indicator, directory, interpreter2, npmPkg, new TargetRunConfigurer(){

            @Override
            public void configure(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg) throws ExecutionException {
                if (targetRun == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (npmPkg == null) {
                    3.$$$reportNull$$$0(1);
                }
                NpmUtil.configureNpmCommand(targetRun, npmPkg, directory.toNioPath(), NpmCommand.CONFIG, List.of("get", "npmScopes", "--json"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetRun";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "npmPkg";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$3";
                objectArray[2] = "configure";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).getStdout())) == null) {
            throw new ExecutionException("Failed to parse output of `yarn config get npmScopes`; " + output.getStdout());
        }
        ArrayList<Registry> registries = new ArrayList<Registry>();
        for (Map.Entry entry : rootObj.entrySet()) {
            String registryUrl;
            String scope2 = (String)entry.getKey();
            JsonObject scopeObj = (JsonObject)ObjectUtils.tryCast(entry.getValue(), JsonObject.class);
            if (scopeObj == null || (registryUrl = JsonUtil.getChildAsString((JsonObject)scopeObj, (String)"npmRegistryServer")) == null) continue;
            registries.add(new Registry(scope2, registryUrl));
        }
        return new Registries(registries);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static String getContextDebugInfo(long startNano, @NotNull VirtualFile virtualFile) {
        void directory;
        if (virtualFile == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(28);
        }
        Object path2 = directory.getPath();
        String userHome = SystemProperties.getUserHome();
        if (StringUtil.isNotEmpty((String)userHome) && ((String)path2).startsWith(userHome + "/")) {
            path2 = "~" + ((String)path2).substring(userHome.length());
        }
        String string = "(" + TimeoutUtil.getDurationMillis((long)startNano) + " ms, " + (String)path2 + ")";
        if (string == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    private static List<JsonObject> parseOutputAsJsonLinesFromYarn1(@NotNull String stdout) {
        String[] lines;
        if (stdout == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(30);
        }
        ArrayList<JsonObject> result2 = new ArrayList<JsonObject>();
        for (String line : lines = StringUtil.splitByLines((String)stdout, (boolean)true)) {
            JsonObject rootObj = CustomNpmRegistryService.parseAsJsonObject(line);
            if (rootObj == null) {
                return null;
            }
            JsonObject dataObj = CustomNpmRegistryService.unwrapYarn1JsonData(rootObj);
            if (dataObj == null) continue;
            result2.add(dataObj);
        }
        return result2;
    }

    @Nullable
    private static JsonObject unwrapYarn1JsonData(@NotNull JsonObject root) {
        JsonObject dataObj;
        if (root == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(31);
        }
        if ("inspect".equals(JsonUtil.getChildAsString((JsonObject)root, (String)"type")) && (dataObj = JsonUtil.getChildAsObject((JsonObject)root, (String)"data")) != null) {
            return dataObj;
        }
        return null;
    }

    @NotNull
    private static List<Registry> toRegistries(@NotNull JsonObject rootObj) {
        if (rootObj == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(32);
        }
        ArrayList<Registry> registries = new ArrayList<Registry>();
        Set entries = rootObj.entrySet();
        for (Map.Entry entry : entries) {
            String url;
            String key = (String)entry.getKey();
            if (!key.endsWith(SCOPED_REGISTRY_KEY_SUFFIX) && !key.equals(REGISTRY_KEY) || (url = JsonUtil.getString((JsonElement)((JsonElement)entry.getValue()))) == null) continue;
            String scope2 = StringUtil.trimEnd((String)key, (String)SCOPED_REGISTRY_KEY_SUFFIX);
            registries.add(new Registry(key.equals(scope2) ? null : scope2, url));
        }
        ArrayList<Registry> arrayList = registries;
        if (arrayList == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @Nullable
    private static JsonObject parseAsJsonObject(@NotNull String json) {
        if (json == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(34);
        }
        try {
            return (JsonObject)ObjectUtils.tryCast((Object)JsonParser.parseString((String)json), JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    private static long getExternalChangesCount() {
        return SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
    }

    @NotNull
    CompletableFuture<AvailablePackageVersions> getPackageVersions(@NotNull VirtualFile contextFileOrDir, @NotNull String packageName) {
        VirtualFile directory;
        if (contextFileOrDir == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(35);
        }
        if (packageName == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(36);
        }
        if ((directory = CustomNpmRegistryService.getDirectory(contextFileOrDir)) == null) {
            CompletableFuture<AvailablePackageVersions> completableFuture = CompletableFuture.completedFuture(AvailablePackageVersions.createEmpty());
            if (completableFuture == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(37);
            }
            return completableFuture;
        }
        PackageKey packageKey = new PackageKey(directory, packageName);
        TimestampedVersions timestampedVersions = this.myVersionsCache.get(packageKey);
        long externalChangesCount = CustomNpmRegistryService.getExternalChangesCount();
        if (timestampedVersions != null && timestampedVersions.isUpToDate(externalChangesCount)) {
            CompletableFuture<AvailablePackageVersions> completableFuture = CompletableFuture.completedFuture(timestampedVersions.versions);
            if (completableFuture == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(38);
            }
            return completableFuture;
        }
        CompletableFuture<AvailablePackageVersions> result2 = CompletableFuture.supplyAsync(() -> this.calcPackageVersions(directory, packageName), EXECUTOR);
        result2.whenComplete((versions, error) -> {
            if (versions != null) {
                this.myVersionsCache.put(packageKey, new TimestampedVersions(Instant.now(), externalChangesCount, (AvailablePackageVersions)versions));
            }
        });
        CompletableFuture<AvailablePackageVersions> completableFuture = result2;
        if (completableFuture == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(39);
        }
        return completableFuture;
    }

    @NotNull
    private AvailablePackageVersions calcPackageVersions(@NotNull VirtualFile directory, @NotNull String packageName) {
        AvailablePackageVersions availablePackageVersions;
        if (directory == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(40);
        }
        if (packageName == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(41);
        }
        long startNano = System.nanoTime();
        NodePackageRef npmPkgRef = NpmManager.getInstance(this.myProject).getPackageRef();
        try {
            ProgressIndicator indicator = CustomNpmRegistryService.getGlobalIndicator();
            AvailablePackageVersions versions = this.npmInfo(indicator, directory, npmPkgRef, packageName);
            LOG.info("Found versions of " + packageName + " " + CustomNpmRegistryService.getContextDebugInfo(startNano, directory) + ": " + String.valueOf(versions.getVersions()));
            availablePackageVersions = versions;
        }
        catch (ExecutionException | IOException e) {
            LOG.info("Failed to get versions of " + packageName + " " + CustomNpmRegistryService.getContextDebugInfo(startNano, directory), e);
            AvailablePackageVersions availablePackageVersions2 = AvailablePackageVersions.createEmpty();
            if (availablePackageVersions2 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(43);
            }
            return availablePackageVersions2;
        }
        if (availablePackageVersions == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(42);
        }
        return availablePackageVersions;
    }

    @NotNull
    private AvailablePackageVersions npmInfo(@NotNull ProgressIndicator indicator, final @NotNull VirtualFile directory, @NotNull NodePackageRef npmPkgRef, final @NotNull String packageName) throws IOException, ExecutionException {
        ProcessOutput output;
        JsonObject rootObject;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(44);
        }
        if (directory == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(45);
        }
        if (npmPkgRef == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(46);
        }
        if (packageName == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(47);
        }
        if ((rootObject = CustomNpmRegistryService.parseAsJsonObject((output = this.run(indicator, directory, npmPkgRef, new TargetRunConfigurer(){

            @Override
            public void configure(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg) throws ExecutionException {
                if (targetRun == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (npmPkg == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (CustomNpmRegistryService.isYarn2(CustomNpmRegistryService.this.myProject, targetRun.getInterpreter(), directory, npmPkg)) {
                    NpmUtil.configureNpmCommand(targetRun, npmPkg, directory.toNioPath(), NpmCommand.NPM, List.of("info", "--json", packageName));
                } else {
                    NpmUtil.configureNpmCommand(targetRun, npmPkg, directory.toNioPath(), NpmCommand.INFO, List.of("--json", packageName));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetRun";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "npmPkg";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$4";
                objectArray[2] = "configure";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).getStdout())) != null) {
            if (NpmUtil.isYarnAlikePackageRef(npmPkgRef)) {
                rootObject = Objects.requireNonNullElse(CustomNpmRegistryService.unwrapYarn1JsonData(rootObject), rootObject);
            }
            AvailablePackageVersions availablePackageVersions = AvailablePackageVersions.parseFromPackageMetadata(rootObject);
            if (availablePackageVersions == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(48);
            }
            return availablePackageVersions;
        }
        AvailablePackageVersions availablePackageVersions = AvailablePackageVersions.createEmpty();
        if (availablePackageVersions == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(49);
        }
        return availablePackageVersions;
    }

    private static boolean isYarn2(@NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @NotNull VirtualFile directory, @NotNull NodePackage npmPkg) {
        if (project == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(50);
        }
        if (interpreter2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(51);
        }
        if (directory == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(52);
        }
        if (npmPkg == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(53);
        }
        if (!NpmUtil.isYarnAlikePackage(npmPkg)) {
            return false;
        }
        CompletableFuture result2 = new CompletableFuture();
        WorkingDirectoryDependentNpmPackageVersionManager.getInstance(project).fetchVersion(interpreter2, npmPkg, directory.toNioPath(), v -> {}, version2 -> result2.complete(version2));
        try {
            SemVer version3 = (SemVer)result2.get(5L, TimeUnit.SECONDS);
            return version3.isGreaterOrEqualThan(2, 0, 0);
        }
        catch (Exception e) {
            LOG.info("Cannot determine version of " + String.valueOf(npmPkg) + ": " + e.getMessage());
            return false;
        }
    }

    @NotNull
    private ProcessOutput run(@NotNull ProgressIndicator indicator, @NotNull VirtualFile directory, @NotNull NodePackageRef npmPkgRef, @NotNull TargetRunConfigurer targetRunConfigurer) throws ExecutionException {
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(54);
        }
        if (directory == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(55);
        }
        if (npmPkgRef == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(56);
        }
        if (targetRunConfigurer == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(57);
        }
        NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterOrThrow();
        NodePackage npmPkg = NpmManager.getInstance(this.myProject).getPackageOrThrow(npmPkgRef, interpreter2);
        return this.run(indicator, directory, interpreter2, npmPkg, targetRunConfigurer);
    }

    @NotNull
    private ProcessOutput run(@NotNull ProgressIndicator indicator, @NotNull VirtualFile directory, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPkg, @NotNull TargetRunConfigurer targetRunConfigurer) throws ExecutionException {
        ProcessOutput output;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(58);
        }
        if (directory == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(59);
        }
        if (interpreter2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(60);
        }
        if (npmPkg == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(61);
        }
        if (targetRunConfigurer == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(62);
        }
        NodeTargetRun targetRun = new NodeTargetRun(interpreter2, this.myProject, null, NodeTargetRunOptions.of(false));
        targetRun.getCommandLineBuilder().setWorkingDirectory(targetRun.path(directory.getPath()));
        NpmUtil.silenceCorepack(targetRun);
        targetRunConfigurer.configure(targetRun, npmPkg);
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + processWithCmdLine.getCommandLinePresentation());
        }
        if ((output = new CapturingProcessRunner((BaseProcessHandler)processWithCmdLine.getProcessHandler()).runProcess(indicator, 10000)).isCancelled() || output.isTimeout() || output.getExitCode() != 0) {
            throw new ExecutionException("Failed to run " + processWithCmdLine.getCommandLinePresentation() + ": " + String.valueOf(output));
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(63);
        }
        return processOutput;
    }

    @Nullable
    private static VirtualFile getDirectory(@NotNull VirtualFile contextFileOrDir) {
        if (contextFileOrDir == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(64);
        }
        return contextFileOrDir.isDirectory() ? contextFileOrDir : contextFileOrDir.getParent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 13, 17, 18, 19, 20, 29, 33, 37, 38, 39, 42, 43, 48, 49, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 35: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFileOrDir";
                break;
            }
            case 2: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNamePrefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 48: 
            case 49: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService";
                break;
            }
            case 10: 
            case 15: 
            case 21: 
            case 24: 
            case 44: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 40: 
            case 45: 
            case 52: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 14: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 26: 
            case 51: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 27: 
            case 53: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootObj";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 36: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 46: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkgRef";
                break;
            }
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRunConfigurer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalIndicator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "npmSearch";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findRegistries";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextDebugInfo";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "toRegistries";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageVersions";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPackageVersions";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "npmInfo";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRegistry";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPackages";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 29: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 48: 
            case 49: 
            case 63: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "npmSearch";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageInfos";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findRegistries";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doFindRegistries";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseRegistriesForNpmOrYarn1";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findRegistriesForYarn2";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getContextDebugInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "parseOutputAsJsonLinesFromYarn1";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unwrapYarn1JsonData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "toRegistries";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "parseAsJsonObject";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersions";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "calcPackageVersions";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "npmInfo";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isYarn2";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 13, 17, 18, 19, 20, 29, 33, 37, 38, 39, 42, 43, 48, 49, 63 -> new IllegalStateException(string);
        };
    }

    static class Registries {
        private static final Registries EMPTY = new Registries(List.of());
        private final List<Registry> myRegistries;

        private Registries(@NotNull List<Registry> registries) {
            if (registries == null) {
                Registries.$$$reportNull$$$0(0);
            }
            this.myRegistries = List.copyOf(registries);
        }

        private @Unmodifiable @NotNull List<Registry> filterRegistriesByScope(@NotNull String packageNamePrefix) {
            List result2;
            String scope2;
            if (packageNamePrefix == null) {
                Registries.$$$reportNull$$$0(1);
            }
            if ((scope2 = NodeModuleSearchUtil.getScopeByPackageName(packageNamePrefix)) != null) {
                List result3 = ContainerUtil.filter(this.myRegistries, registry -> scope2.equals(registry.myScope));
                if (!result3.isEmpty()) {
                    List list = result3;
                    if (list == null) {
                        Registries.$$$reportNull$$$0(2);
                    }
                    return list;
                }
            } else if (packageNamePrefix.startsWith("@") && !(result2 = ContainerUtil.filter(this.myRegistries, registry -> {
                String registryScope = registry.myScope;
                return registryScope != null && registryScope.startsWith(packageNamePrefix);
            })).isEmpty()) {
                List list = result2;
                if (list == null) {
                    Registries.$$$reportNull$$$0(3);
                }
                return list;
            }
            List list = ContainerUtil.filter(this.myRegistries, registry -> registry.myScope == null);
            if (list == null) {
                Registries.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Nullable
        private Registry findBestRegistry(@NotNull String packageNamePrefix) {
            if (packageNamePrefix == null) {
                Registries.$$$reportNull$$$0(5);
            }
            List<Registry> registries = this.filterRegistriesByScope(packageNamePrefix);
            List customRegistries = ContainerUtil.filter(registries, registry -> !PUBLIC_REGISTRY_URLS.contains(registry.myRegistryUrl));
            return (Registry)ContainerUtil.getFirstItem((List)customRegistries);
        }

        public String toString() {
            return this.myRegistries.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registries";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageNamePrefix";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$Registries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$Registries";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterRegistriesByScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filterRegistriesByScope";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findBestRegistry";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class Registry {
        @Nullable
        private final String myScope;
        @NotNull
        private final String myRegistryUrl;

        private Registry(@Nullable String scope2, @NotNull String registryUrl) {
            if (registryUrl == null) {
                Registry.$$$reportNull$$$0(0);
            }
            if (scope2 != null && !((String)scope2).startsWith("@")) {
                scope2 = "@" + (String)scope2;
            }
            this.myScope = scope2;
            this.myRegistryUrl = registryUrl;
        }

        public String toString() {
            return "(" + this.myScope + ", " + this.myRegistryUrl + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registryUrl", "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$Registry", "<init>"));
        }
    }

    private static interface TargetRunConfigurer {
        public void configure(@NotNull NodeTargetRun var1, @NotNull NodePackage var2) throws ExecutionException;
    }

    private record PackageKey(@NotNull VirtualFile directory, @NotNull String packageName) {
        @NotNull
        private final VirtualFile directory;
        @NotNull
        private final String packageName;

        private PackageKey(@NotNull VirtualFile directory, @NotNull String packageName) {
            if (directory == null) {
                PackageKey.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                PackageKey.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public VirtualFile directory() {
            VirtualFile virtualFile = this.directory;
            if (virtualFile == null) {
                PackageKey.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @NotNull
        public String packageName() {
            String string = this.packageName;
            if (string == null) {
                PackageKey.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$PackageKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$PackageKey";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "directory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "packageName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private record TimestampedVersions(@NotNull Instant timestamp, long externalChangesCount, @NotNull AvailablePackageVersions versions) {
        @NotNull
        private final Instant timestamp;
        @NotNull
        private final AvailablePackageVersions versions;

        /*
         * WARNING - void declaration
         */
        private TimestampedVersions(@NotNull Instant timestamp, long externalChangesCount, @NotNull AvailablePackageVersions availablePackageVersions) {
            void versions;
            if (timestamp == null) {
                TimestampedVersions.$$$reportNull$$$0(0);
            }
            if (availablePackageVersions == null) {
                TimestampedVersions.$$$reportNull$$$0(1);
            }
            this.timestamp = timestamp;
            this.externalChangesCount = externalChangesCount;
            this.versions = versions;
        }

        boolean isUpToDate(long actualExternalChangesCount) {
            return this.externalChangesCount == actualExternalChangesCount && Duration.between(this.timestamp, Instant.now()).compareTo(Duration.ofMinutes(1L)) < 0;
        }

        @NotNull
        public Instant timestamp() {
            Instant instant = this.timestamp;
            if (instant == null) {
                TimestampedVersions.$$$reportNull$$$0(2);
            }
            return instant;
        }

        @NotNull
        public AvailablePackageVersions versions() {
            AvailablePackageVersions availablePackageVersions = this.versions;
            if (availablePackageVersions == null) {
                TimestampedVersions.$$$reportNull$$$0(3);
            }
            return availablePackageVersions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timestamp";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$TimestampedVersions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$TimestampedVersions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "timestamp";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "versions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

