/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.InspectionJSBundle;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class JSInspection
extends LocalInspectionTool {
    protected boolean myOnTheFly;

    @NotNull
    protected abstract PsiElementVisitor createVisitor(@NotNull ProblemsHolder var1, @NotNull LocalInspectionToolSession var2);

    public Set<Class<? extends PsiElement>> getElementsToOptimizeForTSServiceHighlighting() {
        return Collections.emptySet();
    }

    @NotNull
    public String getShortName() {
        return JSInspection.calcShortNameFromClass(((Object)((Object)this)).getClass());
    }

    @NotNull
    public static String calcShortNameFromClass(@NotNull Class aClass) {
        if (aClass == null) {
            JSInspection.$$$reportNull$$$0(0);
        }
        String name = aClass.getName();
        while (name.indexOf(36) != -1) {
            aClass = aClass.getSuperclass();
            name = aClass.getName();
        }
        name = name.substring(name.lastIndexOf(46) + 1);
        String string = name = InspectionProfileEntry.getShortName((String)name);
        if (string == null) {
            JSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JSInspection.$$$reportNull$$$0(3);
        }
        this.myOnTheFly = isOnTheFly;
        final PsiElementVisitor visitor = this.createVisitor(holder, session);
        final Set<Class<? extends PsiElement>> toOptimize = this.getElementsToOptimizeForTSServiceHighlighting();
        if (!toOptimize.isEmpty()) {
            final TypeScriptAnnotatorCheckerProvider checkerProvider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)holder.getFile());
            return new PsiElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!JSInspection.shouldHighlightWithService(element, toOptimize, checkerProvider)) {
                        element.accept(visitor);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSInspection$1", "visitElement"));
                }
            };
        }
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor == null) {
            JSInspection.$$$reportNull$$$0(4);
        }
        return psiElementVisitor;
    }

    private static boolean shouldHighlightWithService(@NotNull PsiElement element, Set<Class<? extends PsiElement>> toOptimize, TypeScriptAnnotatorCheckerProvider checkerProvider) {
        if (element == null) {
            JSInspection.$$$reportNull$$$0(5);
        }
        return ContainerUtil.exists(toOptimize, cls -> cls.isInstance(element)) && checkerProvider.skipErrors(element);
    }

    @NotNull
    public PsiElementVisitor buildVisitorForTSServiceHighlighting(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSInspection.$$$reportNull$$$0(6);
        }
        if (session == null) {
            JSInspection.$$$reportNull$$$0(7);
        }
        this.myOnTheFly = isOnTheFly;
        PsiElementVisitor psiElementVisitor = this.createVisitor(holder, session);
        if (psiElementVisitor == null) {
            JSInspection.$$$reportNull$$$0(8);
        }
        return psiElementVisitor;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public String @NotNull [] getGroupPath() {
        String[] stringArray = new String[]{InspectionJSBundle.message("group.path.javascript", new Object[0]), this.getGroupDisplayName()};
        if (stringArray == null) {
            JSInspection.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    public PsiNamedElement getProblemElement(@NotNull PsiElement psiElement) {
        JSNamedElement namedParent;
        if (psiElement == null) {
            JSInspection.$$$reportNull$$$0(10);
        }
        if ((namedParent = (JSNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSNamedElement.class})) != null) {
            return namedParent;
        }
        return super.getProblemElement(psiElement);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JavaScriptBundle.message("js.inspection.group.name", new Object[0]);
        if (string == null) {
            JSInspection.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Contract(value="_, _, _ -> fail", pure=true)
    public final ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            JSInspection.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            JSInspection.$$$reportNull$$$0(13);
        }
        assert (false) : "should not be called, use visitFile in createVisitor instead";
        if (ProblemDescriptor.EMPTY_ARRAY == null) {
            JSInspection.$$$reportNull$$$0(14);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 8, 9, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSInspection";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcShortNameFromClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitorForTSServiceHighlighting";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcShortNameFromClass";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlightWithService";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitorForTSServiceHighlighting";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProblemElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 8, 9, 11, 14 -> new IllegalStateException(string);
        };
    }
}

