/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.filter;

import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.filter.ExcludedElementsFilterKt;
import com.intellij.lang.javascript.modules.imports.filter.JSImportCandidatesFilter;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/ExcludedElementsFilter;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "acceptedCandidates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "<init>", "(Ljava/util/Set;)V", "accept", "", "candidate", "Factory", "intellij.javascript.impl"})
public final class ExcludedElementsFilter
implements JSImportCandidatesFilter {
    @NotNull
    private final Set<JSImportCandidate> acceptedCandidates;

    public ExcludedElementsFilter(@NotNull Set<? extends JSImportCandidate> acceptedCandidates) {
        Intrinsics.checkNotNullParameter(acceptedCandidates, (String)"acceptedCandidates");
        this.acceptedCandidates = acceptedCandidates;
    }

    @Override
    public boolean accept(@NotNull JSImportCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return this.acceptedCandidates.contains(candidate);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/ExcludedElementsFilter$Factory;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter$FilterFactory;", "<init>", "()V", "createFilter", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "candidates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "intellij.javascript.impl"})
    public static final class Factory
    implements JSImportCandidatesFilter.FilterFactory {
        @Override
        @Nullable
        public JSImportCandidatesFilter createFilter(@NotNull List<? extends JSImportCandidate> candidates) {
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            if (candidates.size() <= 1) {
                return null;
            }
            Set acceptedCandidates = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)candidates), Factory::createFilter$lambda$0));
            if (acceptedCandidates.isEmpty()) {
                return null;
            }
            return new ExcludedElementsFilter(acceptedCandidates);
        }

        private static final boolean createFilter$lambda$0(JSImportCandidate it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !ExcludedElementsFilterKt.access$isExcludedCandidate(it);
        }
    }
}

