/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.TypeScriptInterfaceStub;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptInterfaceImpl
extends TypeScriptClassBase<TypeScriptInterfaceStub>
implements TypeScriptInterface {
    private static final String CALL_SIGNATURE_NAME_HOLDER = "CALL^SIGNATURE";
    private volatile String myName;

    public TypeScriptInterfaceImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptInterfaceImpl(TypeScriptInterfaceStub stub) {
        super(stub, JSStubElementTypes.TYPESCRIPT_INTERFACE);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(0);
        }
        this.myName = null;
        return super.setName(newName);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptInterface(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getName() {
        TypeScriptInterfaceStub stub = (TypeScriptInterfaceStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = this.myName;
        if (name != null) {
            return name;
        }
        this.myName = name = super.getName();
        return name;
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public TypeScriptObjectType getBody() {
        return (TypeScriptObjectType)this.getStubOrPsiChild(TypeScriptStubElementTypes.OBJECT_TYPE);
    }

    @Override
    public boolean isInterface() {
        return true;
    }

    @Override
    public JSClass @NotNull [] getSupers() {
        JSClass[] jSClassArray = this.getSuperClasses();
        if (jSClassArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(2);
        }
        return jSClassArray;
    }

    @Override
    public JSFunction @NotNull [] getFunctions() {
        TypeScriptObjectType body = this.getBody();
        if (body == null) {
            if (JSFunction.EMPTY_ARRAY == null) {
                TypeScriptInterfaceImpl.$$$reportNull$$$0(3);
            }
            return JSFunction.EMPTY_ARRAY;
        }
        JSFunction[] jSFunctionArray = (JSFunction[])Arrays.stream(body.getTypeMembers()).filter(el -> el instanceof JSFunction).toArray(JSFunction[]::new);
        if (jSFunctionArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(4);
        }
        return jSFunctionArray;
    }

    @Override
    public JSField @NotNull [] getFields() {
        TypeScriptObjectType body = this.getBody();
        if (body == null) {
            if (JSField.EMPTY_ARRAY == null) {
                TypeScriptInterfaceImpl.$$$reportNull$$$0(5);
            }
            return JSField.EMPTY_ARRAY;
        }
        JSField[] jSFieldArray = (JSField[])Arrays.stream(body.getTypeMembers()).filter(el -> el instanceof JSField).toArray(JSField[]::new);
        if (jSFieldArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(6);
        }
        return jSFieldArray;
    }

    @Override
    protected TypeScriptIndexSignature @NotNull [] getIndexSignatures() {
        if (this.getBody() == null) {
            if (TypeScriptIndexSignature.EMPTY_ARRAY == null) {
                TypeScriptInterfaceImpl.$$$reportNull$$$0(7);
            }
            return TypeScriptIndexSignature.EMPTY_ARRAY;
        }
        TypeScriptIndexSignature[] typeScriptIndexSignatureArray = this.getBody().getIndexSignatures();
        if (typeScriptIndexSignatureArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(8);
        }
        return typeScriptIndexSignatureArray;
    }

    @Override
    @Nullable
    public JSFunction findFunctionByNameAndKind(@Nullable String name, JSFunction.FunctionKind kind) {
        if (kind != JSFunction.FunctionKind.SIMPLE) {
            return null;
        }
        return super.findFunctionByNameAndKind(name, kind);
    }

    @Override
    public TypeScriptFunction @NotNull [] findFunctionsByNameAndKind(String name, JSFunction.FunctionKind kind) {
        if (kind != JSFunction.FunctionKind.SIMPLE) {
            if (TypeScriptFunction.EMPTY == null) {
                TypeScriptInterfaceImpl.$$$reportNull$$$0(9);
            }
            return TypeScriptFunction.EMPTY;
        }
        TypeScriptFunction[] typeScriptFunctionArray = super.findFunctionsByNameAndKind(name, kind);
        if (typeScriptFunctionArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(10);
        }
        return typeScriptFunctionArray;
    }

    @Override
    @Nullable
    public JSFunction getConstructor() {
        return null;
    }

    @Override
    @NotNull
    public Iterable<? extends JSElement> getMembers() {
        TypeScriptObjectType body = this.getBody();
        List<Object> list = body != null ? Arrays.asList(body.getTypeMembers()) : Collections.emptyList();
        if (list == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.INTERFACE;
        if (classOrInterface == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(12);
        }
        return classOrInterface;
    }

    @Override
    public boolean hasCallSignature() {
        return this.findFunctionByName(CALL_SIGNATURE_NAME_HOLDER) != null;
    }

    @Override
    protected String getMethodName(@NotNull JSFunction function) {
        if (function == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(13);
        }
        if (function instanceof TypeScriptCallSignature) {
            return CALL_SIGNATURE_NAME_HOLDER;
        }
        return super.getMethodName(function);
    }

    @Override
    protected void clearCachesSync() {
        super.clearCachesSync();
        this.myName = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexSignatures";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunctionsByNameAndKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMethodName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

