/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyBase;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDestructuringPropertyReference
extends PsiPolyVariantReferenceBase<JSDestructuringProperty> {
    public JSDestructuringPropertyReference(@NotNull JSDestructuringProperty property) {
        if (property == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(0);
        }
        super((PsiElement)property, true);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(((JSDestructuringProperty)this.getElement()).getContainingFile(), this, (reference, incompleteCode1) -> JSDestructuringPropertyReference.doResolve(reference), incompleteCode);
        if (resolveResultArray == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    private static ResolveResult @NotNull [] doResolve(@NotNull JSDestructuringPropertyReference reference) {
        JSDestructuringProperty property;
        if (reference == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(2);
        }
        if ((property = (JSDestructuringProperty)reference.getElement()).getDestructuringElement() == null || property.getName() == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSDestructuringPropertyReference.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        QualifiedItemProcessor<ResolveResultSink> qualifiedItemProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)property).createQualifiedItemProcessor(new ResolveResultSink((PsiElement)property, property.getName()), (PsiElement)property);
        PsiFile containingFile = property.getContainingFile();
        qualifiedItemProcessor.evaluateExpressionOrElementType(property.getParent(), containingFile);
        ResolveResult[] resolveResults = qualifiedItemProcessor.getResultsAsResolveResults();
        if (resolveResults.length > 0) {
            ResolveResult[] resolveResultArray = (ResolveResult[])JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)property, () -> JSResolveResult.transformElements(resolveResults, el -> {
                TypeScriptProxyImplicitElement implicitEl;
                return el instanceof TypeScriptProxyImplicitElement && JSDestructuringPropertyReference.canReplaceImplicitElementWithExplicit(implicitEl = (TypeScriptProxyImplicitElement)el) ? implicitEl.getExplicitElement() : el;
            }));
            if (resolveResultArray == null) {
                JSDestructuringPropertyReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(reference.getCanonicalText(), containingFile, (PsiElement)property);
        processor.forceSetAddOnlyCompleteMatches();
        JSIndexBasedResolveUtil.processAllSymbols(processor);
        ResolveResult[] resolveResultArray = processor.getResults();
        if (resolveResultArray == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    private static boolean canReplaceImplicitElementWithExplicit(TypeScriptProxyImplicitElement implicitElement) {
        JSType implicitType = implicitElement.getJSType();
        if (implicitType == null) {
            return true;
        }
        PsiElement explicitElement = implicitElement.getExplicitElement();
        if (!(explicitElement instanceof JSTypeOwner)) {
            return true;
        }
        JSTypeOwner explicitTypedElement = (JSTypeOwner)explicitElement;
        @Nullable JSType explicitType = explicitTypedElement.getJSType();
        Pair<JSType, JSType> normalizedTypes = JSDestructuringPropertyReference.normalizeTypeScriptCompilerTypes(implicitType, explicitType);
        return ((JSType)normalizedTypes.first).isEquivalentTo((JSType)normalizedTypes.second, new ProcessingContext());
    }

    private static Pair<JSType, JSType> normalizeTypeScriptCompilerTypes(@Nullable JSType implicitType, @Nullable JSType explicitType) {
        JSType explicitSubstituted;
        if (implicitType == null || explicitType == null) {
            return Pair.create((Object)implicitType, (Object)explicitType);
        }
        boolean implicitIsTsc = implicitType instanceof TypeScriptCompilerType;
        boolean explicitIsTsc = explicitType instanceof TypeScriptCompilerType;
        JSType implicitSubstituted = implicitIsTsc ? implicitType.substitute() : implicitType;
        JSType jSType = explicitSubstituted = explicitIsTsc ? explicitType.substitute() : explicitType;
        if ((implicitIsTsc || explicitIsTsc) && implicitSubstituted.getSourceElement() == null != (explicitSubstituted.getSourceElement() == null)) {
            return Pair.create((Object)implicitSubstituted.withNewSource(JSTypeSource.EMPTY), (Object)explicitSubstituted.withNewSource(JSTypeSource.EMPTY));
        }
        return Pair.create((Object)implicitSubstituted, (Object)explicitSubstituted);
    }

    protected TextRange calculateDefaultRangeInElement() {
        JSDestructuringProperty element = (JSDestructuringProperty)this.getElement();
        if (element instanceof JSDestructuringPropertyBase) {
            PsiElement identifier = ((JSDestructuringPropertyBase)element).getNameIdentifierForPropertyOrNestedElement();
            if (identifier == null) {
                return ((JSDestructuringProperty)this.getElement()).getTextRange();
            }
            int startOffsetInParent = identifier.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + identifier.getTextLength());
        }
        return new TextRange(0, element.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String string = StringUtil.notNullize((String)((JSDestructuringProperty)this.myElement).getName());
        if (string == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiFile) {
            return false;
        }
        return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, this.getCanonicalText(), element);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(8);
        }
        JSDestructuringProperty element = (JSDestructuringProperty)this.getElement();
        element.setName(newElementName);
        return element;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSDestructuringPropertyReference.$$$reportNull$$$0(9);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

