/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSLocalNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassResolver {
    private static JSClassResolver INSTANCE = null;
    private static final Logger LOG = Logger.getInstance(JSClassResolver.class);

    protected JSClassResolver() {
    }

    public static JSClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSClassResolver();
        }
        return INSTANCE;
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context2) {
        if (qname == null) {
            JSClassResolver.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSClassResolver.$$$reportNull$$$0(1);
        }
        return JSClassResolver.findClassFromNamespace(qname, context2, JSResolveUtil.getResolveScope(context2));
    }

    public static PsiElement findClassFromNamespace(@NotNull String qname, @NotNull PsiElement context2, @NotNull GlobalSearchScope scope2) {
        JSNamedElement localElement;
        DialectOptionHolder dialect;
        if (qname == null) {
            JSClassResolver.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            JSClassResolver.$$$reportNull$$$0(3);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(4);
        }
        if ((dialect = DialectDetector.dialectOfElement(context2)) != null && (dialect.isJavaScript() || dialect.isTypeScript)) {
            return null;
        }
        VirtualFile vFile = context2.getContainingFile().getVirtualFile();
        if (!"Object".equals(qname) && (vFile == null || scope2.contains(vFile)) && (localElement = JSResolveUtil.findFileLocalElement(qname, context2)) != null) {
            return localElement;
        }
        return JSDialectSpecificHandlersFactory.forElement(context2).getClassResolver().findClassByQName(qname, scope2);
    }

    public static long getResolveResultTimestamp(PsiElement candidate) {
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            long result2 = helper.getResolveResultTimestamp(candidate);
            if (result2 == -1L) continue;
            return result2;
        }
        return -1L;
    }

    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context2) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            JSClassResolver.$$$reportNull$$$0(6);
        }
        return this.doFindClassByQName(link, JSResolveUtil.getResolveScope(context2), false);
    }

    @Nullable
    public PsiElement findClassByQName(@NotNull String link, @NotNull GlobalSearchScope scope2) {
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(7);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(8);
        }
        return TypeScriptClassResolver.getInstance().findAnyClassByQName(link, scope2);
    }

    protected PsiElement doFindClassByQName(@NotNull String link, GlobalSearchScope searchScope, boolean allowFileLocalSymbols) {
        Project project;
        if (link == null) {
            JSClassResolver.$$$reportNull$$$0(9);
        }
        if ((project = searchScope.getProject()) == null) {
            throw new IllegalArgumentException("searchScope.getProject() is null");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("doFindClassByQName: " + link);
        }
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)link, (Project)project, (GlobalSearchScope)searchScope, JSQualifiedNamedElement.class);
        for (JSQualifiedNamedElement clazz : candidates) {
            PsiFile file;
            if (!link.equals(clazz.getQualifiedName()) || (file = clazz.getContainingFile()).getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4)) continue;
            return clazz;
        }
        return null;
    }

    @NotNull
    public List<JSClass> findClassesByQName(@NotNull String qName, @NotNull GlobalSearchScope scope2) {
        Project project;
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(10);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(11);
        }
        if ((project = scope2.getProject()) == null) {
            if (scope2 != GlobalSearchScope.EMPTY_SCOPE) {
                Logger.getInstance(JSClassResolver.class).error("Incorrect scope: " + String.valueOf(scope2));
            }
            List<JSClass> list = Collections.emptyList();
            if (list == null) {
                JSClassResolver.$$$reportNull$$$0(12);
            }
            return list;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("findClassesByQName: " + qName);
        }
        Collection candidates = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)qName, (Project)project, (GlobalSearchScope)scope2, JSQualifiedNamedElement.class);
        SmartList classes = new SmartList();
        for (Object _clazz : candidates) {
            JSClass clazz;
            if (!(_clazz instanceof JSClass) || !qName.equals((clazz = (JSClass)_clazz).getQualifiedName())) continue;
            classes.add((Object)clazz);
        }
        SmartList smartList = classes;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(13);
        }
        return smartList;
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findElementsByQName(@NotNull String qName, @NotNull GlobalSearchScope scope2, @NotNull Project project) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(14);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(15);
        }
        if (project == null) {
            JSClassResolver.$$$reportNull$$$0(16);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("findElementsByQName: " + qName);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        scope2 = this.adjustScopeForQualifiedNameSearch(scope2);
        StubIndex.getInstance().processElements(JSQualifiedElementIndex.KEY, (Object)qName, project, scope2, JSQualifiedNamedElement.class, processor);
        Collections.sort(result2, JSResolveUtil.FILE_PATH_COMPARATOR);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    @NotNull
    protected GlobalSearchScope adjustScopeForQualifiedNameSearch(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(18);
        }
        GlobalSearchScope globalSearchScope = scope2;
        if (globalSearchScope == null) {
            JSClassResolver.$$$reportNull$$$0(19);
        }
        return globalSearchScope;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope2) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(20);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(21);
        }
        Collection<JSPsiElementBase> collection = this.findNamespaceMembers(namespace, scope2, null);
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(22);
        }
        return collection;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(23);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(25);
        }
        return JSClassResolver.processNamespaceMembers(namespace, scope2, null, processor);
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembersIncludingLocal(@NotNull String namespace, @NotNull GlobalSearchScope scope2) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(26);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(27);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        JSClassResolver.processNamespaceMembers(namespace, scope2, scope2, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(28);
        }
        return smartList;
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope2, @Nullable GlobalSearchScope scopeToIncludeLocal) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(29);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(30);
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        JSClassResolver.processNamespaceMembers(namespace, scope2, scopeToIncludeLocal, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(31);
        }
        return smartList;
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull PsiFile scope2, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(32);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(34);
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)scope2);
        return JSClassResolver.processNamespaceMembers(namespace, fileScope, fileScope, processor);
    }

    public boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope scope2, @Nullable PsiFile fileToIncludeLocal, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(35);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(36);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(37);
        }
        GlobalSearchScope localNsScope = fileToIncludeLocal != null ? GlobalSearchScope.fileScope((PsiFile)fileToIncludeLocal) : null;
        return JSClassResolver.processNamespaceMembers(namespace, scope2, localNsScope, processor);
    }

    @NotNull
    public Collection<JSPsiElementBase> findNamespaceMembers(@NotNull JSNamespace namespace, @NotNull GlobalSearchScope scope2, @Nullable GlobalSearchScope scopeToIncludeLocal) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(38);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(39);
        }
        String key = (String)ObjectUtils.chooseNotNull((Object)JSStubIndexingUtils.getNamespaceForIndexing(namespace, true), (Object)"");
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        JSClassResolver.processNamespaceMembers(namespace, key, scope2, scopeToIncludeLocal, (Processor<? super JSPsiElementBase>)processor);
        SmartList smartList = result2;
        if (smartList == null) {
            JSClassResolver.$$$reportNull$$$0(40);
        }
        return smartList;
    }

    public static boolean processNamespaceMembers(@NotNull String namespace, @NotNull GlobalSearchScope globalNsScope, @Nullable GlobalSearchScope localNsScope, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(41);
        }
        if (globalNsScope == null) {
            JSClassResolver.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(43);
        }
        JSNamespace jsNamespace = "".equals(namespace) ? null : (JSNamespace)ObjectUtils.tryCast((Object)JSTypeParser.createType(namespace, JSTypeSource.EXPLICITLY_DECLARED), JSNamespace.class);
        return JSClassResolver.processNamespaceMembers(jsNamespace, namespace, globalNsScope, localNsScope, processor);
    }

    private static boolean processNamespaceMembers(@Nullable JSNamespace jsNamespace, @NotNull String namespace, @NotNull GlobalSearchScope globalNsScope, @Nullable GlobalSearchScope localNsScope, @NotNull Processor<? super JSPsiElementBase> processor) {
        Project project;
        if (namespace == null) {
            JSClassResolver.$$$reportNull$$$0(44);
        }
        if (globalNsScope == null) {
            JSClassResolver.$$$reportNull$$$0(45);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(46);
        }
        if ((project = globalNsScope.getProject()) == null) {
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("processNamespaceMembers: " + namespace);
        }
        Processor<JSElement> namespaceMembersProcessor = JSClassResolver.getNamespaceMembersProcessor(processor, jsNamespace);
        if (localNsScope != null && !StubIndex.getInstance().processElements(JSLocalNamespaceMembersIndex.KEY, (Object)namespace, project, localNsScope, JSElement.class, namespaceMembersProcessor)) {
            return false;
        }
        return StubIndex.getInstance().processElements(JSNamespaceMembersIndex.KEY, (Object)namespace, project, globalNsScope, JSElement.class, namespaceMembersProcessor);
    }

    @NotNull
    private static Processor<JSElement> getNamespaceMembersProcessor(@NotNull Processor<? super JSPsiElementBase> processor, @Nullable JSNamespace namespace) {
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(47);
        }
        Processor processor2 = element -> {
            Collection<JSImplicitElement> implicitElements;
            JSElementIndexingData data;
            boolean emptyImplicitElements = true;
            if (element instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)element).getIndexingData()) != null && (implicitElements = data.getImplicitElements()) != null) {
                emptyImplicitElements = false;
                for (JSImplicitElement implicitElement : implicitElements) {
                    if (!(namespace == null ? implicitElement.getNamespace() == null : BaseJSSymbolProcessor.isElementFromNamespaceIgnoringJSContext(namespace, implicitElement, implicitElement.getNamespace(), implicitElement.getJSNamespace())) || processor.process((Object)implicitElement)) continue;
                    return false;
                }
            }
            return !(element instanceof JSPsiElementBase) || !emptyImplicitElements && !ComparatorUtil.equalsNullable((Object)namespace, (Object)((JSPsiElementBase)element).getJSNamespace()) || processor.process((Object)((JSPsiElementBase)element));
        };
        if (processor2 == null) {
            JSClassResolver.$$$reportNull$$$0(48);
        }
        return processor2;
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope2) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(49);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(50);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementsByQNameIncludingImplicit(qName, scope2, (Processor<? super JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(51);
        }
        return collection;
    }

    @NotNull
    public List<JSPsiElementBase> findElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull PsiFile scope2) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(52);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(53);
        }
        ArrayList<JSPsiElementBase> result2 = new ArrayList<JSPsiElementBase>();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(result2);
        this.processElementsByQNameIncludingImplicit(qName, GlobalSearchScope.fileScope((PsiFile)scope2), IncludeLocalMembersOptions.ALL, (Processor<? super JSPsiElementBase>)processor);
        ArrayList<JSPsiElementBase> arrayList = result2;
        if (arrayList == null) {
            JSClassResolver.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(55);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(56);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(57);
        }
        this.processElementsByQNameIncludingImplicit(qName, scope2, IncludeLocalMembersOptions.NONE, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processElementsByQNameIncludingImplicit(@NotNull String qName, @NotNull GlobalSearchScope scope2, @NotNull IncludeLocalMembersOptions includeLocalMembers, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(58);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(59);
        }
        if (includeLocalMembers == null) {
            JSClassResolver.$$$reportNull$$$0(60);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(61);
        }
        Project project = scope2.getProject();
        assert (project != null);
        JSEvaluationLogger.getInstance().startTask(() -> "processElementsByQNameIncludingImplicit: " + qName);
        try {
            GlobalSearchScope scopeForSymbolQualifiedNamesIndex;
            Processor<JSElement> processorForQNameIncludingImplicit = JSClassResolver.getProcessorForQNameIncludingImplicit(qName, includeLocalMembers, processor);
            GlobalSearchScope scopeForGlobalSymbolIndex = includeLocalMembers.getScopeForGlobalSymbolIndex(qName, scope2);
            if (scopeForGlobalSymbolIndex != null) {
                StubIndex.getInstance().processElements(JSGlobalSymbolIndex.KEY, (Object)qName, project, scopeForGlobalSymbolIndex, JSElement.class, processorForQNameIncludingImplicit);
            }
            if ((scopeForSymbolQualifiedNamesIndex = includeLocalMembers.getScopeForSymbolQualifiedNamesIndex(qName, scope2)) != null) {
                StubIndex.getInstance().processElements(JSSymbolQualifiedNamesIndex.KEY, (Object)qName, project, scopeForSymbolQualifiedNamesIndex, JSElement.class, processorForQNameIncludingImplicit);
            }
        }
        finally {
            JSEvaluationLogger.getInstance().finishTask(null);
        }
    }

    @NotNull
    private static Processor<JSElement> getProcessorForQNameIncludingImplicit(@NotNull String qName, @NotNull IncludeLocalMembersOptions includeLocalMembers, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (qName == null) {
            JSClassResolver.$$$reportNull$$$0(62);
        }
        if (includeLocalMembers == null) {
            JSClassResolver.$$$reportNull$$$0(63);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(64);
        }
        Processor processor2 = element -> {
            if (element instanceof JSPsiElementBase) {
                PsiFile file = element.getContainingFile();
                String processedElementQName = includeLocalMembers.myIncludeLocalAll || file != null && file.equals(includeLocalMembers.myIncludeLocalInFile) ? JSSymbolQualifiedNamesIndex.getQualifiedNameToIndex((JSElementBase)((Object)element)) : ((JSPsiElementBase)element).getQualifiedName();
                if (qName.equals(processedElementQName) && !processor.process((Object)((JSPsiElementBase)element))) {
                    return false;
                }
            }
            if (element instanceof JSImplicitElementProvider) {
                Collection<JSImplicitElement> implicitElements;
                JSElementIndexingData indexingData = ((JSImplicitElementProvider)element).getIndexingData();
                List<JSImplicitElement> elements = indexingData != null ? indexingData.findElementsByQualifiedName(qName) : Collections.emptyList();
                for (JSImplicitElement implicitElement : elements) {
                    if (processor.process((Object)implicitElement)) continue;
                    return false;
                }
                if (elements.isEmpty() && indexingData != null && (implicitElements = indexingData.getImplicitElements()) != null) {
                    for (JSImplicitElement implicitElement : implicitElements) {
                        String elementName = implicitElement.getName();
                        if (elementName == null || !qName.equals(JSSymbolQualifiedNamesIndex.getQualifiedNameToIndex(implicitElement)) || processor.process((Object)implicitElement)) continue;
                        return false;
                    }
                }
            }
            return true;
        };
        if (processor2 == null) {
            JSClassResolver.$$$reportNull$$$0(65);
        }
        return processor2;
    }

    @NotNull
    public Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope2) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(66);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(67);
        }
        return JSClassResolver.findElementsByNameIncludingImplicit(name, scope2, false);
    }

    @NotNull
    public static Collection<JSPsiElementBase> findElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope2, boolean justClasses) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(68);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(69);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassResolver.processElementsByNameIncludingImplicit(name, scope2, justClasses, (Processor<? super JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSClassResolver.$$$reportNull$$$0(70);
        }
        return collection;
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope2, boolean justClasses, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(71);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(72);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(73);
        }
        return JSClassResolver.processElementsByNameIncludingImplicit(name, scope2, justClasses, JSSymbolIndex2.KEY, processor);
    }

    public static boolean processElementsByNameIncludingImplicit(@NotNull String name, @NotNull GlobalSearchScope scope2, boolean justClasses, @NotNull StubIndexKey<? super String, JSElement> indexKey, @NotNull Processor<? super JSPsiElementBase> processor) {
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(74);
        }
        if (scope2 == null) {
            JSClassResolver.$$$reportNull$$$0(75);
        }
        if (indexKey == null) {
            JSClassResolver.$$$reportNull$$$0(76);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(77);
        }
        Project project = scope2.getProject();
        assert (project != null);
        if (LOG.isTraceEnabled()) {
            LOG.trace("processElementsByNameIncludingImplicit: " + name);
        }
        return StubIndex.getInstance().processElements(indexKey, (Object)name, project, scope2, JSElement.class, element -> {
            ProgressManager.checkCanceled();
            if (justClasses && !(element instanceof JSClass)) {
                return true;
            }
            return !(element instanceof JSPsiElementBase && name.equals(element.getName()) ? !processor.process((Object)((JSPsiElementBase)element)) : element instanceof JSImplicitElementProvider && !JSClassResolver.processImplicitElements(name, (Processor<? super JSImplicitElement>)processor, (JSImplicitElementProvider)element));
        });
    }

    public static boolean processImplicitElements(@NotNull String name, @NotNull Processor<? super JSImplicitElement> processor, @NotNull JSImplicitElementProvider element) {
        JSElementIndexingData data;
        Collection<JSImplicitElement> implicitElements;
        if (name == null) {
            JSClassResolver.$$$reportNull$$$0(78);
        }
        if (processor == null) {
            JSClassResolver.$$$reportNull$$$0(79);
        }
        if (element == null) {
            JSClassResolver.$$$reportNull$$$0(80);
        }
        Collection<JSImplicitElement> collection = implicitElements = (data = element.getIndexingData()) != null ? data.getImplicitElements() : null;
        if (implicitElements != null) {
            for (JSImplicitElement implicitElement : implicitElements) {
                if (!name.equals(implicitElement.getName()) || processor.process((Object)implicitElement)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 17, 19, 22, 28, 31, 40, 48, 51, 54, 65, 70 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qname";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 67: 
            case 69: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 10: 
            case 14: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 31: 
            case 40: 
            case 48: 
            case 51: 
            case 54: 
            case 65: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 25: 
            case 34: 
            case 37: 
            case 43: 
            case 46: 
            case 47: 
            case 57: 
            case 61: 
            case 64: 
            case 73: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalNsScope";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeLocalMembers";
                break;
            }
            case 66: 
            case 68: 
            case 71: 
            case 74: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesByQName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustScopeForQualifiedNameSearch";
                break;
            }
            case 22: 
            case 31: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceMembers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamespaceMembersIncludingLocal";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceMembersProcessor";
                break;
            }
            case 51: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessorForQNameIncludingImplicit";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByNameIncludingImplicit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassFromNamespace";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassByQName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassByQName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByQName";
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 31: 
            case 40: 
            case 48: 
            case 51: 
            case 54: 
            case 65: 
            case 70: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "adjustScopeForQualifiedNameSearch";
                break;
            }
            case 20: 
            case 21: 
            case 29: 
            case 30: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceMembers";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceMembers";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaceMembersIncludingLocal";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceMembersProcessor";
                break;
            }
            case 49: 
            case 50: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQNameIncludingImplicit";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByQNameIncludingImplicit";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getProcessorForQNameIncludingImplicit";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByNameIncludingImplicit";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "processElementsByNameIncludingImplicit";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 17, 19, 22, 28, 31, 40, 48, 51, 54, 65, 70 -> new IllegalStateException(string);
        };
    }

    public static final class IncludeLocalMembersOptions {
        public static final IncludeLocalMembersOptions ALL = new IncludeLocalMembersOptions(true, null);
        public static final IncludeLocalMembersOptions NONE = new IncludeLocalMembersOptions(false, null);
        private final boolean myIncludeLocalAll;
        @Nullable
        private final PsiFile myIncludeLocalInFile;

        private IncludeLocalMembersOptions(boolean includeLocalAll, @Nullable PsiFile includeLocalInFile) {
            this.myIncludeLocalAll = includeLocalAll;
            this.myIncludeLocalInFile = includeLocalInFile;
        }

        @NotNull
        public static IncludeLocalMembersOptions inFile(@Nullable PsiFile includeInFile) {
            IncludeLocalMembersOptions includeLocalMembersOptions = includeInFile != null ? new IncludeLocalMembersOptions(false, includeInFile) : NONE;
            if (includeLocalMembersOptions == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(0);
            }
            return includeLocalMembersOptions;
        }

        @Nullable
        public GlobalSearchScope getScopeForGlobalSymbolIndex(@NotNull String qName, @NotNull GlobalSearchScope scope2) {
            if (qName == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(1);
            }
            if (scope2 == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(2);
            }
            if (qName.contains(".")) {
                return null;
            }
            if (this.myIncludeLocalAll) {
                return null;
            }
            if (this.myIncludeLocalInFile != null) {
                return scope2.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.fileScope((PsiFile)this.myIncludeLocalInFile)));
            }
            return scope2;
        }

        @Nullable
        public GlobalSearchScope getScopeForSymbolQualifiedNamesIndex(@NotNull String qName, @NotNull GlobalSearchScope scope2) {
            if (qName == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(3);
            }
            if (scope2 == null) {
                IncludeLocalMembersOptions.$$$reportNull$$$0(4);
            }
            if (qName.contains(".")) {
                return scope2;
            }
            if (this.myIncludeLocalAll) {
                return scope2;
            }
            if (this.myIncludeLocalInFile != null) {
                return GlobalSearchScope.fileScope((PsiFile)this.myIncludeLocalInFile).intersectWith(scope2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver$IncludeLocalMembersOptions";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qName";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSClassResolver$IncludeLocalMembersOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getScopeForGlobalSymbolIndex";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getScopeForSymbolQualifiedNamesIndex";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

