/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.icons.AllIcons;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSVisibilityUtil {
    public static final JSAttributeList.AccessType[] ACCESS_TYPES = new JSAttributeList.AccessType[]{JSAttributeList.AccessType.PUBLIC, JSAttributeList.AccessType.PROTECTED, JSAttributeList.AccessType.PACKAGE_LOCAL, JSAttributeList.AccessType.PRIVATE};
    public static final String ESCALATE_VISIBILITY = "escalate";
    public static final Options DEFAULT_OPTIONS = new Options();

    public static boolean seemsToBePrivateSymbol(@Nullable String name) {
        return name != null && !name.isEmpty() && (name.charAt(0) == '_' || name.charAt(name.length() - 1) == '_');
    }

    @NotNull
    public static Icon getAccessModifierIcon(@NotNull JSElement element) {
        PresentableAccessModifier accessModifier;
        if (element == null) {
            JSVisibilityUtil.$$$reportNull$$$0(0);
        }
        if ((accessModifier = JSVisibilityUtil.getPresentableAccessModifier(element)) == null) {
            accessModifier = PresentableAccessModifier.INTERNAL;
        }
        Icon icon = accessModifier.getIcon();
        if (icon == null) {
            JSVisibilityUtil.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @Nullable
    public static PresentableAccessModifier getPresentableAccessModifier(@NotNull JSElement element) {
        JSAttributeList.AccessType accessType;
        JSAttributeList attributeList;
        if (element == null) {
            JSVisibilityUtil.$$$reportNull$$$0(2);
        }
        JSAttributeList jSAttributeList = attributeList = element instanceof JSAttributeListOwner ? ((JSAttributeListOwner)element).getAttributeList() : null;
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
            return PresentableAccessModifier.EXPORT;
        }
        if (element instanceof JSPsiElementBase) {
            accessType = ((JSPsiElementBase)element).getAccessType();
        } else if (attributeList != null) {
            accessType = attributeList.getAccessType();
        } else {
            return null;
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
        if (parent instanceof JSPackageStatement || parent instanceof JSClass || attributeList != null && attributeList.getExplicitAccessType() == accessType) {
            return PresentableAccessModifier.ofAccessType(accessType, (PsiElement)element);
        }
        return null;
    }

    public static JSAttributeList.AccessType getEscalatedVisibility(JSAttributeListOwner subject, PsiElement from, @NotNull JSAttributeList.AccessType currentVisibility, @NotNull Options options) {
        if (currentVisibility == null) {
            JSVisibilityUtil.$$$reportNull$$$0(3);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(4);
        }
        if (currentVisibility == JSAttributeList.AccessType.PUBLIC || JSVisibilityUtil.isAccessible((PsiElement)subject, currentVisibility, null, from, options)) {
            return currentVisibility;
        }
        if (DialectDetector.isJavaScriptFamily((PsiElement)subject)) {
            if (DialectDetector.isTypeScript((PsiElement)subject) && JSVisibilityUtil.isInInheritor(subject, from)) {
                return JSAttributeList.AccessType.PROTECTED;
            }
            return JSAttributeList.AccessType.PUBLIC;
        }
        JSAttributeList.AccessType escalated = JSAttributeList.AccessType.PUBLIC;
        if (currentVisibility == JSAttributeList.AccessType.PRIVATE) {
            escalated = JSVisibilityUtil.isInInheritor(subject, from) ? JSAttributeList.AccessType.PROTECTED : JSAttributeList.AccessType.PACKAGE_LOCAL;
        } else if (currentVisibility == JSAttributeList.AccessType.PROTECTED) {
            escalated = JSAttributeList.AccessType.PACKAGE_LOCAL;
        }
        return JSVisibilityUtil.getEscalatedVisibility(subject, from, escalated, options);
    }

    private static boolean isInInheritor(JSAttributeListOwner subject, PsiElement from) {
        JSClass subjectClass = JSResolveUtil.getClassOfContext((PsiElement)subject);
        JSClass fromClass = JSResolveUtil.getClassOfContext(from);
        return fromClass != null && subjectClass != null && JSInheritanceUtil.isParentClass(fromClass, subjectClass);
    }

    @NotNull
    public static String getVisibilityKeyword(@NotNull JSAttributeList.AccessType visibility) {
        if (visibility == null) {
            JSVisibilityUtil.$$$reportNull$$$0(5);
        }
        if (visibility == JSAttributeList.AccessType.PUBLIC) {
            return "public";
        }
        if (visibility == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            return "internal";
        }
        if (visibility == JSAttributeList.AccessType.PRIVATE) {
            return "private";
        }
        if (visibility == JSAttributeList.AccessType.PROTECTED) {
            return "protected";
        }
        throw new IncorrectOperationException("Unknown visibility" + String.valueOf((Object)visibility));
    }

    @NotNull
    public static JSAttributeList.AccessType getAccessType(@NotNull String visibility) {
        if (visibility == null) {
            JSVisibilityUtil.$$$reportNull$$$0(6);
        }
        JSAttributeList.AccessType accessType = switch (visibility) {
            case "public" -> JSAttributeList.AccessType.PUBLIC;
            case "internal" -> JSAttributeList.AccessType.PACKAGE_LOCAL;
            case "private" -> JSAttributeList.AccessType.PRIVATE;
            case "protected" -> JSAttributeList.AccessType.PROTECTED;
            default -> throw new IncorrectOperationException("Unknown visibility" + visibility);
        };
        if (accessType == null) {
            JSVisibilityUtil.$$$reportNull$$$0(7);
        }
        return accessType;
    }

    @Nullable
    public static String getJSDocVisibilityKeyword(JSAttributeList.AccessType visibility) {
        return switch (visibility) {
            case JSAttributeList.AccessType.PUBLIC -> "public";
            case JSAttributeList.AccessType.PROTECTED -> "protected";
            case JSAttributeList.AccessType.PRIVATE -> "private";
            default -> null;
        };
    }

    public static boolean isAccessible(@NotNull PsiElement subject, @Nullable JSAttributeList subjectAttributeList, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        String namespace;
        if (subject == null) {
            JSVisibilityUtil.$$$reportNull$$$0(8);
        }
        if (from == null) {
            JSVisibilityUtil.$$$reportNull$$$0(9);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(10);
        }
        if (subjectAttributeList == null) {
            JSAttributeList jSAttributeList = subjectAttributeList = subject instanceof JSAttributeListOwner ? ((JSAttributeListOwner)subject).getAttributeList() : null;
            if (subjectAttributeList == null) {
                return true;
            }
        }
        if ((namespace = ActionScriptPsiImplUtil.getNamespaceValue(subjectAttributeList)) != null) {
            return JSVisibilityUtil.isAccessible(subject, namespace, subjectClass, from, options);
        }
        return JSVisibilityUtil.isAccessible(subject, subjectAttributeList.getAccessType(), subjectClass, from, options);
    }

    public static boolean isAccessible(@NotNull PsiElement subject, @NotNull JSAttributeList.AccessType accessType, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        if (subject == null) {
            JSVisibilityUtil.$$$reportNull$$$0(11);
        }
        if (accessType == null) {
            JSVisibilityUtil.$$$reportNull$$$0(12);
        }
        if (from == null) {
            JSVisibilityUtil.$$$reportNull$$$0(13);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(14);
        }
        return JSVisibilityUtil.isAccessibleImpl(subject, (Object)accessType, subjectClass, from, options);
    }

    public static boolean isAccessible(@NotNull PsiElement subject, @NotNull String namespace, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        if (subject == null) {
            JSVisibilityUtil.$$$reportNull$$$0(15);
        }
        if (namespace == null) {
            JSVisibilityUtil.$$$reportNull$$$0(16);
        }
        if (from == null) {
            JSVisibilityUtil.$$$reportNull$$$0(17);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(18);
        }
        return JSVisibilityUtil.isAccessibleImpl(subject, namespace, subjectClass, from, options);
    }

    private static boolean isAccessibleImpl(@NotNull PsiElement subject, @NotNull Object accessTypeOrNamespace, @Nullable JSClass subjectClass, @NotNull PsiElement from, @NotNull Options options) {
        if (subject == null) {
            JSVisibilityUtil.$$$reportNull$$$0(19);
        }
        if (accessTypeOrNamespace == null) {
            JSVisibilityUtil.$$$reportNull$$$0(20);
        }
        if (from == null) {
            JSVisibilityUtil.$$$reportNull$$$0(21);
        }
        if (options == null) {
            JSVisibilityUtil.$$$reportNull$$$0(22);
        }
        if (ActionScriptResolveUtil.isFileLocalSymbol(subject) && (JSVisibilityUtil.getForcedPackage(subject, options) != null || JSVisibilityUtil.getForcedPackage(from, options) != null || subject.getContainingFile() != from.getContainingFile())) {
            return false;
        }
        if (subject instanceof JSQualifiedNamedElement && JSUtils.getMemberContainingClass(subject) == null && DialectDetector.isActionScript(subject)) {
            PsiFile containingFile;
            if (from.getParent() instanceof JSReferenceListMember && (containingFile = from.getContainingFile()) instanceof JSFile && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)containingFile)) {
                return accessTypeOrNamespace == JSAttributeList.AccessType.PUBLIC;
            }
            return accessTypeOrNamespace == JSAttributeList.AccessType.PUBLIC || accessTypeOrNamespace == JSAttributeList.AccessType.PACKAGE_LOCAL && JSVisibilityUtil.areInTheSamePackage(subject, from, options) || accessTypeOrNamespace instanceof String;
        }
        if (subjectClass == null) {
            subjectClass = JSUtils.getMemberContainingClass(subject);
        }
        if (subjectClass == null) {
            return true;
        }
        if (!JSVisibilityUtil.isAccessible((PsiElement)subjectClass, (JSAttributeList)null, null, from, options)) {
            return false;
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PUBLIC) {
            return true;
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            return JSVisibilityUtil.areInTheSamePackage(subjectClass, from, options);
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PROTECTED) {
            JSClass fromClass = from instanceof JSClass ? (JSClass)from : JSResolveUtil.getClassOfContext(from);
            return fromClass != null && (subjectClass.isEquivalentTo(fromClass) || !options.ignoreClassInheritance && JSInheritanceUtil.isParentClass(fromClass, subjectClass));
        }
        if (accessTypeOrNamespace == JSAttributeList.AccessType.PRIVATE) {
            return PsiTreeUtil.isAncestor((PsiElement)subjectClass, (PsiElement)from, (boolean)false);
        }
        assert (accessTypeOrNamespace instanceof String);
        return true;
    }

    private static boolean areInTheSamePackage(PsiElement element1, PsiElement element2, Options options) {
        String package2;
        String package1 = JSVisibilityUtil.getPackageName(element1, options);
        return !JSPsiImplUtils.differentPackageName(package1, package2 = JSVisibilityUtil.getPackageName(element2, options));
    }

    private static String getPackageName(PsiElement element, Options options) {
        String packageName = JSVisibilityUtil.getForcedPackage(element, options);
        if (packageName != null) {
            return packageName;
        }
        return element instanceof JSClass ? StringUtil.getPackageName((String)((JSClass)element).getQualifiedName()) : JSResolveUtil.getPackageNameFromPlace(element);
    }

    private static String getForcedPackage(PsiElement element, Options options) {
        String packageName = options.overridePackage.get(element);
        if (packageName == null) {
            packageName = options.overridePackage.get(element.getContainingFile());
        }
        return packageName;
    }

    @NotNull
    public static String accessTypeToKeyword(@NotNull JSAttributeList.AccessType type2, @Nullable DialectOptionHolder holder) {
        if (type2 == null) {
            JSVisibilityUtil.$$$reportNull$$$0(23);
        }
        String s = type2 == JSAttributeList.AccessType.PACKAGE_LOCAL ? (holder != null && holder.isTypeScript ? "" : "internal") : StringUtil.toLowerCase((String)type2.toString());
        String string = s;
        if (string == null) {
            JSVisibilityUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static boolean isAccessible(@NotNull JSPsiElementBase accessedElement, JSAttributeList.AccessType accessedElementVisibility, boolean isSameNamespace, boolean withinScope, boolean fromTheSameFile) {
        if (accessedElement == null) {
            JSVisibilityUtil.$$$reportNull$$$0(25);
        }
        return switch (accessedElementVisibility) {
            case JSAttributeList.AccessType.PRIVATE -> {
                if (fromTheSameFile && JSSymbolUtil.isDefinitelyConstructor((PsiElement)accessedElement) || isSameNamespace && withinScope) {
                    yield true;
                }
                yield false;
            }
            case JSAttributeList.AccessType.PROTECTED -> {
                if (fromTheSameFile || withinScope) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    @NotNull
    public static List<JSQualifiedName> calculateContextNames(PsiElement context2) {
        if (context2 == null) {
            List<JSQualifiedName> list = Collections.emptyList();
            if (list == null) {
                JSVisibilityUtil.$$$reportNull$$$0(26);
            }
            return list;
        }
        ArrayList<String> frameworkContextNames = new ArrayList<String>();
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            handler.addContextNames(context2, frameworkContextNames);
        }
        List contextNames = frameworkContextNames.stream().map(JSQualifiedNameImpl::fromQualifiedName).collect(Collectors.toCollection(ArrayList::new));
        while (context2 != null) {
            JSQualifiedName qName;
            JSNamespace ns = JSContextResolver.resolveContext(context2);
            JSQualifiedName jSQualifiedName = qName = ns != null ? ns.getQualifiedName() : null;
            if (qName != null) {
                contextNames.add(qName);
            }
            context2 = PsiTreeUtil.getParentOfType((PsiElement)context2, JSFunction.class);
        }
        List list = contextNames;
        if (list == null) {
            JSVisibilityUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public static JSAttributeList.AccessType getEscalatedJSDocVisibility(@NotNull JSQualifiedNamedElement resolveResult, PsiElement context2) {
        boolean fromTheSameFile;
        if (resolveResult == null) {
            JSVisibilityUtil.$$$reportNull$$$0(28);
        }
        JSAttributeList.AccessType accessType = resolveResult.getAccessType();
        boolean bl = fromTheSameFile = context2 != null && resolveResult.getContainingFile().isEquivalentTo((PsiElement)context2.getContainingFile());
        if (accessType == JSAttributeList.AccessType.PRIVATE && context2 != null && JSVisibilityUtil.isProtectedAccessible(resolveResult, JSVisibilityUtil.calculateContextNames(context2), context2, fromTheSameFile)) {
            JSAttributeList.AccessType accessType2 = JSAttributeList.AccessType.PROTECTED;
            if (accessType2 == null) {
                JSVisibilityUtil.$$$reportNull$$$0(29);
            }
            return accessType2;
        }
        JSAttributeList.AccessType accessType3 = JSAttributeList.AccessType.PUBLIC;
        if (accessType3 == null) {
            JSVisibilityUtil.$$$reportNull$$$0(30);
        }
        return accessType3;
    }

    private static boolean isProtectedAccessible(@NotNull JSPsiElementBase accessedElement, @NotNull List<JSQualifiedName> qualifiedReferenceContexts, @NotNull PsiElement referenceScope, boolean fromTheSameFile) {
        JSQualifiedName accessedElementNamespace;
        boolean isSameNamespace;
        if (accessedElement == null) {
            JSVisibilityUtil.$$$reportNull$$$0(31);
        }
        if (qualifiedReferenceContexts == null) {
            JSVisibilityUtil.$$$reportNull$$$0(32);
        }
        if (referenceScope == null) {
            JSVisibilityUtil.$$$reportNull$$$0(33);
        }
        if (JSVisibilityUtil.isAccessible(accessedElement, JSAttributeList.AccessType.PROTECTED, isSameNamespace = qualifiedReferenceContexts.contains(accessedElementNamespace = accessedElement.getJSNamespace().getQualifiedName()), false, fromTheSameFile)) {
            return true;
        }
        for (JSQualifiedName contextType : qualifiedReferenceContexts) {
            if (JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(referenceScope, contextType.getQualifiedName(), (Processor<? super JSType>)((Processor)type2 -> {
                String qName = JSTypeUtils.getQualifiedNameMatchingType(type2, false);
                return !StringUtil.equals((CharSequence)JSQualifiedNameImpl.toString(accessedElementNamespace), (CharSequence)qName);
            }))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 24, 26, 27, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 7: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSVisibilityUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVisibility";
                break;
            }
            case 4: 
            case 10: 
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessTypeOrNamespace";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessedElement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedReferenceContexts";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSVisibilityUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessModifierIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "accessTypeToKeyword";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateContextNames";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscalatedJSDocVisibility";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAccessModifierIcon";
                break;
            }
            case 1: 
            case 7: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableAccessModifier";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEscalatedVisibility";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityKeyword";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAccessType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "accessTypeToKeyword";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getEscalatedJSDocVisibility";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isProtectedAccessible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 24, 26, 27, 29, 30 -> new IllegalStateException(string);
        };
    }

    public static enum PresentableAccessModifier {
        PUBLIC("public", IconManager.getInstance().getPlatformIcon(PlatformIcons.Public)),
        PRIVATE("private", IconManager.getInstance().getPlatformIcon(PlatformIcons.Private)),
        PROTECTED("protected", IconManager.getInstance().getPlatformIcon(PlatformIcons.Protected)),
        EXPORT("export", AllIcons.ToolbarDecorator.ExportSmall),
        INTERNAL("internal", IconManager.getInstance().getPlatformIcon(PlatformIcons.Local));

        private final String myText;
        private final Icon myIcon;

        private PresentableAccessModifier(String text, Icon icon) {
            this.myText = text;
            this.myIcon = icon;
        }

        @Nullable
        public static PresentableAccessModifier ofAccessType(@NotNull JSAttributeList.AccessType accessType, @NotNull PsiElement context2) {
            if (accessType == null) {
                PresentableAccessModifier.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                PresentableAccessModifier.$$$reportNull$$$0(1);
            }
            return switch (accessType) {
                default -> throw new IncompatibleClassChangeError();
                case JSAttributeList.AccessType.PUBLIC -> PUBLIC;
                case JSAttributeList.AccessType.PACKAGE_LOCAL -> {
                    if (DialectDetector.isActionScript(context2)) {
                        yield INTERNAL;
                    }
                    yield null;
                }
                case JSAttributeList.AccessType.PROTECTED -> PROTECTED;
                case JSAttributeList.AccessType.PRIVATE -> PRIVATE;
            };
        }

        @NlsSafe
        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                PresentableAccessModifier.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                PresentableAccessModifier.$$$reportNull$$$0(3);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSVisibilityUtil$PresentableAccessModifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSVisibilityUtil$PresentableAccessModifier";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "ofAccessType";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Options {
        private final Map<PsiElement, String> overridePackage = new HashMap<PsiElement, String>();
        public boolean ignoreClassInheritance = false;

        public void overridePackage(PsiElement element, String packageName) {
            this.overridePackage.put((PsiElement)element.getContainingFile(), packageName);
        }
    }
}

