/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSSymbolReferenceCache;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.inline.JSFunctionInliner;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVarOrFieldInliner
extends JSInlineHandler.Inliner {
    @NotNull
    protected final JSVariable myElement;
    private final JSFunction myContainingFunction;
    protected final MySettings mySettings;
    private final boolean myLocalVar;
    private final boolean myDependsOnContext;

    protected JSVarOrFieldInliner(@NotNull JSVariable element, MySettings settings) {
        if (element == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
        this.myElement = element;
        this.mySettings = settings;
        this.myLocalVar = JSVarOrFieldInliner.isLocalVariable(element);
        this.myContainingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
        this.myDependsOnContext = JSBaseIntroduceHandler.calcDependsOnContext((PsiElement)settings.initialized, null, false, false);
    }

    @Override
    protected String getRefactoringId() {
        return "refactoring.javascript.inline";
    }

    @Override
    protected void checkReadAccess(@NotNull MultiMap<PsiElement, String> conflicts, PsiElement referenceElement) {
        if (conflicts == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(1);
        }
        if (this.isDefinition(referenceElement)) {
            return;
        }
        super.checkReadAccess(conflicts, referenceElement);
    }

    private boolean isDefinition(PsiElement referenceElement) {
        JSNamedElement target2 = this.mySettings.getTarget();
        return target2 instanceof JSDefinitionExpression && !JSVarOrFieldInliner.referencesOurDefinition(referenceElement, (JSDefinitionExpression)target2);
    }

    @Override
    public void checkConflicts(@NotNull PsiReference reference, final @NotNull MultiMap<PsiElement, String> conflicts) {
        if (reference == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(2);
        }
        if (conflicts == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(3);
        }
        super.checkConflicts(reference, conflicts);
        final PsiElement expression = reference.getElement();
        if (this.isDefinition(expression)) {
            return;
        }
        JSFunction usageContainingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
        if (this.myLocalVar && this.myDependsOnContext && this.myContainingFunction != usageContainingFunction) {
            final boolean isArrowFunction = usageContainingFunction != null && usageContainingFunction.isArrowFunction();
            JSExpression initializer = this.myElement.getInitializer();
            if (initializer != null) {
                initializer.accept(new JSRecursiveElementVisitor(){
                    final Set<String> processed = new HashSet<String>();

                    @Override
                    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                        PsiElement resolve2;
                        String referenced;
                        if (node == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.visitJSReferenceExpression(node);
                        if (node.getQualifier() == null && (referenced = node.getReferenceName()) != null && this.processed.add(referenced) && conflicts.size() == 0 && (resolve2 = node.resolve()) != null) {
                            JSFunction funScope = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)resolve2, JSFunction.class);
                            Object scope2 = funScope != null ? resolve2.getUseScope() : GlobalSearchScope.fileScope((PsiFile)node.getContainingFile());
                            for (PsiReference ref2 : ReferencesSearch.search((PsiElement)resolve2, (SearchScope)scope2).findAll()) {
                                if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess(ref2.getElement()) == ReadWriteAccessDetector.Access.Read) continue;
                                conflicts.putValue((Object)expression, (Object)JavaScriptBundle.message("javascript.refactoring.variable.value.is.changed.when.accessed.from.closure", new Object[0]));
                            }
                        }
                    }

                    @Override
                    public void visitJSThisExpression(@NotNull JSThisExpression node) {
                        if (node == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        super.visitJSThisExpression(node);
                        if (!isArrowFunction) {
                            conflicts.putValue((Object)expression, (Object)JavaScriptBundle.message("javascript.refactoring.variable.value.is.changed.when.accessed.from.closure", new Object[0]));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "node";
                        objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSVarOrFieldInliner$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSReferenceExpression";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSThisExpression";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
    }

    @Override
    @NotNull
    protected JSInlineHandler.Inliner.JSInlineHandlerResult doInlineUsage(@NotNull JSReferenceExpression usageElement) {
        PsiElement replacement;
        JSNamedElement target2;
        if (usageElement == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(4);
        }
        if ((target2 = this.mySettings.getTarget()) instanceof JSDefinitionExpression && !JSVarOrFieldInliner.referencesOurDefinition((PsiElement)usageElement, (JSDefinitionExpression)target2)) {
            JSInlineHandler.Inliner.JSInlineHandlerResult jSInlineHandlerResult = JSInlineHandler.Inliner.JSInlineHandlerResult.EMPTY;
            if (jSInlineHandlerResult == null) {
                JSVarOrFieldInliner.$$$reportNull$$$0(5);
            }
            return jSInlineHandlerResult;
        }
        JSExpression initializer = this.mySettings.initialized;
        JSExpression qualifier = usageElement.getQualifier();
        HashMap<PsiElement, String> additionalElementsToImport = new HashMap<PsiElement, String>();
        Map<String, PsiNamedElement> elementsInScope = JSFunctionInliner.collectNamesInScope((PsiElement)usageElement);
        String s = JSFunctionInliner.buildReplacement(target2, (PsiElement)initializer, usageElement, Collections.emptyMap(), elementsInScope, qualifier, additionalElementsToImport, false);
        PsiElement parent = usageElement.getParent();
        if (parent instanceof JSProperty && ((JSProperty)parent).isShorthanded()) {
            replacement = parent.replace((PsiElement)ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)parent, s));
        } else {
            JSExpression replacementExpression = (JSExpression)JSInheritedLanguagesHelper.createExpressionFromText(s, (PsiElement)initializer);
            replacement = JSFunctionInliner.performExpressionReplacement(usageElement, replacementExpression);
        }
        return new JSInlineHandler.Inliner.JSInlineHandlerResult(replacement, additionalElementsToImport);
    }

    private static boolean referencesOurDefinition(@NotNull PsiElement usageElement, @NotNull JSDefinitionExpression target2) {
        if (usageElement == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(6);
        }
        if (target2 == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(7);
        }
        return usageElement instanceof JSReferenceExpression && JSVarOrFieldInliner.findDefinition((JSReferenceExpression)usageElement) == target2;
    }

    @Nullable
    private static PsiElement findDefinition(@NotNull JSReferenceExpression usageElement) {
        if (usageElement == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(8);
        }
        PsiElement usageElementParent = usageElement.getParent();
        String referencedName = usageElement.getReferenceName();
        if (usageElementParent instanceof JSNamedElement || referencedName == null) {
            return null;
        }
        SinkResolveProcessor<ResolveResultSink> p = new SinkResolveProcessor<ResolveResultSink>(referencedName, true, new ResolveResultSink(null, referencedName));
        p.setLocalResolve(true);
        JSResolveUtil.treeWalkUp(p, (PsiElement)usageElement, usageElementParent, (PsiElement)usageElement);
        return p.getResult();
    }

    static boolean isLocalVariable(JSVariable jsVariable) {
        return !(jsVariable instanceof JSParameter) && jsVariable.getUseScope() instanceof LocalSearchScope;
    }

    private static boolean hasInitializerInDestructuring(PsiElement elementToInline) {
        JSInitializerOwner parentDeclaration = JSVarOrFieldInliner.findOwner(elementToInline);
        if (parentDeclaration == null) {
            return false;
        }
        for (PsiElement el = elementToInline; el != null && !PsiTreeUtil.isAncestor((PsiElement)el, (PsiElement)parentDeclaration, (boolean)false); el = el.getParent()) {
            if (!(el instanceof JSInitializerOwner) || ((JSInitializerOwner)el).getInitializer() == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static JSInitializerOwner findOwner(PsiElement elementToInline) {
        PsiElement parent = JSDestructuringUtil.getParentSkippingDestructuring((JSElement)elementToInline);
        if (!(parent instanceof JSVarStatement)) {
            return null;
        }
        JSInitializerOwner parentDeclaration = null;
        for (JSInitializerOwner declaration : ((JSVarStatement)parent).getDeclarations()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)elementToInline, (boolean)false)) continue;
            parentDeclaration = declaration;
            break;
        }
        return parentDeclaration;
    }

    @Nullable
    public static MySettings handleVariable(JSVariable element, @Nullable Editor editor, @Nullable PsiReference invocationReference, NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean isInvokedOnReference) {
        JSInitializerOwner owner;
        PsiElement elementParent = element.getParent();
        boolean destructuring = JSDestructuringUtil.isDestructuring(elementParent);
        if (destructuring && (elementParent instanceof JSDestructuringArrayRestElement || elementParent instanceof JSDestructuringProperty && ((JSDestructuringProperty)elementParent).isRest())) {
            JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message("javascript.refactoring.cannot.inline.destructuring.rest.variable", new Object[0]));
            return null;
        }
        if (destructuring && JSVarOrFieldInliner.hasInitializerInDestructuring((PsiElement)element)) {
            JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message("javascript.refactoring.cannot.inline.destructuring.variable.with.default", new Object[0]));
            return null;
        }
        if (destructuring && ((owner = JSVarOrFieldInliner.findOwner((PsiElement)element)) == null || owner.getInitializer() == null)) {
            JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message("javascript.refactoring.cannot.inline.not.initialized.variable", new Object[0]));
            return null;
        }
        if (destructuring || element.getInitializer() != null) {
            return new MySettings(element, deferredUsages, isInvokedOnReference);
        }
        if (invocationReference != null) {
            JSDefinitionExpression expr = null;
            if (invocationReference instanceof JSReferenceExpression) {
                PsiElement grandParent;
                PsiElement parent = invocationReference.getElement().getParent();
                if (!(parent instanceof JSDefinitionExpression)) {
                    parent = JSVarOrFieldInliner.findDefinition((JSReferenceExpression)invocationReference);
                }
                if (parent instanceof JSDefinitionExpression && (grandParent = parent.getParent()) instanceof JSAssignmentExpression && ((JSAssignmentExpression)grandParent).getROperand() != null) {
                    expr = (JSDefinitionExpression)parent;
                }
            }
            if (expr != null) {
                for (PsiReference ref2 : (Collection)deferredUsages.getValue()) {
                    if (!JSVarOrFieldInliner.referencesOurDefinition(ref2.getElement(), expr)) continue;
                    return new MySettings(expr, deferredUsages, true);
                }
                JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message("javascript.refactoring.cannot.find.usages.of.definition.to.inline", new Object[0]));
                return null;
            }
        }
        JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message("javascript.refactoring.cannot.inline.not.initialized.variable", new Object[0]));
        return null;
    }

    private static void showErrorHint(@NotNull PsiElement element, @Nullable Editor editor, @NlsContexts.DialogMessage @NotNull String message) {
        if (element == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(9);
        }
        if (message == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(10);
        }
        CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)message, (String)JavaScriptBundle.message("javascript.refactoring.inline.variable.title", new Object[0]), (String)"refactoring.inlineVariable");
    }

    @Override
    public void removeDefinition(@NotNull PsiElement element) {
        boolean b;
        JSExpressionStatement expressionStatement;
        JSElement toRemove;
        if (element == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(11);
        }
        if ((toRemove = this.mySettings.getTarget()) instanceof JSDefinitionExpression && (expressionStatement = (JSExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)toRemove, JSExpressionStatement.class)) != null) {
            toRemove = expressionStatement;
        }
        JSInlineHandler.deleteElementWithReformat((PsiElement)toRemove);
        if (element instanceof JSNamedElement && toRemove != element && (b = JSSymbolReferenceCache.calcUnused(element))) {
            JSInlineHandler.deleteElementWithReformat(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSVarOrFieldInliner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSVarOrFieldInliner";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doInlineUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkReadAccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkConflicts";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInlineUsage";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "referencesOurDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDefinition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeDefinition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class MySettings
    extends JSInlineHandler.Settings {
        private final SmartPsiElementPointer<JSNamedElement> myTargetPointer;
        private JSExpression initialized;

        MySettings(JSNamedElement target2, NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean invokedOnReference) {
            super(deferredUsages, invokedOnReference);
            this.myTargetPointer = SmartPointerManager.createPointer((PsiElement)target2);
            if (target2 instanceof JSVariable) {
                this.initialized = JSDestructuringUtil.isDestructuring(target2.getParent()) ? MySettings.createDestructuringTail(target2) : ((JSVariable)target2).getInitializer();
            } else if (target2 instanceof JSDefinitionExpression) {
                this.initialized = ((JSAssignmentExpression)target2.getParent()).getROperand();
            }
            assert (this.initialized != null);
        }

        @NotNull
        private static JSExpression createDestructuringTail(@NotNull JSNamedElement target2) {
            if (target2 == null) {
                MySettings.$$$reportNull$$$0(0);
            }
            JSInitializerOwner owner = JSVarOrFieldInliner.findOwner((PsiElement)target2);
            assert (owner != null);
            JSExpression initializer = owner.getInitializer();
            assert (initializer != null);
            StringBuilder tail = new StringBuilder();
            JSNamedElement element = target2;
            while (element != null) {
                PsiElement parent;
                if (element instanceof JSDestructuringProperty) {
                    ES6ComputedName computedName = ((JSDestructuringProperty)((Object)element)).getComputedPropertyName();
                    if (computedName != null) {
                        tail.insert(0, computedName.getText());
                    } else {
                        tail.insert(0, "." + ((JSDestructuringProperty)((Object)element)).getName());
                    }
                }
                if ((parent = element.getParent()) instanceof JSDestructuringArray) {
                    int index = ArrayUtil.indexOf((Object[])((JSDestructuringArray)parent).getElements(), (Object)element);
                    tail.insert(0, "[" + index + "]");
                }
                element = parent;
            }
            if (!tail.isEmpty() && JSParenthesesUtils.needsParenthesesAsQualifier(initializer)) {
                tail.insert(0, ')').insert(0, initializer.getText()).insert(0, '(');
            } else {
                tail.insert(0, initializer.getText());
            }
            JSExpression jSExpression = JSPsiElementFactory.createJSExpression(tail.toString(), (PsiElement)initializer);
            if (jSExpression == null) {
                MySettings.$$$reportNull$$$0(1);
            }
            return jSExpression;
        }

        public JSNamedElement getTarget() {
            return (JSNamedElement)this.myTargetPointer.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSVarOrFieldInliner$MySettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSVarOrFieldInliner$MySettings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDestructuringTail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createDestructuringTail";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

