/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSSyntaxHighlighterFactory;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSSemanticKeywordHighlighter
implements HighlightVisitor,
DumbAware {
    private static final Class<? extends PsiElement>[] OWNER_CLASSES = new Class[]{JSFile.class, JSEmbeddedContent.class};
    @Nullable
    private JSKeywordHighlighterVisitor myCachedKeywordHighlighterVisitor;
    @Nullable
    private PsiElement myOwnerForCachedVisitor;
    @Nullable
    private HighlightInfoHolder myHolder;

    public boolean suitableForFile(@NotNull PsiFile file) {
        if (file == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(0);
        }
        return file instanceof JSFile || JavaScriptIndex.getFileTypesToIndexJS().contains(file.getFileType());
    }

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(1);
        }
        PsiElement owner = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])OWNER_CLASSES);
        JSKeywordHighlighterVisitor keywordHighlighterVisitor = this.myCachedKeywordHighlighterVisitor;
        HighlightInfoHolder holder = this.myHolder;
        if (owner != this.myOwnerForCachedVisitor && owner != null && holder != null) {
            this.myCachedKeywordHighlighterVisitor = keywordHighlighterVisitor = this.createKeywordHighlightingVisitor(owner, holder);
            this.myOwnerForCachedVisitor = owner;
        }
        if (keywordHighlighterVisitor != null) {
            element.accept((PsiElementVisitor)keywordHighlighterVisitor);
        }
    }

    @NotNull
    private JSKeywordHighlighterVisitor createKeywordHighlightingVisitor(@NotNull PsiElement owner, @NotNull HighlightInfoHolder holder) {
        if (owner == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(3);
        }
        JSAnalysisHandlersFactory factory = JSAnalysisHandlersFactory.forElement(owner);
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement(owner);
        if (dialectOptionHolder == null) {
            dialectOptionHolder = JSSyntaxHighlighterFactory.DEFAULT_HIGHLIGHTER_DIALECT;
        }
        JSKeywordHighlighterVisitor jSKeywordHighlighterVisitor = factory.createKeywordHighlighterVisitor(holder, dialectOptionHolder);
        if (jSKeywordHighlighterVisitor == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(4);
        }
        return jSKeywordHighlighterVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (file == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(6);
        }
        if (action == null) {
            JSSemanticKeywordHighlighter.$$$reportNull$$$0(7);
        }
        this.myHolder = holder;
        this.myOwnerForCachedVisitor = null;
        this.myCachedKeywordHighlighterVisitor = null;
        try {
            action.run();
        }
        finally {
            this.myHolder = null;
            this.myOwnerForCachedVisitor = null;
            this.myCachedKeywordHighlighterVisitor = null;
        }
        return true;
    }

    @NotNull
    public HighlightVisitor clone() {
        return new JSSemanticKeywordHighlighter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSSemanticKeywordHighlighter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSSemanticKeywordHighlighter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeywordHighlightingVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordHighlightingVisitor";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

