/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.IntlBuiltinsFactory;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.intl.JSIntl;
import com.oracle.truffle.js.runtime.util.IntlUtil;

public final class IntlBuiltins
extends JSBuiltinsContainer.SwitchEnum<Intl> {
    public static final JSBuiltinsContainer BUILTINS = new IntlBuiltins();

    protected IntlBuiltins() {
        super(JSIntl.CLASS_NAME, Intl.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, Intl builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return IntlBuiltinsFactory.GetCanonicalLocalesNodeGen.create(context2, builtin, IntlBuiltins.args().fixedArgs(1).createArgumentNodes(context2));
            }
            case 1: {
                return IntlBuiltinsFactory.SupportedValuesOfNodeGen.create(context2, builtin, IntlBuiltins.args().fixedArgs(1).createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum Intl implements BuiltinEnum<Intl>
    {
        getCanonicalLocales(1),
        supportedValuesOf(1);

        private final int length;

        private Intl(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            switch (this.ordinal()) {
                case 0: {
                    return 7;
                }
                case 1: {
                    return 14;
                }
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }

    public static abstract class GetCanonicalLocalesNode
    extends JSBuiltinNode {
        @Node.Child
        JSToCanonicalizedLocaleListNode canonicalizeLocaleListNode;

        public GetCanonicalLocalesNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object getCanonicalLocales(Object locales) {
            if (this.canonicalizeLocaleListNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.canonicalizeLocaleListNode = this.insert(JSToCanonicalizedLocaleListNode.create(this.getContext()));
            }
            String[] languageTags = this.canonicalizeLocaleListNode.executeLanguageTags(locales);
            return JSArray.createConstant(this.getContext(), this.getRealm(), Strings.convertJavaStringArray(languageTags));
        }
    }

    public static abstract class SupportedValuesOfNode
    extends JSBuiltinNode {
        public SupportedValuesOfNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected Object supportedValuesOf(Object keyArg, @Cached JSToStringNode toStringNode, @Cached InlinedBranchProfile errorBranch) {
            String[] list2;
            TruffleString key = toStringNode.executeString(keyArg);
            if (Strings.equals(IntlUtil.KEY_CALENDAR, key)) {
                list2 = IntlUtil.availableCalendars();
            } else if (Strings.equals(IntlUtil.KEY_COLLATION, key)) {
                list2 = IntlUtil.availableCollations();
            } else if (Strings.equals(IntlUtil.KEY_CURRENCY, key)) {
                list2 = IntlUtil.availableCurrencies();
            } else if (Strings.equals(IntlUtil.KEY_NUMBERING_SYSTEM, key)) {
                list2 = IntlUtil.availableNumberingSystems(this.getContext());
            } else if (Strings.equals(IntlUtil.KEY_TIME_ZONE, key)) {
                list2 = IntlUtil.availableTimeZones();
            } else if (Strings.equals(IntlUtil.KEY_UNIT, key)) {
                list2 = IntlUtil.availableUnits();
            } else {
                errorBranch.enter(this);
                throw Errors.createRangeErrorFormat("Invalid key : %s", this, key);
            }
            return JSArray.createConstant(this.getContext(), this.getRealm(), Strings.convertJavaStringArray(list2));
        }
    }
}

