/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.promise.PromiseReactionJobNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

public class TriggerPromiseReactionsNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private PromiseReactionJobNode promiseReactionJob;

    protected TriggerPromiseReactionsNode(JSContext context2) {
        this.context = context2;
        this.promiseReactionJob = PromiseReactionJobNode.create(context2);
    }

    public static TriggerPromiseReactionsNode create(JSContext context2) {
        return new TriggerPromiseReactionsNode(context2);
    }

    public Object execute(Object reactions, Object argument) {
        SimpleArrayList list2 = (SimpleArrayList)reactions;
        for (int i = 0; i < list2.size(); ++i) {
            Object reaction = list2.get(i);
            JSFunctionObject job2 = this.promiseReactionJob.execute(reaction, argument);
            this.context.enqueuePromiseJob(this.getRealm(), job2);
        }
        return Undefined.instance;
    }
}

