/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDifferenceDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalRoundDurationNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.stream.DoubleStream;

public abstract class TemporalDurationAddNode
extends JavaScriptBaseNode {
    @Node.Child
    EnumerableOwnPropertyNamesNode namesNode;

    protected TemporalDurationAddNode() {
        JSContext ctx = JavaScriptLanguage.get(null).getJSContext();
        this.namesNode = EnumerableOwnPropertyNamesNode.createKeys(ctx);
    }

    public abstract JSTemporalDurationRecord execute(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33, double var35, double var37, double var39, JSTemporalCalendarHolder var41, CalendarMethodsRecord var42, TimeZoneMethodsRecord var43, JSTemporalPlainDateTimeObject var44);

    @Specialization
    protected JSTemporalDurationRecord add(double y1, double mon1, double w1, double d1, double h1, double min1, double s1, double ms1, double mus1, double ns1, double y2, double mon2, double w2, double d2, double h2, double min2, double s2, double ms2, double mus2, double ns2, JSTemporalCalendarHolder relativeTo, CalendarMethodsRecord calendarRec, TimeZoneMethodsRecord timeZoneRec, JSTemporalPlainDateTimeObject precalculatedPlainDateTime, @Cached TemporalRoundDurationNode roundDurationNode, @Cached TemporalAddDateNode addDateNode, @Cached TemporalDifferenceDateNode differenceDateNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedBranchProfile relativeToUndefinedBranch, @Cached InlinedBranchProfile relativeToPlainDateBranch, @Cached InlinedBranchProfile relativeToZonedDateTimeBranch, @Cached InlinedConditionProfile largetUnitYMWDProfile) {
        assert (DoubleStream.of(y1, mon1, w1, d1, h1, min1, s1, ms1, mus1, ns1, y2, mon2, w2, d2, h2, min2, s2, ms2, mus2, ns2).allMatch(JSRuntime::isIntegralNumber));
        TemporalUtil.Unit largestUnit1 = TemporalUtil.defaultTemporalLargestUnit(y1, mon1, w1, d1, h1, min1, s1, ms1, mus1);
        TemporalUtil.Unit largestUnit2 = TemporalUtil.defaultTemporalLargestUnit(y2, mon2, w2, d2, h2, min2, s2, ms2, mus2);
        TemporalUtil.Unit largestUnit = TemporalUtil.largerOfTwoTemporalUnits(largestUnit1, largestUnit2);
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (relativeTo == null) {
            relativeToUndefinedBranch.enter(this);
            if (largestUnit == TemporalUtil.Unit.YEAR || largestUnit == TemporalUtil.Unit.MONTH || largestUnit == TemporalUtil.Unit.WEEK) {
                errorBranch.enter(this);
                throw Errors.createRangeError("Largest unit allowed with no relativeTo is 'days'.");
            }
            TimeDurationRecord result2 = TemporalUtil.balanceTimeDuration(d1 + d2, h1 + h2, min1 + min2, s1 + s2, ms1 + ms2, mus1 + mus2, ns1 + ns2, largestUnit);
            return TemporalUtil.createDurationRecord(0.0, 0.0, 0.0, result2.days(), result2.hours(), result2.minutes(), result2.seconds(), result2.milliseconds(), result2.microseconds(), result2.nanoseconds());
        }
        if (relativeTo instanceof JSTemporalPlainDateObject) {
            JSTemporalPlainDateObject plainRelativeTo = (JSTemporalPlainDateObject)relativeTo;
            relativeToPlainDateBranch.enter(this);
            JSTemporalDurationObject dateDuration1 = JSTemporalDuration.createTemporalDuration(ctx, realm, y1, mon1, w1, d1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
            JSTemporalDurationObject dateDuration2 = JSTemporalDuration.createTemporalDuration(ctx, realm, y2, mon2, w2, d2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
            JSTemporalPlainDateObject intermediate = addDateNode.execute(calendarRec, plainRelativeTo, dateDuration1, Undefined.instance);
            JSTemporalPlainDateObject end = addDateNode.execute(calendarRec, intermediate, dateDuration2, Undefined.instance);
            TemporalUtil.Unit dateLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(TemporalUtil.Unit.DAY, largestUnit);
            JSObject differenceOptions = JSOrdinary.createWithNullPrototype(ctx);
            JSObjectUtil.putDataProperty(differenceOptions, TemporalConstants.LARGEST_UNIT, dateLargestUnit.toTruffleString());
            JSTemporalDurationObject dateDifference = differenceDateNode.execute(calendarRec, plainRelativeTo, end, largestUnit, differenceOptions);
            TimeDurationRecord result3 = TemporalUtil.balanceTimeDuration(dateDifference.getDays(), h1 + h2, min1 + min2, s1 + s2, ms1 + ms2, mus1 + mus2, ns1 + ns2, largestUnit);
            return TemporalUtil.createDurationRecord(dateDifference.getYears(), dateDifference.getMonths(), dateDifference.getWeeks(), result3.days(), result3.hours(), result3.minutes(), result3.seconds(), result3.milliseconds(), result3.microseconds(), result3.nanoseconds());
        }
        if (relativeTo instanceof JSTemporalZonedDateTimeObject) {
            JSTemporalZonedDateTimeObject zonedRelativeTo = (JSTemporalZonedDateTimeObject)relativeTo;
            relativeToZonedDateTimeBranch.enter(this);
            BigInt intermediateNs = TemporalUtil.addZonedDateTime(ctx, realm, zonedRelativeTo.getNanoseconds(), timeZoneRec, calendarRec, TemporalUtil.dtol(y1), TemporalUtil.dtol(mon1), TemporalUtil.dtol(w1), TemporalUtil.dtol(d1), TemporalUtil.dtol(h1), TemporalUtil.dtol(min1), TemporalUtil.dtol(s1), TemporalUtil.dtol(ms1), TemporalUtil.dtol(mus1), TemporalUtil.dtol(ns1), precalculatedPlainDateTime);
            BigInt endNs = TemporalUtil.addZonedDateTime(ctx, realm, intermediateNs, timeZoneRec, calendarRec, TemporalUtil.dtol(y2), TemporalUtil.dtol(mon2), TemporalUtil.dtol(w2), TemporalUtil.dtol(d2), TemporalUtil.dtol(h2), TemporalUtil.dtol(min2), TemporalUtil.dtol(s2), TemporalUtil.dtol(ms2), TemporalUtil.dtol(mus2), TemporalUtil.dtol(ns2), precalculatedPlainDateTime);
            if (largetUnitYMWDProfile.profile(this, TemporalUtil.Unit.YEAR != largestUnit && TemporalUtil.Unit.MONTH != largestUnit && TemporalUtil.Unit.WEEK != largestUnit && TemporalUtil.Unit.DAY != largestUnit)) {
                TimeDurationRecord result4 = TemporalUtil.differenceInstant(zonedRelativeTo.getNanoseconds(), endNs, 1.0, TemporalUtil.Unit.NANOSECOND, largestUnit, TemporalUtil.RoundingMode.HALF_EXPAND, roundDurationNode);
                return TemporalUtil.createDurationRecord(0.0, 0.0, 0.0, 0.0, result4.hours(), result4.minutes(), result4.seconds(), result4.milliseconds(), result4.microseconds(), result4.nanoseconds());
            }
            return TemporalUtil.differenceZonedDateTime(ctx, realm, this.namesNode, zonedRelativeTo.getNanoseconds(), endNs, timeZoneRec, calendarRec, largestUnit, precalculatedPlainDateTime);
        }
        throw Errors.shouldNotReachHereUnexpectedValue(relativeTo);
    }
}

