/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.impl;

import java.text.CharacterIterator;
import org.graalvm.shadowed.com.ibm.icu.text.UCharacterIterator;

public class CharacterIteratorWrapper
extends UCharacterIterator {
    private CharacterIterator iterator;

    public CharacterIteratorWrapper(CharacterIterator iter) {
        if (iter == null) {
            throw new IllegalArgumentException();
        }
        this.iterator = iter;
    }

    @Override
    public int current() {
        char c = this.iterator.current();
        if (c == '\uffff') {
            return -1;
        }
        return c;
    }

    @Override
    public int getLength() {
        return this.iterator.getEndIndex() - this.iterator.getBeginIndex();
    }

    @Override
    public int getIndex() {
        return this.iterator.getIndex();
    }

    @Override
    public int next() {
        char i = this.iterator.current();
        this.iterator.next();
        if (i == '\uffff') {
            return -1;
        }
        return i;
    }

    @Override
    public int previous() {
        char i = this.iterator.previous();
        if (i == '\uffff') {
            return -1;
        }
        return i;
    }

    @Override
    public void setIndex(int index) {
        try {
            this.iterator.setIndex(index);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void setToLimit() {
        this.iterator.setIndex(this.iterator.getEndIndex());
    }

    @Override
    public int getText(char[] fillIn, int offset) {
        int length2 = this.iterator.getEndIndex() - this.iterator.getBeginIndex();
        int currentIndex = this.iterator.getIndex();
        if (offset < 0 || offset + length2 > fillIn.length) {
            throw new IndexOutOfBoundsException(Integer.toString(length2));
        }
        char ch = this.iterator.first();
        while (ch != '\uffff') {
            fillIn[offset++] = ch;
            ch = this.iterator.next();
        }
        this.iterator.setIndex(currentIndex);
        return length2;
    }

    @Override
    public Object clone() {
        try {
            CharacterIteratorWrapper result2 = (CharacterIteratorWrapper)super.clone();
            result2.iterator = (CharacterIterator)this.iterator.clone();
            return result2;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public int moveIndex(int delta) {
        int length2 = this.iterator.getEndIndex() - this.iterator.getBeginIndex();
        int idx = this.iterator.getIndex() + delta;
        if (idx < 0) {
            idx = 0;
        } else if (idx > length2) {
            idx = length2;
        }
        return this.iterator.setIndex(idx);
    }

    @Override
    public CharacterIterator getCharacterIterator() {
        return (CharacterIterator)this.iterator.clone();
    }
}

