/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.impl.breakiter;

import java.text.CharacterIterator;
import org.graalvm.shadowed.com.ibm.icu.impl.breakiter.DictionaryMatcher;
import org.graalvm.shadowed.com.ibm.icu.text.UCharacterIterator;
import org.graalvm.shadowed.com.ibm.icu.util.BytesTrie;
import org.graalvm.shadowed.com.ibm.icu.util.CharsTrie;

class CharsDictionaryMatcher
extends DictionaryMatcher {
    private CharSequence characters;

    public CharsDictionaryMatcher(CharSequence chars) {
        this.characters = chars;
    }

    @Override
    public int matches(CharacterIterator text_, int maxLength, int[] lengths, int[] count_, int limit, int[] values) {
        UCharacterIterator text2 = UCharacterIterator.getInstance(text_);
        CharsTrie uct = new CharsTrie(this.characters, 0);
        int c = text2.nextCodePoint();
        if (c == -1) {
            return 0;
        }
        BytesTrie.Result result2 = uct.firstForCodePoint(c);
        int numChars = 1;
        int count = 0;
        while (true) {
            if (result2.hasValue()) {
                if (count < limit) {
                    if (values != null) {
                        values[count] = uct.getValue();
                    }
                    lengths[count] = numChars;
                    ++count;
                }
                if (result2 == BytesTrie.Result.FINAL_VALUE) {
                    break;
                }
            } else if (result2 == BytesTrie.Result.NO_MATCH) break;
            if (numChars >= maxLength || (c = text2.nextCodePoint()) == -1) break;
            ++numChars;
            result2 = uct.nextForCodePoint(c);
        }
        count_[0] = count;
        return numChars;
    }

    @Override
    public int getType() {
        return 1;
    }
}

