/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JN\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u000e\b\u0006\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017H\u0086\b\u00f8\u0001\u0000J\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aR\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"Lcom/intellij/notebooks/ui/visualization/NotebookUtil;", "", "<init>", "()V", "notebookAppearance", "Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearance;", "Lcom/intellij/openapi/editor/Editor;", "getNotebookAppearance", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearance;", "paintNotebookCellBackgroundGutter", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "top", "", "height", "presentationModeMasking", "", "actionBetweenBackgroundAndStripe", "Lkotlin/Function0;", "paintCaretRow", "lines", "Lkotlin/ranges/IntRange;", "intellij.notebooks.ui"})
public final class NotebookUtil {
    @NotNull
    public static final NotebookUtil INSTANCE = new NotebookUtil();

    private NotebookUtil() {
    }

    @NotNull
    public final NotebookEditorAppearance getNotebookAppearance(@NotNull Editor $this$notebookAppearance) {
        Intrinsics.checkNotNullParameter((Object)$this$notebookAppearance, (String)"<this>");
        Object object = NotebookEditorAppearance.Companion.getNOTEBOOK_APPEARANCE_KEY().get((UserDataHolder)$this$notebookAppearance);
        Intrinsics.checkNotNull((Object)object);
        return (NotebookEditorAppearance)object;
    }

    public final void paintNotebookCellBackgroundGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, int top, int height, boolean presentationModeMasking, @NotNull Function0<Unit> actionBetweenBackgroundAndStripe) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter(actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        int diffViewOffset = 6;
        NotebookEditorAppearance appearance = this.getNotebookAppearance((Editor)editor);
        int borderWidth = appearance.getLeftBorderWidth();
        int gutterWidth = editor.getGutterComponentEx().getWidth();
        Triple triple = presentationModeMasking ? new Triple((Object)(r.width - borderWidth - gutterWidth), (Object)gutterWidth, (Object)editor.getColorsScheme().getDefaultBackground()) : new Triple((Object)(r.width - borderWidth), (Object)borderWidth, appearance.getCodeCellBackgroundColor().get());
        int fillX = ((Number)triple.component1()).intValue();
        int fillWidth = ((Number)triple.component2()).intValue();
        Object object = triple.component3();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component3(...)");
        Color fillColor = (Color)object;
        g.setColor(fillColor);
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(fillX + diffViewOffset, top, fillWidth - diffViewOffset, height);
        } else {
            g.fillRect(fillX, top, fillWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
    }

    public static /* synthetic */ void paintNotebookCellBackgroundGutter$default(NotebookUtil $this, EditorImpl editor, Graphics g, Rectangle r, int top, int height, boolean presentationModeMasking, Function0 actionBetweenBackgroundAndStripe, int n, Object object) {
        if ((n & 0x20) != 0) {
            presentationModeMasking = false;
        }
        if ((n & 0x40) != 0) {
            actionBetweenBackgroundAndStripe = paintNotebookCellBackgroundGutter.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        boolean $i$f$paintNotebookCellBackgroundGutter = false;
        int diffViewOffset = 6;
        NotebookEditorAppearance appearance = $this.getNotebookAppearance((Editor)editor);
        int borderWidth = appearance.getLeftBorderWidth();
        int gutterWidth = editor.getGutterComponentEx().getWidth();
        Triple triple = presentationModeMasking ? new Triple((Object)(r.width - borderWidth - gutterWidth), (Object)gutterWidth, (Object)editor.getColorsScheme().getDefaultBackground()) : new Triple((Object)(r.width - borderWidth), (Object)borderWidth, appearance.getCodeCellBackgroundColor().get());
        int fillX = ((Number)triple.component1()).intValue();
        int fillWidth = ((Number)triple.component2()).intValue();
        Object object2 = triple.component3();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component3(...)");
        Color fillColor = (Color)object2;
        g.setColor(fillColor);
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(fillX + diffViewOffset, top, fillWidth - diffViewOffset, height);
        } else {
            g.fillRect(fillX, top, fillWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
    }

    public final void paintCaretRow(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        if (editor.getSettings().isCaretRowShown()) {
            CaretModelImpl caretModelImpl = editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModelImpl, (String)"getCaretModel(...)");
            CaretModelImpl caretModel = caretModelImpl;
            int caretLine = caretModel.getLogicalPosition().line;
            int n = lines.getFirst();
            boolean bl = caretLine <= lines.getLast() ? n <= caretLine : false;
            if (bl) {
                g.setColor(editor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
                g.fillRect(0, editor.visualLineToY(caretModel.getVisualPosition().line), g.getClipBounds().width, editor.getLineHeight());
            }
        }
    }
}

