/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.inlay.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.inlay.JupyterBoundsChangeListener;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellFrameManager;
import com.intellij.notebooks.visualization.ui.EditorCellInput;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.notebooks.visualization.ui.jupyterToolbars.EditorCellActionsToolbarManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookVisibleCellsBatchUpdater;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "bulkUpdateFrames", "", "updateCell", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "dispose", "Companion", "intellij.notebooks.visualization"})
public final class NotebookVisibleCellsBatchUpdater
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private static final Key<NotebookVisibleCellsBatchUpdater> INSTANCE_KEY;

    public NotebookVisibleCellsBatchUpdater(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        JupyterBoundsChangeHandler.Companion.get((Editor)this.editor).subscribe(this, new JupyterBoundsChangeListener(){

            public void boundsChanged() {
                this.bulkUpdateFrames();
            }
        });
    }

    private final void bulkUpdateFrames() {
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)this.editor);
        if (notebookCellInlayManager == null) {
            return;
        }
        NotebookCellInlayManager inlayManager = notebookCellInlayManager;
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        int firstVisibleLine = this.editor.xyToLogicalPosition((Point)new Point((int)0, (int)visibleArea.y)).line;
        int lastVisibleLine = this.editor.xyToLogicalPosition((Point)new Point((int)0, (int)(visibleArea.y + visibleArea.height))).line;
        for (EditorCell cell : inlayManager.getCells()) {
            int firstLine = cell.getInterval().getFirstContentLine();
            int lastLine = cell.getInterval().getLastContentLine();
            if (lastLine < firstVisibleLine) continue;
            if (firstLine > lastVisibleLine) break;
            this.updateCell(cell);
        }
    }

    private final void updateCell(EditorCell cell) {
        block1: {
            Object object;
            Object object2 = cell.getView();
            if (object2 != null && (object2 = ((EditorCellView)object2).getMyEditorCellFrameManager()) != null) {
                ((EditorCellFrameManager)object2).redrawBorders();
            }
            if ((object = cell.getView()) == null || (object = ((EditorCellView)object).getInput()) == null || (object = ((EditorCellInput)object).getCellActionsToolbar()) == null) break block1;
            ((EditorCellActionsToolbarManager)object).updateToolbarPosition();
        }
    }

    public void dispose() {
    }

    static {
        Key key = Key.create((String)"EDITOR_CELL_FRAME_UPDATER_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        INSTANCE_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/notebooks/visualization/ui/NotebookVisibleCellsBatchUpdater$Companion;", "", "<init>", "()V", "INSTANCE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/notebooks/visualization/ui/NotebookVisibleCellsBatchUpdater;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            NotebookVisibleCellsBatchUpdater updater = new NotebookVisibleCellsBatchUpdater(editor);
            editor.putUserData(INSTANCE_KEY, (Object)updater);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)updater);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

