/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkPropertiesPaths;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDockerProcessConnectionData
implements RemoteSdkPropertiesPaths {
    @NotNull
    protected final RemoteSdkAdditionalData myCommonCredentials;

    public AbstractDockerProcessConnectionData(@NotNull RemoteSdkAdditionalData commonCredentials) {
        if (commonCredentials == null) {
            AbstractDockerProcessConnectionData.$$$reportNull$$$0(0);
        }
        this.myCommonCredentials = commonCredentials;
    }

    public String getInterpreterPath() {
        return this.myCommonCredentials.getInterpreterPath();
    }

    public String getHelpersPath() {
        return this.myCommonCredentials.getHelpersPath();
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public DockerCloudConfiguration getAccount() throws RemoteSdkException {
        DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)this.getRemoteServer().getConfiguration();
        if (dockerCloudConfiguration == null) {
            AbstractDockerProcessConnectionData.$$$reportNull$$$0(1);
        }
        return dockerCloudConfiguration;
    }

    @NotNull
    public RemoteServer<DockerCloudConfiguration> getRemoteServer() throws RemoteSdkException {
        String accountName = this.getDockerAccountName();
        if (StringUtil.isEmpty((String)accountName)) {
            throw new RemoteSdkException(DockerBundle.message("AbstractDockerProcessConnectionData.docker.account.specified", new Object[0]));
        }
        RemoteServer result2 = RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        if (result2 == null) {
            throw new RemoteSdkException(DockerBundle.message("AbstractDockerProcessConnectionData.docker.account.found", new Object[0]));
        }
        RemoteServer remoteServer = result2;
        if (remoteServer == null) {
            AbstractDockerProcessConnectionData.$$$reportNull$$$0(2);
        }
        return remoteServer;
    }

    protected abstract String getDockerAccountName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCredentials";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/AbstractDockerProcessConnectionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/AbstractDockerProcessConnectionData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccount";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

