/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.GraphBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface GraphIdentifiable<T> {
    @NotNull
    public T getID();

    public static interface Edge
    extends GraphIdentifiable<Identity> {
        @NotNull
        public static Map<Identity, com.intellij.openapi.graph.base.Edge> findEdgesByIds(@NotNull GraphBuilder<?, ?> builder2, @NotNull Set<Identity> edgeIds) {
            if (builder2 == null) {
                Edge.$$$reportNull$$$0(0);
            }
            if (edgeIds == null) {
                Edge.$$$reportNull$$$0(1);
            }
            HashMap<Identity, com.intellij.openapi.graph.base.Edge> idToEdge = new HashMap<Identity, com.intellij.openapi.graph.base.Edge>();
            EdgeCursor edges = builder2.getGraph().edges();
            while (edges.ok()) {
                com.intellij.openapi.graph.base.Edge edge = edges.edge();
                Identity edgeId = builder2.getEdgeIdentity(edge);
                if (edgeIds.contains(edgeId)) {
                    idToEdge.put(edgeId, edge);
                }
                edges.next();
            }
            HashMap<Identity, com.intellij.openapi.graph.base.Edge> hashMap = idToEdge;
            if (hashMap == null) {
                Edge.$$$reportNull$$$0(2);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "edgeIds";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/GraphIdentifiable$Edge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/GraphIdentifiable$Edge";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findEdgesByIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findEdgesByIds";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        public static interface Identity {
        }

        public static final class OfModelEdge
        implements Identity {
            @NotNull
            private final Object myModelEdge;

            public OfModelEdge(@NotNull Object edge) {
                if (edge == null) {
                    OfModelEdge.$$$reportNull$$$0(0);
                }
                this.myModelEdge = edge;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OfModelEdge edge = (OfModelEdge)o;
                return this.myModelEdge.equals(edge.myModelEdge);
            }

            public int hashCode() {
                return Objects.hash(this.myModelEdge);
            }

            public String toString() {
                return "OfModelEdge{myModelEdge=" + String.valueOf(this.myModelEdge) + "}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/openapi/graph/builder/GraphIdentifiable$Edge$OfModelEdge", "<init>"));
            }
        }

        public static final class OfGraphEdge
        implements Identity {
            @NotNull
            private final com.intellij.openapi.graph.base.Edge myEdge;

            public OfGraphEdge(@NotNull com.intellij.openapi.graph.base.Edge edge) {
                if (edge == null) {
                    OfGraphEdge.$$$reportNull$$$0(0);
                }
                this.myEdge = edge;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OfGraphEdge edge = (OfGraphEdge)o;
                return this.myEdge.equals(edge.myEdge);
            }

            public int hashCode() {
                return Objects.hash(this.myEdge);
            }

            public String toString() {
                return "OfGraphEdge{myEdge=" + String.valueOf(this.myEdge) + "}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/openapi/graph/builder/GraphIdentifiable$Edge$OfGraphEdge", "<init>"));
            }
        }
    }

    public static interface Node
    extends GraphIdentifiable<Identity> {
        @NotNull
        public static Map<Identity, com.intellij.openapi.graph.base.Node> findNodesByIds(@NotNull GraphBuilder<?, ?> builder2, @NotNull Set<Identity> nodeIds) {
            if (builder2 == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (nodeIds == null) {
                Node.$$$reportNull$$$0(1);
            }
            HashMap<Identity, com.intellij.openapi.graph.base.Node> idToNode = new HashMap<Identity, com.intellij.openapi.graph.base.Node>();
            NodeCursor nodes = builder2.getGraph().nodes();
            while (nodes.ok()) {
                com.intellij.openapi.graph.base.Node node = nodes.node();
                Identity nodeId = builder2.getNodeIdentity(node);
                if (nodeIds.contains(nodeId)) {
                    idToNode.put(nodeId, node);
                }
                nodes.next();
            }
            HashMap<Identity, com.intellij.openapi.graph.base.Node> hashMap = idToNode;
            if (hashMap == null) {
                Node.$$$reportNull$$$0(2);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeIds";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/GraphIdentifiable$Node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/GraphIdentifiable$Node";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findNodesByIds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findNodesByIds";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        public static interface Identity {
        }

        public static final class OfModelNode
        implements Identity {
            @NotNull
            private final Object myModelNode;

            public OfModelNode(@NotNull Object node) {
                if (node == null) {
                    OfModelNode.$$$reportNull$$$0(0);
                }
                this.myModelNode = node;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OfModelNode node = (OfModelNode)o;
                return this.myModelNode.equals(node.myModelNode);
            }

            public int hashCode() {
                return Objects.hash(this.myModelNode);
            }

            public String toString() {
                return "OfModelNode{myModelNode=" + String.valueOf(this.myModelNode) + "}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/graph/builder/GraphIdentifiable$Node$OfModelNode", "<init>"));
            }
        }

        public static final class OfGraphNode
        implements Identity {
            @NotNull
            private final com.intellij.openapi.graph.base.Node myNode;

            public OfGraphNode(@NotNull com.intellij.openapi.graph.base.Node node) {
                if (node == null) {
                    OfGraphNode.$$$reportNull$$$0(0);
                }
                this.myNode = node;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                OfGraphNode node = (OfGraphNode)o;
                return this.myNode.equals(node.myNode);
            }

            public int hashCode() {
                return Objects.hash(this.myNode);
            }

            public String toString() {
                return "OfGraphNode{myNode=" + String.valueOf(this.myNode) + "}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/graph/builder/GraphIdentifiable$Node$OfGraphNode", "<init>"));
            }
        }
    }
}

