/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.table.VcsLogCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class RootCellRenderer
extends SimpleColoredRenderer
implements TableCellRenderer,
VcsLogCellRenderer {
    private static final int ROOT_INDICATOR_WHITE_WIDTH = 5;
    private static final int ROOT_INDICATOR_WIDTH = 13;
    private static final int NEW_UI_ROOT_INDICATOR_WIDTH = 10;
    private static final int ROOT_NAME_MAX_WIDTH = 300;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    protected Color myColor;
    @NotNull
    protected Color myBorderColor;
    protected boolean isNarrow;
    @NotNull
    @Nls
    private String myTooltip;

    public RootCellRenderer(@NotNull VcsLogUiProperties properties, @NotNull VcsLogColorManager colorManager) {
        if (properties == null) {
            RootCellRenderer.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            RootCellRenderer.$$$reportNull$$$0(1);
        }
        this.myColor = UIUtil.getTableBackground();
        this.myBorderColor = UIUtil.getTableBackground();
        this.isNarrow = true;
        this.myTooltip = "";
        this.myProperties = properties;
        this.myColorManager = colorManager;
        this.setTextAlign(0);
        this.updateInsets();
    }

    protected void paintBackground(Graphics2D g, int x, int width, int height) {
        g.setColor(this.myColor);
        if (this.isNarrow) {
            g.fillRect(x, 0, width - JBUIScale.scale((int)5), height);
            g.setColor(this.myBorderColor);
            g.fillRect(x + width - JBUIScale.scale((int)5), 0, JBUIScale.scale((int)5), height);
        } else {
            g.fillRect(x, 0, width, height);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.clear();
        FilePath path = (FilePath)value;
        boolean hovered = row == TableHoverListener.getHoveredRow((JTable)table);
        this.myBorderColor = Objects.requireNonNull(((VcsLogGraphTable)((Object)table)).getStyle(row, column, hasFocus, isSelected, hovered).getBackground());
        this.setForeground(UIUtil.getTableForeground((boolean)false, (boolean)hasFocus));
        if (this.isShowRootNames()) {
            if (RootCellRenderer.isTextShown(table, value, row, column)) {
                if (path == null) {
                    this.append("");
                } else {
                    String text = path.getName();
                    int availableWidth = ((VcsLogGraphTable)((Object)table)).getRootColumn().getWidth() - VcsLogUiUtil.getHorizontalTextPadding((SimpleColoredComponent)this);
                    text = VcsLogUiUtil.shortenTextToFit(text, this.getFontMetrics(VcsLogGraphTable.getTableFont()), availableWidth, 0, "\u2026");
                    this.append(text);
                }
            }
            this.isNarrow = false;
        } else {
            this.append("");
            this.isNarrow = true;
        }
        this.myColor = path == null ? UIUtil.getTableBackground((boolean)isSelected, (boolean)hasFocus) : this.myColorManager.getPathColor(path, this.isNarrow ? "default" : "NEW_UI_ROOT_OPEN_STATE");
        this.myTooltip = this.getTooltipText(path, this.isNarrow);
        return this;
    }

    @Override
    @NotNull
    public VcsLogCellController getCellController() {
        return new VcsLogCellController(){

            @Override
            @Nullable
            public Cursor performMouseClick(int row, @NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RootCellRenderer.this.myColorManager.hasMultiplePaths() && RootCellRenderer.this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES)) {
                    VcsLogUsageTriggerCollector.triggerClick("root.column");
                    RootCellRenderer.this.myProperties.set(CommonUiProperties.SHOW_ROOT_NAMES, RootCellRenderer.this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES) == false);
                }
                return null;
            }

            @Override
            @NotNull
            public VcsLogCellController.MouseMoveResult performMouseMove(int row, @NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                VcsLogCellController.MouseMoveResult mouseMoveResult = VcsLogCellController.MouseMoveResult.fromCursor(12);
                if (mouseMoveResult == null) {
                    1.$$$reportNull$$$0(2);
                }
                return mouseMoveResult;
            }

            @Override
            public boolean shouldSelectCell(int row, @NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(3);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/ui/table/RootCellRenderer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/ui/table/RootCellRenderer$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "performMouseMove";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "performMouseClick";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "performMouseMove";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldSelectCell";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public void updateInsets() {
        this.setBorderInsets(this.isShowRootNames() ? this.getRootNameInsets() : JBUI.emptyInsets());
    }

    protected Insets getRootNameInsets() {
        return JBUI.emptyInsets();
    }

    private boolean isShowRootNames() {
        return this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES) && this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES) != false;
    }

    private static boolean isTextShown(JTable table, Object value, int row, int column) {
        int readableRow = ScrollingUtil.getReadableRow((JTable)table, (int)Math.round((float)table.getRowHeight() * 0.5f));
        if (row < readableRow) {
            return false;
        }
        return row == 0 || readableRow == row || !Objects.equals(value, table.getModel().getValueAt(row - 1, column));
    }

    public void setBackground(Color bg) {
        this.myBorderColor = bg;
    }

    public String getToolTipText(MouseEvent event) {
        return this.myTooltip;
    }

    public int getColumnWidth() {
        if (!this.myColorManager.hasMultiplePaths()) {
            return 0;
        }
        if (!this.isShowRootNames()) {
            return JBUIScale.scale((int)(ExperimentalUI.isNewUI() ? 10 : 13));
        }
        Font tableFont = VcsLogGraphTable.getTableFont();
        int textWidth = 0;
        for (FilePath file : this.myColorManager.getPaths()) {
            textWidth = Math.max(this.getFontMetrics(tableFont).stringWidth(file.getName() + "  "), textWidth);
        }
        Insets componentInsets = this.getRootNameInsets();
        int insets = componentInsets.left + componentInsets.right;
        return Math.min(textWidth + insets, JBUIScale.scale((int)300));
    }

    @NotNull
    @Nls
    private String getTooltipText(@Nullable FilePath path, boolean isNarrow) {
        String clickMessage;
        String string = clickMessage = !isNarrow ? VcsLogBundle.message("vcs.log.click.to.collapse.paths.column.tooltip", new Object[0]) : VcsLogBundle.message("vcs.log.click.to.expand.paths.column.tooltip", new Object[0]);
        if (path == null) {
            String string2 = clickMessage;
            if (string2 == null) {
                RootCellRenderer.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String string3 = new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)this.myColorManager.getLongName(path)).bold()).br().append(clickMessage).wrapWith(HtmlChunk.html()).toString();
        if (string3 == null) {
            RootCellRenderer.$$$reportNull$$$0(3);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/RootCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/RootCellRenderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

