/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.kotlin.correctness;

import com.intellij.ml.inline.completion.features.correctness.CorrectnessError;
import com.intellij.ml.inline.completion.features.correctness.OnRangeElementsEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtImportDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/correctness/KotlinImportDirectiveFilteringChecker;", "Lcom/intellij/ml/inline/completion/features/correctness/OnRangeElementsEnrichmentTool;", "<init>", "()V", "runForElement", "", "Lcom/intellij/ml/inline/completion/features/correctness/CorrectnessError;", "originalFile", "Lcom/intellij/psi/PsiFile;", "suggestionOffset", "", "suggestion", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.fullLine.kotlin"})
final class KotlinImportDirectiveFilteringChecker
extends OnRangeElementsEnrichmentTool {
    @NotNull
    public List<CorrectnessError> runForElement(@NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof KtImportDirective)) {
            return CollectionsKt.emptyList();
        }
        TextRange textRange = ((KtImportDirective)element).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextRange textRange2 = this.getLocationInSuggestion(textRange, suggestionOffset, suggestion2);
        if (textRange2 == null) {
            return CollectionsKt.emptyList();
        }
        TextRange errorLocation = textRange2;
        return CollectionsKt.listOf((Object)new CorrectnessError(errorLocation, Severity.CRITICAL, "KT_IMPORT_DIRECTIVE_FILTERING_CHECKER"));
    }
}

