/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.terminal.backend.TerminalContentChangesTrackerKt;
import com.intellij.terminal.backend.TerminalDiscardedHistoryTracker;
import com.intellij.terminal.backend.TerminalDisplayImpl;
import com.intellij.terminal.backend.TerminalDisplayListener;
import com.intellij.terminal.session.TerminalCursorPositionChangedEvent;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/terminal/backend/TerminalCursorPositionTracker;", "", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "discardedHistoryTracker", "Lcom/intellij/terminal/backend/TerminalDiscardedHistoryTracker;", "terminalDisplay", "Lcom/intellij/terminal/backend/TerminalDisplayImpl;", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/intellij/terminal/backend/TerminalDiscardedHistoryTracker;Lcom/intellij/terminal/backend/TerminalDisplayImpl;)V", "cursorX", "", "cursorY", "cursorPositionChanged", "", "getCursorPositionUpdate", "Lcom/intellij/terminal/session/TerminalCursorPositionChangedEvent;", "doGetCursorPositionUpdate", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nTerminalCursorPositionTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCursorPositionTracker.kt\ncom/intellij/terminal/backend/TerminalCursorPositionTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,70:1\n1#2:71\n1104#3,3:72\n*S KotlinDebug\n*F\n+ 1 TerminalCursorPositionTracker.kt\ncom/intellij/terminal/backend/TerminalCursorPositionTracker\n*L\n55#1:72,3\n*E\n"})
public final class TerminalCursorPositionTracker {
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final TerminalDiscardedHistoryTracker discardedHistoryTracker;
    private int cursorX;
    private int cursorY;
    private boolean cursorPositionChanged;

    public TerminalCursorPositionTracker(@NotNull TerminalTextBuffer textBuffer, @NotNull TerminalDiscardedHistoryTracker discardedHistoryTracker, @NotNull TerminalDisplayImpl terminalDisplay) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)discardedHistoryTracker, (String)"discardedHistoryTracker");
        Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
        this.textBuffer = textBuffer;
        this.discardedHistoryTracker = discardedHistoryTracker;
        terminalDisplay.addListener(new TerminalDisplayListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void cursorPositionChanged(int x, int y) {
                void $this$withLock$iv;
                TerminalTextBuffer terminalTextBuffer = textBuffer;
                TerminalCursorPositionTracker terminalCursorPositionTracker = this;
                boolean $i$f$withLock = false;
                $this$withLock$iv.lock();
                try {
                    void it = $this$withLock$iv;
                    boolean bl = false;
                    terminalCursorPositionTracker.cursorX = x;
                    terminalCursorPositionTracker.cursorY = y;
                    terminalCursorPositionTracker.cursorPositionChanged = true;
                    TerminalLine terminalLine = terminalCursorPositionTracker.textBuffer.getLine(y);
                }
                finally {
                    $this$withLock$iv.unlock();
                }
            }
        });
    }

    @Nullable
    public final TerminalCursorPositionChangedEvent getCursorPositionUpdate() {
        return this.cursorPositionChanged ? this.doGetCursorPositionUpdate() : null;
    }

    private final TerminalCursorPositionChangedEvent doGetCursorPositionUpdate() {
        if (!this.cursorPositionChanged) {
            boolean $i$a$-check-TerminalCursorPositionTracker$doGetCursorPositionUpdate$22 = false;
            String $i$a$-check-TerminalCursorPositionTracker$doGetCursorPositionUpdate$22 = "It is expected that this method is called only if something is changed";
            throw new IllegalStateException($i$a$-check-TerminalCursorPositionTracker$doGetCursorPositionUpdate$22.toString());
        }
        int line = this.cursorY;
        String string = this.textBuffer.getLine(line).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        int end = RangesKt.coerceIn((int)this.cursorX, (int)0, (int)text.length());
        CharSequence $this$count$iv = text.subSequence(0, end);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\ue000')) continue;
            ++count$iv;
        }
        int dwcCountBeforeCursor = count$iv;
        int column = this.cursorX - dwcCountBeforeCursor;
        while (line - 1 >= -this.textBuffer.getHistoryLinesCount() && this.textBuffer.getLine(line - 1).isWrapped()) {
            column += TerminalUiUtilsKt.getLengthWithoutDwc(this.textBuffer.getLine(--line));
        }
        int logicalLine = TerminalContentChangesTrackerKt.getLogicalLineIndex(this.textBuffer, line) + this.discardedHistoryTracker.getDiscardedLogicalLinesCount();
        this.cursorPositionChanged = false;
        return new TerminalCursorPositionChangedEvent(logicalLine, column);
    }
}

