/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONParserConfiguration;
import org.json.JSONPointer;
import org.json.JSONPointerException;
import org.json.JSONPropertyIgnore;
import org.json.JSONPropertyName;
import org.json.JSONString;
import org.json.JSONTokener;
import org.json.JSONWriter;
import org.json.NumberConversionUtil;

public class JSONObject {
    static final Pattern NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?");
    private final Map<String, Object> map;
    public static final Object NULL = new Null();

    public Class<? extends Map> getMapType() {
        return this.map.getClass();
    }

    public JSONObject() {
        this.map = new HashMap<String, Object>();
    }

    public JSONObject(JSONObject jo, String ... names) {
        this(names.length);
        for (int i = 0; i < names.length; ++i) {
            try {
                this.putOnce(names[i], jo.opt(names[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            String key2 = x.nextSimpleValue(c).toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            if (key2 != null) {
                if (this.opt(key2) != null) {
                    throw x.syntaxError("Duplicate key \"" + key2 + "\"");
                }
                Object value = x.nextValue();
                if (value != null) {
                    this.put(key2, value);
                }
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    if (x.end()) {
                        throw x.syntaxError("A JSONObject text must end with '}'");
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map<?, ?> m) {
        this(m, 0, new JSONParserConfiguration());
    }

    public JSONObject(Map<?, ?> m, JSONParserConfiguration jsonParserConfiguration) {
        this(m, 0, jsonParserConfiguration);
    }

    private JSONObject(Map<?, ?> m, int recursionDepth, JSONParserConfiguration jsonParserConfiguration) {
        if (recursionDepth > jsonParserConfiguration.getMaxNestingDepth()) {
            throw new JSONException("JSONObject has reached recursion depth limit of " + jsonParserConfiguration.getMaxNestingDepth());
        }
        if (m == null) {
            this.map = new HashMap<String, Object>();
        } else {
            this.map = new HashMap<String, Object>(m.size());
            for (Map.Entry<?, ?> e : m.entrySet()) {
                if (e.getKey() == null) {
                    throw new NullPointerException("Null key.");
                }
                Object value = e.getValue();
                if (value == null) continue;
                JSONObject.testValidity(value);
                this.map.put(String.valueOf(e.getKey()), JSONObject.wrap(value, recursionDepth + 1, jsonParserConfiguration));
            }
        }
    }

    public JSONObject(Object bean) {
        this();
        this.populateMap(bean);
    }

    private JSONObject(Object bean, Set<Object> objectsRecord) {
        this();
        this.populateMap(bean, objectsRecord);
    }

    public JSONObject(Object object, String ... names) {
        this(names.length);
        Class<?> c = object.getClass();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                this.putOpt(name, c.getField(name).get(object));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JSONObject(String source) throws JSONException {
        this(new JSONTokener(source));
    }

    public JSONObject(String baseName, Locale locale) throws JSONException {
        this();
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, Thread.currentThread().getContextClassLoader());
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key2 = keys.nextElement();
            if (key2 == null) continue;
            String[] path = key2.split("\\.");
            int last = path.length - 1;
            JSONObject target = this;
            for (int i = 0; i < last; ++i) {
                String segment = path[i];
                JSONObject nextTarget = target.optJSONObject(segment);
                if (nextTarget == null) {
                    nextTarget = new JSONObject();
                    target.put(segment, nextTarget);
                }
                target = nextTarget;
            }
            target.put(path[last], bundle.getString(key2));
        }
    }

    protected JSONObject(int initialCapacity) {
        this.map = new HashMap<String, Object>(initialCapacity);
    }

    public JSONObject accumulate(String key2, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object object = this.opt(key2);
        if (object == null) {
            this.put(key2, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(value);
        } else {
            this.put(key2, new JSONArray().put(object).put(value));
        }
        return this;
    }

    public JSONObject append(String key2, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object object = this.opt(key2);
        if (object == null) {
            this.put(key2, new JSONArray().put(value));
        } else if (object instanceof JSONArray) {
            this.put(key2, ((JSONArray)object).put(value));
        } else {
            throw JSONObject.wrongValueFormatException(key2, "JSONArray", null, null);
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string2 = Double.toString(d);
        if (string2.indexOf(46) > 0 && string2.indexOf(101) < 0 && string2.indexOf(69) < 0) {
            while (string2.endsWith("0")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    public Object get(String key2) throws JSONException {
        if (key2 == null) {
            throw new JSONException("Null key.");
        }
        Object object = this.opt(key2);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key2) + "] not found.");
        }
        return object;
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key2) throws JSONException {
        E val = this.optEnum(clazz, key2);
        if (val == null) {
            throw JSONObject.wrongValueFormatException(key2, "enum of type " + JSONObject.quote(clazz.getSimpleName()), this.opt(key2), null);
        }
        return val;
    }

    public boolean getBoolean(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw JSONObject.wrongValueFormatException(key2, "Boolean", object, null);
    }

    public BigInteger getBigInteger(String key2) throws JSONException {
        Object object = this.get(key2);
        BigInteger ret = JSONObject.objectToBigInteger(object, null);
        if (ret != null) {
            return ret;
        }
        throw JSONObject.wrongValueFormatException(key2, "BigInteger", object, null);
    }

    public BigDecimal getBigDecimal(String key2) throws JSONException {
        Object object = this.get(key2);
        BigDecimal ret = JSONObject.objectToBigDecimal(object, null);
        if (ret != null) {
            return ret;
        }
        throw JSONObject.wrongValueFormatException(key2, "BigDecimal", object, null);
    }

    public double getDouble(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (Exception e) {
            throw JSONObject.wrongValueFormatException(key2, "double", object, e);
        }
    }

    public float getFloat(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        try {
            return Float.parseFloat(object.toString());
        }
        catch (Exception e) {
            throw JSONObject.wrongValueFormatException(key2, "float", object, e);
        }
    }

    public Number getNumber(String key2) throws JSONException {
        Object object = this.get(key2);
        try {
            if (object instanceof Number) {
                return (Number)object;
            }
            return NumberConversionUtil.stringToNumber(object.toString());
        }
        catch (Exception e) {
            throw JSONObject.wrongValueFormatException(key2, "number", object, e);
        }
    }

    public int getInt(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (Exception e) {
            throw JSONObject.wrongValueFormatException(key2, "int", object, e);
        }
    }

    public JSONArray getJSONArray(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSONObject.wrongValueFormatException(key2, "JSONArray", object, null);
    }

    public JSONObject getJSONObject(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSONObject.wrongValueFormatException(key2, "JSONObject", object, null);
    }

    public long getLong(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (Exception e) {
            throw JSONObject.wrongValueFormatException(key2, "long", object, e);
        }
    }

    public static String[] getNames(JSONObject jo) {
        if (jo.isEmpty()) {
            return null;
        }
        return jo.keySet().toArray(new String[jo.length()]);
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = fields[i].getName();
        }
        return names;
    }

    public String getString(String key2) throws JSONException {
        Object object = this.get(key2);
        if (object instanceof String) {
            return (String)object;
        }
        throw JSONObject.wrongValueFormatException(key2, "string", object, null);
    }

    public boolean has(String key2) {
        return this.map.containsKey(key2);
    }

    public JSONObject increment(String key2) throws JSONException {
        Object value = this.opt(key2);
        if (value == null) {
            this.put(key2, 1);
        } else if (value instanceof Integer) {
            this.put(key2, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.put(key2, (Long)value + 1L);
        } else if (value instanceof BigInteger) {
            this.put(key2, ((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof Float) {
            this.put(key2, ((Float)value).floatValue() + 1.0f);
        } else if (value instanceof Double) {
            this.put(key2, (Double)value + 1.0);
        } else if (value instanceof BigDecimal) {
            this.put(key2, ((BigDecimal)value).add(BigDecimal.ONE));
        } else {
            throw new JSONException("Unable to increment [" + JSONObject.quote(key2) + "].");
        }
        return this;
    }

    public boolean isNull(String key2) {
        return NULL.equals(this.opt(key2));
    }

    public Iterator<String> keys() {
        return this.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    protected Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public int length() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public JSONArray names() {
        if (this.map.isEmpty()) {
            return null;
        }
        return new JSONArray((Collection<?>)this.map.keySet());
    }

    public static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string2 = number.toString();
        if (string2.indexOf(46) > 0 && string2.indexOf(101) < 0 && string2.indexOf(69) < 0) {
            while (string2.endsWith("0")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    public Object opt(String key2) {
        return key2 == null ? null : this.map.get(key2);
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, String key2) {
        return this.optEnum(clazz, key2, null);
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, String key2, E defaultValue) {
        try {
            Object val = this.opt(key2);
            if (NULL.equals(val)) {
                return defaultValue;
            }
            if (clazz.isAssignableFrom(val.getClass())) {
                Enum myE = (Enum)val;
                return (E)myE;
            }
            return Enum.valueOf(clazz, val.toString());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (NullPointerException e) {
            return defaultValue;
        }
    }

    public boolean optBoolean(String key2) {
        return this.optBoolean(key2, false);
    }

    public boolean optBoolean(String key2, boolean defaultValue) {
        Object val = this.opt(key2);
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return this.getBoolean(key2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Boolean optBooleanObject(String key2) {
        return this.optBooleanObject(key2, false);
    }

    public Boolean optBooleanObject(String key2, Boolean defaultValue) {
        Object val = this.opt(key2);
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            return (boolean)((Boolean)val);
        }
        try {
            return this.getBoolean(key2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigDecimal optBigDecimal(String key2, BigDecimal defaultValue) {
        Object val = this.opt(key2);
        return JSONObject.objectToBigDecimal(val, defaultValue);
    }

    static BigDecimal objectToBigDecimal(Object val, BigDecimal defaultValue) {
        return JSONObject.objectToBigDecimal(val, defaultValue, true);
    }

    static BigDecimal objectToBigDecimal(Object val, BigDecimal defaultValue, boolean exact) {
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof BigInteger) {
            return new BigDecimal((BigInteger)val);
        }
        if (val instanceof Double || val instanceof Float) {
            if (!JSONObject.numberIsFinite((Number)val)) {
                return defaultValue;
            }
            if (exact) {
                return new BigDecimal(((Number)val).doubleValue());
            }
            return new BigDecimal(val.toString());
        }
        if (val instanceof Long || val instanceof Integer || val instanceof Short || val instanceof Byte) {
            return new BigDecimal(((Number)val).longValue());
        }
        try {
            return new BigDecimal(val.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public BigInteger optBigInteger(String key2, BigInteger defaultValue) {
        Object val = this.opt(key2);
        return JSONObject.objectToBigInteger(val, defaultValue);
    }

    static BigInteger objectToBigInteger(Object val, BigInteger defaultValue) {
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).toBigInteger();
        }
        if (val instanceof Double || val instanceof Float) {
            if (!JSONObject.numberIsFinite((Number)val)) {
                return defaultValue;
            }
            return new BigDecimal(((Number)val).doubleValue()).toBigInteger();
        }
        if (val instanceof Long || val instanceof Integer || val instanceof Short || val instanceof Byte) {
            return BigInteger.valueOf(((Number)val).longValue());
        }
        try {
            String valStr = val.toString();
            if (JSONObject.isDecimalNotation(valStr)) {
                return new BigDecimal(valStr).toBigInteger();
            }
            return new BigInteger(valStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key2) {
        return this.optDouble(key2, Double.NaN);
    }

    public double optDouble(String key2, double defaultValue) {
        Number val = this.optNumber(key2);
        if (val == null) {
            return defaultValue;
        }
        return val.doubleValue();
    }

    public Double optDoubleObject(String key2) {
        return this.optDoubleObject(key2, Double.NaN);
    }

    public Double optDoubleObject(String key2, Double defaultValue) {
        Number val = this.optNumber(key2);
        if (val == null) {
            return defaultValue;
        }
        return val.doubleValue();
    }

    public float optFloat(String key2) {
        return this.optFloat(key2, Float.NaN);
    }

    public float optFloat(String key2, float defaultValue) {
        Number val = this.optNumber(key2);
        if (val == null) {
            return defaultValue;
        }
        float floatValue = val.floatValue();
        return floatValue;
    }

    public Float optFloatObject(String key2) {
        return this.optFloatObject(key2, Float.valueOf(Float.NaN));
    }

    public Float optFloatObject(String key2, Float defaultValue) {
        Number val = this.optNumber(key2);
        if (val == null) {
            return defaultValue;
        }
        Float floatValue = Float.valueOf(val.floatValue());
        return floatValue;
    }

    public int optInt(String key2) {
        return this.optInt(key2, 0);
    }

    public int optInt(String key2, int defaultValue) {
        Number val = this.optNumber(key2, null);
        if (val == null) {
            return defaultValue;
        }
        return val.intValue();
    }

    public Integer optIntegerObject(String key2) {
        return this.optIntegerObject(key2, 0);
    }

    public Integer optIntegerObject(String key2, Integer defaultValue) {
        Number val = this.optNumber(key2, null);
        if (val == null) {
            return defaultValue;
        }
        return val.intValue();
    }

    public JSONArray optJSONArray(String key2) {
        return this.optJSONArray(key2, null);
    }

    public JSONArray optJSONArray(String key2, JSONArray defaultValue) {
        Object object = this.opt(key2);
        return object instanceof JSONArray ? (JSONArray)object : defaultValue;
    }

    public JSONObject optJSONObject(String key2) {
        return this.optJSONObject(key2, null);
    }

    public JSONObject optJSONObject(String key2, JSONObject defaultValue) {
        Object object = this.opt(key2);
        return object instanceof JSONObject ? (JSONObject)object : defaultValue;
    }

    public long optLong(String key2) {
        return this.optLong(key2, 0L);
    }

    public long optLong(String key2, long defaultValue) {
        Number val = this.optNumber(key2, null);
        if (val == null) {
            return defaultValue;
        }
        return val.longValue();
    }

    public Long optLongObject(String key2) {
        return this.optLongObject(key2, 0L);
    }

    public Long optLongObject(String key2, Long defaultValue) {
        Number val = this.optNumber(key2, null);
        if (val == null) {
            return defaultValue;
        }
        return val.longValue();
    }

    public Number optNumber(String key2) {
        return this.optNumber(key2, null);
    }

    public Number optNumber(String key2, Number defaultValue) {
        Object val = this.opt(key2);
        if (NULL.equals(val)) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return (Number)val;
        }
        try {
            return NumberConversionUtil.stringToNumber(val.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key2) {
        return this.optString(key2, "");
    }

    public String optString(String key2, String defaultValue) {
        Object object = this.opt(key2);
        return NULL.equals(object) ? defaultValue : object.toString();
    }

    private void populateMap(Object bean) {
        this.populateMap(bean, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private void populateMap(Object bean, Set<Object> objectsRecord) {
        Method[] methods;
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        for (Method method : methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods()) {
            String key2;
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || method.getParameterTypes().length != 0 || method.isBridge() || method.getReturnType() == Void.TYPE || !JSONObject.isValidMethodName(method.getName()) || (key2 = JSONObject.getKeyNameFromMethod(method)) == null || key2.isEmpty()) continue;
            try {
                Object result2 = method.invoke(bean, new Object[0]);
                if (result2 == null) continue;
                if (objectsRecord.contains(result2)) {
                    throw JSONObject.recursivelyDefinedObjectException(key2);
                }
                objectsRecord.add(result2);
                JSONObject.testValidity(result2);
                this.map.put(key2, JSONObject.wrap(result2, objectsRecord));
                objectsRecord.remove(result2);
                if (!(result2 instanceof Closeable)) continue;
                try {
                    ((Closeable)result2).close();
                }
                catch (IOException iOException) {}
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private static boolean isValidMethodName(String name) {
        return !"getClass".equals(name) && !"getDeclaringClass".equals(name);
    }

    private static String getKeyNameFromMethod(Method method) {
        String key2;
        int forcedNameDepth;
        int ignoreDepth = JSONObject.getAnnotationDepth(method, JSONPropertyIgnore.class);
        if (ignoreDepth > 0 && ((forcedNameDepth = JSONObject.getAnnotationDepth(method, JSONPropertyName.class)) < 0 || ignoreDepth <= forcedNameDepth)) {
            return null;
        }
        JSONPropertyName annotation = JSONObject.getAnnotation(method, JSONPropertyName.class);
        if (annotation != null && annotation.value() != null && !annotation.value().isEmpty()) {
            return annotation.value();
        }
        String name = method.getName();
        if (name.startsWith("get") && name.length() > 3) {
            key2 = name.substring(3);
        } else if (name.startsWith("is") && name.length() > 2) {
            key2 = name.substring(2);
        } else {
            return null;
        }
        if (key2.length() == 0 || Character.isLowerCase(key2.charAt(0))) {
            return null;
        }
        if (key2.length() == 1) {
            key2 = key2.toLowerCase(Locale.ROOT);
        } else if (!Character.isUpperCase(key2.charAt(1))) {
            key2 = key2.substring(0, 1).toLowerCase(Locale.ROOT) + key2.substring(1);
        }
        return key2;
    }

    private static <A extends Annotation> A getAnnotation(Method m, Class<A> annotationClass) {
        if (m == null || annotationClass == null) {
            return null;
        }
        if (m.isAnnotationPresent(annotationClass)) {
            return m.getAnnotation(annotationClass);
        }
        Class<?> c = m.getDeclaringClass();
        if (c.getSuperclass() == null) {
            return null;
        }
        for (Class<?> i : c.getInterfaces()) {
            try {
                Method im = i.getMethod(m.getName(), m.getParameterTypes());
                return JSONObject.getAnnotation(im, annotationClass);
            }
            catch (SecurityException ex) {
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        if (c.getSuperclass().equals(Object.class)) {
            return null;
        }
        try {
            return JSONObject.getAnnotation(c.getSuperclass().getMethod(m.getName(), m.getParameterTypes()), annotationClass);
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static int getAnnotationDepth(Method m, Class<? extends Annotation> annotationClass) {
        if (m == null || annotationClass == null) {
            return -1;
        }
        if (m.isAnnotationPresent(annotationClass)) {
            return 1;
        }
        Class<?> c = m.getDeclaringClass();
        if (c.getSuperclass() == null) {
            return -1;
        }
        for (Class<?> i : c.getInterfaces()) {
            try {
                Method im = i.getMethod(m.getName(), m.getParameterTypes());
                int d = JSONObject.getAnnotationDepth(im, annotationClass);
                if (d <= 0) continue;
                return d + 1;
            }
            catch (SecurityException ex) {
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        if (c.getSuperclass().equals(Object.class)) {
            return -1;
        }
        try {
            int d = JSONObject.getAnnotationDepth(c.getSuperclass().getMethod(m.getName(), m.getParameterTypes()), annotationClass);
            if (d > 0) {
                return d + 1;
            }
            return -1;
        }
        catch (SecurityException ex) {
            return -1;
        }
        catch (NoSuchMethodException ex) {
            return -1;
        }
    }

    public JSONObject put(String key2, boolean value) throws JSONException {
        return this.put(key2, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONObject put(String key2, Collection<?> value) throws JSONException {
        return this.put(key2, new JSONArray(value));
    }

    public JSONObject put(String key2, double value) throws JSONException {
        return this.put(key2, (Object)value);
    }

    public JSONObject put(String key2, float value) throws JSONException {
        return this.put(key2, Float.valueOf(value));
    }

    public JSONObject put(String key2, int value) throws JSONException {
        return this.put(key2, (Object)value);
    }

    public JSONObject put(String key2, long value) throws JSONException {
        return this.put(key2, (Object)value);
    }

    public JSONObject put(String key2, Map<?, ?> value) throws JSONException {
        return this.put(key2, new JSONObject(value));
    }

    public JSONObject put(String key2, Object value) throws JSONException {
        if (key2 == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.map.put(key2, value);
        } else {
            this.remove(key2);
        }
        return this;
    }

    public JSONObject putOnce(String key2, Object value) throws JSONException {
        if (key2 != null && value != null) {
            if (this.opt(key2) != null) {
                throw new JSONException("Duplicate key \"" + key2 + "\"");
            }
            return this.put(key2, value);
        }
        return this;
    }

    public JSONObject putOpt(String key2, Object value) throws JSONException {
        if (key2 != null && value != null) {
            return this.put(key2, value);
        }
        return this;
    }

    public Object query(String jsonPointer) {
        return this.query(new JSONPointer(jsonPointer));
    }

    public Object query(JSONPointer jsonPointer) {
        return jsonPointer.queryFrom(this);
    }

    public Object optQuery(String jsonPointer) {
        return this.optQuery(new JSONPointer(jsonPointer));
    }

    public Object optQuery(JSONPointer jsonPointer) {
        try {
            return jsonPointer.queryFrom(this);
        }
        catch (JSONPointerException e) {
            return null;
        }
    }

    public static String quote(String string2) {
        StringWriter sw = new StringWriter();
        try {
            return JSONObject.quote(string2, sw).toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    public static Writer quote(String string2, Writer w) throws IOException {
        if (string2 == null || string2.isEmpty()) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string2.length();
        w.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string2.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block9;
                }
                case '\b': {
                    w.write("\\b");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        continue block9;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
        return w;
    }

    public Object remove(String key2) {
        return this.map.remove(key2);
    }

    public boolean similar(Object other) {
        try {
            if (!(other instanceof JSONObject)) {
                return false;
            }
            if (!this.keySet().equals(((JSONObject)other).keySet())) {
                return false;
            }
            for (Map.Entry<String, Object> entry2 : this.entrySet()) {
                Object valueOther;
                String name = entry2.getKey();
                Object valueThis = entry2.getValue();
                if (valueThis == (valueOther = ((JSONObject)other).get(name))) continue;
                if (valueThis == null) {
                    return false;
                }
                if (!(valueThis instanceof JSONObject ? !((JSONObject)valueThis).similar(valueOther) : (valueThis instanceof JSONArray ? !((JSONArray)valueThis).similar(valueOther) : (valueThis instanceof Number && valueOther instanceof Number ? !JSONObject.isNumberSimilar((Number)valueThis, (Number)valueOther) : (valueThis instanceof JSONString && valueOther instanceof JSONString ? !((JSONString)valueThis).toJSONString().equals(((JSONString)valueOther).toJSONString()) : !valueThis.equals(valueOther)))))) continue;
                return false;
            }
            return true;
        }
        catch (Throwable exception) {
            return false;
        }
    }

    static boolean isNumberSimilar(Number l, Number r) {
        if (!JSONObject.numberIsFinite(l) || !JSONObject.numberIsFinite(r)) {
            return false;
        }
        if (l.getClass().equals(r.getClass()) && l instanceof Comparable) {
            int compareTo = ((Comparable)((Object)l)).compareTo(r);
            return compareTo == 0;
        }
        BigDecimal lBigDecimal = JSONObject.objectToBigDecimal(l, null, false);
        BigDecimal rBigDecimal = JSONObject.objectToBigDecimal(r, null, false);
        if (lBigDecimal == null || rBigDecimal == null) {
            return false;
        }
        return lBigDecimal.compareTo(rBigDecimal) == 0;
    }

    private static boolean numberIsFinite(Number n) {
        if (n instanceof Double && (((Double)n).isInfinite() || ((Double)n).isNaN())) {
            return false;
        }
        return !(n instanceof Float) || !((Float)n).isInfinite() && !((Float)n).isNaN();
    }

    protected static boolean isDecimalNotation(String val) {
        return val.indexOf(46) > -1 || val.indexOf(101) > -1 || val.indexOf(69) > -1 || "-0".equals(val);
    }

    public static Object stringToValue(String string2) {
        if ("".equals(string2)) {
            return string2;
        }
        if ("true".equalsIgnoreCase(string2)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string2)) {
            return NULL;
        }
        if (NumberConversionUtil.potentialNumber(string2)) {
            try {
                return NumberConversionUtil.stringToNumber(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public static void testValidity(Object o) throws JSONException {
        if (o instanceof Number && !JSONObject.numberIsFinite((Number)o)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        if (names == null || names.isEmpty()) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        StringWriter w = new StringWriter();
        return this.write(w, indentFactor, 0).toString();
    }

    public static String valueToString(Object value) throws JSONException {
        return JSONWriter.valueToString(value);
    }

    public static Object wrap(Object object) {
        return JSONObject.wrap(object, null);
    }

    static Object wrap(Object object, int recursionDepth, JSONParserConfiguration jsonParserConfiguration) {
        return JSONObject.wrap(object, null, recursionDepth, jsonParserConfiguration);
    }

    private static Object wrap(Object object, Set<Object> objectsRecord) {
        return JSONObject.wrap(object, objectsRecord, 0, new JSONParserConfiguration());
    }

    private static Object wrap(Object object, Set<Object> objectsRecord, int recursionDepth, JSONParserConfiguration jsonParserConfiguration) {
        try {
            String objectPackageName;
            if (NULL.equals(object)) {
                return NULL;
            }
            if (object instanceof JSONObject || object instanceof JSONArray || NULL.equals(object) || object instanceof JSONString || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof BigInteger || object instanceof BigDecimal || object instanceof Enum) {
                return object;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                return new JSONArray(coll, recursionDepth, jsonParserConfiguration);
            }
            if (object.getClass().isArray()) {
                return new JSONArray(object);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                return new JSONObject(map, recursionDepth, jsonParserConfiguration);
            }
            Package objectPackage = object.getClass().getPackage();
            String string2 = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            if (objectsRecord != null) {
                return new JSONObject(object, objectsRecord);
            }
            return new JSONObject(object);
        }
        catch (JSONException exception) {
            throw exception;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        if (value == null || value.equals(null)) {
            writer.write("null");
        } else if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            writer.write(o != null ? o.toString() : JSONObject.quote(value.toString()));
        } else if (value instanceof Number) {
            String numberAsString = JSONObject.numberToString((Number)value);
            if (NUMBER_PATTERN.matcher(numberAsString).matches()) {
                writer.write(numberAsString);
            } else {
                JSONObject.quote(numberAsString, writer);
            }
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof Enum) {
            writer.write(JSONObject.quote(((Enum)value).name()));
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(writer, indentFactor, indent);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(writer, indentFactor, indent);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            new JSONObject(map).write(writer, indentFactor, indent);
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            new JSONArray(coll).write(writer, indentFactor, indent);
        } else if (value.getClass().isArray()) {
            new JSONArray(value).write(writer, indentFactor, indent);
        } else {
            JSONObject.quote(value.toString(), writer);
        }
        return writer;
    }

    static final void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean needsComma = false;
            int length = this.length();
            writer.write(123);
            if (length == 1) {
                Map.Entry<String, Object> entry2 = this.entrySet().iterator().next();
                String key2 = entry2.getKey();
                writer.write(JSONObject.quote(key2));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                try {
                    JSONObject.writeValue(writer, entry2.getValue(), indentFactor, indent);
                }
                catch (Exception e) {
                    throw new JSONException("Unable to write JSONObject value for key: " + key2, e);
                }
            }
            if (length != 0) {
                int newIndent = indent + indentFactor;
                for (Map.Entry<String, Object> entry3 : this.entrySet()) {
                    if (needsComma) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newIndent);
                    String key3 = entry3.getKey();
                    writer.write(JSONObject.quote(key3));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    try {
                        JSONObject.writeValue(writer, entry3.getValue(), indentFactor, newIndent);
                    }
                    catch (Exception e) {
                        throw new JSONException("Unable to write JSONObject value for key: " + key3, e);
                    }
                    needsComma = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry2 : this.entrySet()) {
            Object value = entry2.getValue() == null || NULL.equals(entry2.getValue()) ? null : (entry2.getValue() instanceof JSONObject ? ((JSONObject)entry2.getValue()).toMap() : (entry2.getValue() instanceof JSONArray ? ((JSONArray)entry2.getValue()).toList() : entry2.getValue()));
            results.put(entry2.getKey(), value);
        }
        return results;
    }

    private static JSONException wrongValueFormatException(String key2, String valueType, Object value, Throwable cause) {
        if (value == null) {
            return new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a " + valueType + " (null).", cause);
        }
        if (value instanceof Map || value instanceof Iterable || value instanceof JSONObject) {
            return new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a " + valueType + " (" + value.getClass() + ").", cause);
        }
        return new JSONException("JSONObject[" + JSONObject.quote(key2) + "] is not a " + valueType + " (" + value.getClass() + " : " + value + ").", cause);
    }

    private static JSONException recursivelyDefinedObjectException(String key2) {
        return new JSONException("JavaBean object contains recursively defined member variable of key " + JSONObject.quote(key2));
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "null";
        }
    }
}

