/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webpack;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.webpack.WebpackBundle;
import com.intellij.webpack.jsonschema.WebpackInJavaScriptJsonSchemaProvider;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaComplianceChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebpackConfigHighlightingInspection
extends JSInspection {
    @NlsSafe
    private static final String WEBPACK = "webpack";
    public final List<String> mySkippedFiles = new ArrayList<String>();

    @NotNull
    public String getGroupDisplayName() {
        String string = WebpackBundle.message("js.webpack.config.highlighting.name", new Object[0]);
        if (string == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(1);
        }
        if (super.isSuppressedFor(element)) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        return file != null && this.isFileNameToSkip(file.getName());
    }

    private boolean isFileNameToSkip(String name) {
        if (name == null) {
            return true;
        }
        for (String fileName : this.mySkippedFiles) {
            if (fileName.equals(name)) {
                return true;
            }
            int star = fileName.indexOf(42);
            if (star == -1) continue;
            if (star == 0 && name.endsWith(fileName.substring(1))) {
                return true;
            }
            if (star == fileName.length() - 1 && name.startsWith(fileName.substring(0, fileName.length() - 1))) {
                return true;
            }
            if (fileName.startsWith(fileName.substring(0, star))) {
                return true;
            }
            if (!fileName.endsWith(fileName.substring(star + 1))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"mySkippedFiles", (String)JavaScriptBundle.message((String)"file.name.masks.to.skip.from.analysis", (Object[])new Object[0]))});
        if (optPane == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, final @NotNull LocalInspectionToolSession session) {
        PsiFile psiFile;
        if (holder == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(3);
        }
        if (session == null) {
            WebpackConfigHighlightingInspection.$$$reportNull$$$0(4);
        }
        if (!((psiFile = holder.getFile()) instanceof JSFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                WebpackConfigHighlightingInspection.$$$reportNull$$$0(5);
            }
            return psiElementVisitor;
        }
        final JsonSchemaService service = JsonSchemaService.Impl.get((Project)holder.getProject());
        if (!service.isApplicableToFile(psiFile.getVirtualFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                WebpackConfigHighlightingInspection.$$$reportNull$$$0(6);
            }
            return psiElementVisitor;
        }
        final Ref schemaObjectRef = new Ref();
        return new JSElementVisitor(){

            public void visitJSElement(@NotNull JSElement element) {
                JsonLikePsiWalker walker;
                VirtualFile schemaFile;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((schemaFile = WebpackInJavaScriptJsonSchemaProvider.getSchemaIfApplicable((PsiElement)element)) == null) {
                    return;
                }
                JsonSchemaObject schemaObject = (JsonSchemaObject)schemaObjectRef.get();
                if (schemaObject == null) {
                    schemaObject = service.getSchemaObjectForSchemaFile(schemaFile);
                    if (schemaObject == null) {
                        return;
                    }
                    schemaObjectRef.set((Object)schemaObject);
                }
                if ((walker = JsonLikePsiWalker.getWalker((PsiElement)element, (JsonSchemaObject)schemaObject)) == null) {
                    return;
                }
                new JsonSchemaComplianceChecker(schemaObject, holder, walker, session, JsonComplianceCheckerOptions.RELAX_ENUM_CHECK, "webpack: ").annotate((PsiElement)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/webpack/WebpackConfigHighlightingInspection$1", "visitJSElement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webpack/WebpackConfigHighlightingInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webpack/WebpackConfigHighlightingInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

