/*
 * Decompiled with CFR 0.152.
 */
package ini4idea.inspections;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import ini4idea.IniBundle;
import ini4idea.inspections.IniSuppressForFileFix;
import ini4idea.inspections.IniSuppressInspectionFix;
import ini4idea.lang.psi.IniFile;
import ini4idea.lang.psi.IniProperty;
import ini4idea.lang.psi.IniPsiElement;
import ini4idea.lang.psi.IniSection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IniInspectionSuppressor
implements InspectionSuppressor {
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            IniInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            IniInspectionSuppressor.$$$reportNull$$$0(1);
        }
        return IniInspectionSuppressor.isSuppressed(toolId, element.getContainingFile()) || IniInspectionSuppressor.isSuppressedForParent(element, IniProperty.class, toolId) || IniInspectionSuppressor.isSuppressedForParent(element, IniSection.class, toolId);
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            IniInspectionSuppressor.$$$reportNull$$$0(2);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new IniSuppressForFileFix(toolId), new IniSuppressInspectionFix(toolId, IniSection.class, IniBundle.messagePointer("ini.suppress.for.section.text", new Object[0])), new IniSuppressInspectionFix(toolId, IniProperty.class, IniBundle.messagePointer("ini.suppress.for.property.text", new Object[0]))};
        if (suppressQuickFixArray == null) {
            IniInspectionSuppressor.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    @Nls
    public static String getSuppressionBeginning(Class<? extends PsiElement> psiClass) {
        if (IniProperty.class.isAssignableFrom(psiClass)) {
            return IniBundle.message("ini.suppression.message.part.for.property", new Object[0]);
        }
        if (IniSection.class.isAssignableFrom(psiClass)) {
            return IniBundle.message("ini.suppression.message.part.for.section", new Object[0]);
        }
        throw new IllegalStateException("Unexpected class: " + psiClass.getName());
    }

    public static boolean isSuppressed(String toolId, PsiFile file) {
        if (!(file instanceof IniFile)) {
            return false;
        }
        PsiElement leaf = file.getContainingFile().findElementAt(0);
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getNextSibling();
        }
        while (leaf instanceof PsiComment) {
            @NonNls String text = leaf.getText();
            if (text.contains("suppress") && text.contains("\"" + toolId + "\"") && text.contains("file")) {
                return true;
            }
            if (!((leaf = leaf.getNextSibling()) instanceof PsiWhiteSpace)) continue;
            leaf = leaf.getNextSibling();
        }
        return false;
    }

    private static boolean isSuppressedForParent(PsiElement element, Class<? extends IniPsiElement> parentClass, String toolId) {
        IniPsiElement parent = (IniPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, parentClass, (boolean)false);
        if (parent == null) {
            return false;
        }
        return IniInspectionSuppressor.isSuppressedForElement(parent, toolId);
    }

    private static boolean isSuppressedForElement(IniPsiElement element, String toolId) {
        PsiElement parent;
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling == null && (parent = element.getParent()) != null) {
            prevSibling = parent.getPrevSibling();
        }
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        while (prevSibling != null && !(prevSibling instanceof PsiComment)) {
            prevSibling = prevSibling.getLastChild();
            while (prevSibling instanceof PsiWhiteSpace) {
                prevSibling = prevSibling.getPrevSibling();
            }
        }
        while (prevSibling instanceof PsiComment || prevSibling instanceof PsiWhiteSpace) {
            if (prevSibling instanceof PsiComment && IniInspectionSuppressor.isSuppressedInComment(prevSibling.getText(), element.getClass(), toolId)) {
                return true;
            }
            prevSibling = prevSibling.getPrevSibling();
        }
        return false;
    }

    private static boolean isSuppressedInComment(String commentText, Class<? extends IniPsiElement> parentClass, String toolId) {
        return commentText.contains(IniInspectionSuppressor.getSuppressionBeginning(parentClass)) && commentText.contains(toolId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ini4idea/inspections/IniInspectionSuppressor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ini4idea/inspections/IniInspectionSuppressor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

