/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.CollectionPlatformUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0010J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\u0011\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/collection/CircularIntArray;", "", "minCapacity", "", "(I)V", "capacityBitmask", "elements", "", "first", "getFirst", "()I", "head", "last", "getLast", "tail", "addFirst", "", "element", "addLast", "clear", "doubleCapacity", "get", "index", "isEmpty", "", "popFirst", "popLast", "removeFromEnd", "count", "removeFromStart", "size", "collection"})
@SourceDebugExtension(value={"SMAP\nCircularIntArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CircularIntArray.kt\nandroidx/collection/CircularIntArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CollectionPlatformUtils.jvm.kt\nandroidx/collection/CollectionPlatformUtils\n*L\n1#1,213:1\n1#2:214\n26#3:215\n26#3:216\n26#3:217\n26#3:218\n26#3:219\n26#3:220\n26#3:221\n*S KotlinDebug\n*F\n+ 1 CircularIntArray.kt\nandroidx/collection/CircularIntArray\n*L\n100#1:215\n113#1:216\n139#1:217\n156#1:218\n169#1:219\n181#1:220\n193#1:221\n*E\n"})
public final class CircularIntArray {
    @NotNull
    private int[] elements;
    private int head;
    private int tail;
    private int capacityBitmask;

    @JvmOverloads
    public CircularIntArray(int minCapacity) {
        if (!(minCapacity >= 1)) {
            boolean $i$a$-require-CircularIntArray$32 = false;
            String $i$a$-require-CircularIntArray$32 = "capacity must be >= 1";
            throw new IllegalArgumentException($i$a$-require-CircularIntArray$32.toString());
        }
        if (!(minCapacity <= 0x40000000)) {
            boolean bl = false;
            String string = "capacity must be <= 2^30";
            throw new IllegalArgumentException(string.toString());
        }
        int arrayCapacity = Integer.bitCount(minCapacity) != 1 ? Integer.highestOneBit(minCapacity - 1) << 1 : minCapacity;
        this.capacityBitmask = arrayCapacity - 1;
        this.elements = new int[arrayCapacity];
    }

    public /* synthetic */ CircularIntArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        this(n);
    }

    private final void doubleCapacity() {
        int n = this.elements.length;
        int r = n - this.head;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new RuntimeException("Max array capacity exceeded");
        }
        int[] a = new int[newCapacity];
        ArraysKt.copyInto((int[])this.elements, (int[])a, (int)0, (int)this.head, (int)n);
        ArraysKt.copyInto((int[])this.elements, (int[])a, (int)r, (int)0, (int)this.head);
        this.elements = a;
        this.head = 0;
        this.tail = n;
        this.capacityBitmask = newCapacity - 1;
    }

    public final void addFirst(int element) {
        this.head = this.head - 1 & this.capacityBitmask;
        this.elements[this.head] = element;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public final void addLast(int element) {
        this.elements[this.tail] = element;
        this.tail = this.tail + 1 & this.capacityBitmask;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    public final int popFirst() {
        if (this.head == this.tail) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        int result2 = this.elements[this.head];
        this.head = this.head + 1 & this.capacityBitmask;
        return result2;
    }

    public final int popLast() {
        if (this.head == this.tail) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        int t = this.tail - 1 & this.capacityBitmask;
        int result2 = this.elements[t];
        this.tail = t;
        return result2;
    }

    public final void clear() {
        this.tail = this.head;
    }

    public final void removeFromStart(int count) {
        if (count <= 0) {
            return;
        }
        if (count > this.size()) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        this.head = this.head + count & this.capacityBitmask;
    }

    public final void removeFromEnd(int count) {
        if (count <= 0) {
            return;
        }
        if (count > this.size()) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        this.tail = this.tail - count & this.capacityBitmask;
    }

    public final int getFirst() {
        if (this.head == this.tail) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        return this.elements[this.head];
    }

    public final int getLast() {
        if (this.head == this.tail) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        return this.elements[this.tail - 1 & this.capacityBitmask];
    }

    public final int get(int index2) {
        if (index2 < 0 || index2 >= this.size()) {
            CollectionPlatformUtils this_$iv = CollectionPlatformUtils.INSTANCE;
            boolean $i$f$createIndexOutOfBoundsException$collection = false;
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        return this.elements[this.head + index2 & this.capacityBitmask];
    }

    public final int size() {
        return this.tail - this.head & this.capacityBitmask;
    }

    public final boolean isEmpty() {
        return this.head == this.tail;
    }

    @JvmOverloads
    public CircularIntArray() {
        this(0, 1, null);
    }
}

