/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.util.Url;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001aJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 J\b\u0010$\u001a\u00020%H\u0016J\b\u0010-\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010!\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00000 8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0010R\u0016\u0010(\u001a\u0004\u0018\u00010\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lcom/intellij/javascript/debugger/scripts/FileInfo;", "", "name", "", "url", "Lcom/intellij/util/Url;", "scripts", "", "Lorg/jetbrains/debugger/Script;", "<init>", "(Ljava/lang/String;Lcom/intellij/util/Url;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getUrl", "()Lcom/intellij/util/Url;", "getScripts$intellij_javascript_debugger", "()Ljava/util/List;", "_icon", "Ljavax/swing/Icon;", "get_icon$intellij_javascript_debugger", "()Ljavax/swing/Icon;", "set_icon$intellij_javascript_debugger", "(Ljavax/swing/Icon;)V", "addScript", "", "script", "addScript$intellij_javascript_debugger", "weight", "", "getWeight", "()I", "getScripts", "", "firstScript", "getFirstScript", "()Lorg/jetbrains/debugger/Script;", "hasChildren", "", "children", "getChildren$intellij_javascript_debugger", "singleChild", "getSingleChild", "()Lcom/intellij/javascript/debugger/scripts/FileInfo;", "isFile", "()Z", "getIcon", "intellij.javascript.debugger"})
public class FileInfo {
    @NotNull
    private final String name;
    @NotNull
    private final Url url;
    @NotNull
    private final List<Script> scripts;
    @Nullable
    private Icon _icon;

    public FileInfo(@NotNull String name, @NotNull Url url, @NotNull List<Script> scripts) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(scripts, (String)"scripts");
        this.name = name;
        this.url = url;
        this.scripts = scripts;
    }

    public /* synthetic */ FileInfo(String string, Url url, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        this(string, url, list);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Url getUrl() {
        return this.url;
    }

    @NotNull
    public final List<Script> getScripts$intellij_javascript_debugger() {
        return this.scripts;
    }

    @Nullable
    public final Icon get_icon$intellij_javascript_debugger() {
        return this._icon;
    }

    public final void set_icon$intellij_javascript_debugger(@Nullable Icon icon) {
        this._icon = icon;
    }

    public final void addScript$intellij_javascript_debugger(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        for (Script existingScript : this.scripts) {
            if (!Intrinsics.areEqual((Object)existingScript.getUrl(), (Object)script.getUrl())) continue;
            return;
        }
        this.scripts.add(script);
    }

    public int getWeight() {
        return 10;
    }

    @NotNull
    public final List<Script> getScripts() {
        return this.scripts;
    }

    @NotNull
    public final Script getFirstScript() {
        return this.scripts.get(0);
    }

    public boolean hasChildren() {
        return false;
    }

    @NotNull
    public List<FileInfo> getChildren$intellij_javascript_debugger() {
        return CollectionsKt.emptyList();
    }

    @Nullable
    public FileInfo getSingleChild() {
        return null;
    }

    public boolean isFile() {
        return true;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon;
        if (this._icon == null) {
            this._icon = ScriptsKt.getFileType(this.url).getIcon();
        }
        if (this._icon == null) {
            Icon icon2 = AllIcons.FileTypes.JavaScript;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"JavaScript");
        } else {
            Icon icon3 = this._icon;
            icon = icon3;
            Intrinsics.checkNotNull((Object)icon3);
        }
        return icon;
    }
}

