/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer.actions;

import com.intellij.javascript.debugger.sourcemap.SourceMapFileType;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Urls;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "event", "perform", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.javascript.debugger"})
public abstract class BaseSourceMapAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Logger LOG;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile file = BaseSourceMapAction.Companion.getSourceMapFile(e);
        boolean enabled = file != null && e.getProject() != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile file = BaseSourceMapAction.Companion.getSourceMapFile(event);
        Project project = event.getProject();
        if (file == null || project == null) {
            return;
        }
        Pair<SourceMap, Exception> map = Companion.compute(file);
        if (map.first != null) {
            Object object = map.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            this.perform((SourceMap)object, file, project);
        }
    }

    protected abstract void perform(@NotNull SourceMap var1, @NotNull VirtualFile var2, @NotNull Project var3);

    static {
        Logger logger = Logger.getInstance(VisualizeSourceMapAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/actions/BaseSourceMapAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getSourceMapFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "compute", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "file", "intellij.javascript.debugger"})
    public static final class Companion {
        private Companion() {
        }

        private final VirtualFile getSourceMapFile(AnActionEvent e) {
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            return file == null || file.getFileType() != SourceMapFileType.INSTANCE ? null : file;
        }

        @NotNull
        public final Pair<SourceMap, Exception> compute(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            try {
                String string = VfsUtilCore.loadText((VirtualFile)file);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
                Pair pair = Pair.create((Object)SourceMapDecoderKt.decodeSourceMap((CharSequence)string, arg_0 -> Companion.compute$lambda$0(file, arg_0)), null);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                return pair;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                Pair pair = Pair.create(null, (Object)e);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
                return pair;
            }
        }

        private static final SourceResolver compute$lambda$0(VirtualFile $file, List sourceUrls) {
            Intrinsics.checkNotNullParameter((Object)sourceUrls, (String)"sourceUrls");
            return new SourceResolver(sourceUrls, false, Urls.newLocalFileUrl((VirtualFile)$file), false, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

