/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ConjunctionPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFlipConjunctionIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        IElementType sign = binaryExpression.getOperationSign();
        return JSIntentionBundle.message("bool.flip-conjunction.display-name", sign == JSTokenTypes.ANDAND ? "&&" : "||");
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("bool.flip-conjunction.family-name", new Object[0]);
        if (string == null) {
            JSFlipConjunctionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ConjunctionPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSFlipConjunctionIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSFlipConjunctionIntention.$$$reportNull$$$0(2);
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)element;
        IElementType sign = binaryExpression.getOperationSign();
        JSBinaryExpression exp = ConjunctionPredicate.getTopConjunction(binaryExpression, sign);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)this.flipExpression((JSExpression)exp, sign, binaryExpression.getOperationNode()));
    }

    private String flipExpression(JSExpression exp, IElementType conjunctionType, ASTNode node) {
        if (ConjunctionPredicate.isConjunctionExpression((JSElement)exp, conjunctionType)) {
            JSBinaryExpression andExpression = (JSBinaryExpression)exp;
            return this.flipExpression(andExpression.getROperand(), conjunctionType, node) + " " + node.getText() + " " + this.flipExpression(andExpression.getLOperand(), conjunctionType, node);
        }
        return exp.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/bool/JSFlipConjunctionIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/bool/JSFlipConjunctionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

